# MiniAutoGen: Biblioteca **leve e flexível** para criar agentes e conversas multi-agentes.
![MiniAutoGen Logo](miniautogen.png)

## Sobre o MiniAutoGen

O MiniAutoGen é uma biblioteca open source inovadora, projetada para capacitar aplicações de próxima geração em Modelos de Linguagem de Grande Escala (LLMs) através de conversas multi-agentes. Este framework se destaca por sua estrutura leve e flexível, ideal para desenvolvedores e pesquisadores que buscam explorar e expandir as fronteiras da IA conversacional.

Inspirado no [AutoGen](https://github.com/microsoft/autogen), o MiniAutoGen oferece uma interface de conversação unificada (`chat`), um mecanismo de coordenação (`chatadmin`), personalização de agentes (`agent`) e um pipeline de ações (`pipeline`), todos projetados para facilitar a criação, experimentação e implementação de sistemas multi-agentes.

## Por que MiniAutoGen?

### Conversas Multi-Agentes
Capacite conversas envolvendo múltiplos agentes inteligentes, cada um com habilidades distintas, elevando a complexidade e sofisticação das interações.

### Customização de Agentes
Ajuste os agentes para atender a requisitos específicos, adaptando comportamento, reações e padrões de resposta conforme o necessário.

### Flexibilidade e Modularidade
Com o MiniAutoGen, você tem a liberdade de moldar conversações dinâmicas, permitindo iniciativas de diálogo dos agentes, reações automáticas e intervenções humanas quando necessário.

### Coordenação Eficaz entre Agentes
Utilize nosso framework para que os agentes colaborem eficientemente, visando atingir objetivos comuns em um ambiente partilhado.

## Principais Componentes

### Agent
O núcleo de cada conversa, representando um agente individual com habilidades e comportamentos específicos, essencial para interações dinâmicas e autônomas.

### Chat
Gerencia sessões de chat em grupo, assegurando a manutenção eficaz do estado e contexto da conversa, essencial para a continuidade e coesão das interações.

### ChatAdmin
Um elemento-chave para a coordenação do chat em grupo, sincronizando ações e gerenciando a dinâmica da conversa para garantir uma colaboração eficiente.

### Pipeline
Automatiza e organiza as operações dos agentes, promovendo a escalabilidade e a manutenção facilitada do sistema.

## Contribua com o MiniAutoGen

Como um projeto open source, o MiniAutoGen convida entusiastas de IA, desenvolvedores e pesquisadores para contribuir e ajudar a moldar o futuro das conversas multi-agentes. Seu conhecimento e experiência podem ajudar a expandir as capacidades do MiniAutoGen, criando soluções mais robustas e versáteis para a comunidade de desenvolvedores.

### Como Você Pode Contribuir:
- **Desenvolvimento de Novos Recursos:** Ajude a adicionar novas funcionalidades e aprimorar as existentes.
- **Documentação e Tutoriais:** Contribua com documentação clara e tutoriais para facilitar o uso do framework por novos usuários.
- **Testes e Feedback:** Participe testando o framework e fornecendo feedback valioso para melhorias contínuas.
- **Compartilhamento de Ideias e Experiências:** Partilhe suas experiências e ideias para enriquecer a comunidade e impulsionar inovações.

---

MiniAutoGen: Desenvolvendo hoje o futuro das conversas inteligentes.