# `Chat`

## Overview
The `Chat` class in MiniAutoGen is a crucial component designed to manage and store the state of group chats. It provides functionalities for handling messages, maintaining chat context, and managing agents within a chat session.

## Class Definition

### `class Chat`

#### Description:
The `Chat` class is responsible for managing chat sessions, including message storage, chat context, and agent interactions.

#### Constructor:
##### `__init__(self, storage_path='groupchat_data', custom_df=None)`
- **Purpose**: Initializes a Chat object with a specified storage path and an optional custom DataFrame.
- **Parameters**:
  - `storage_path` (`str`): Path to the storage directory. Defaults to `'groupchat_data'`.
  - `custom_df` (`pandas.DataFrame`): A DataFrame for creating a custom table in storage. Defaults to `None`.

#### Private Methods:
##### `_ensure_storage_directory_exists(self)`
- **Purpose**: Ensures the existence of the storage directory, creating it if necessary.

##### `_load_state(self)`
- **Purpose**: Loads the chat context from a file.
- **Returns**: A dictionary representing the loaded chat context.

#### Public Methods:
##### `persist(self)`
- **Purpose**: Persists the current chat context to a file.

##### `add_message(self, sender_id, message, additional_info=None)`
- **Purpose**: Adds a message to the chat storage.
- **Parameters**:
  - `sender_id` (`str`): ID of the message sender.
  - `message` (`str`): Content of the message.
  - `additional_info` (`dict`, optional): Additional message information. Defaults to `None`.

##### `add_messages(self, messages)`
- **Purpose**: Adds multiple messages to the chat storage.
- **Parameters**:
  - `messages` (`pandas.DataFrame` or `list`): Messages to be added.

##### `remove_message(self, message_id)`
- **Purpose**: Removes a message from the chat storage.
- **Parameters**:
  - `message_id` (`int`): ID of the message to be removed.

##### `get_messages(self, type='dataframe')`
- **Purpose**: Retrieves messages from the chat storage.
- **Parameters**:
  - `type` (`str`): Type of the returned messages (`'dataframe'` or `'json'`). Defaults to `'dataframe'`.
- **Returns**: `pandas.DataFrame` or `list` of messages.

##### `get_current_context(self)`
- **Purpose**: Retrieves the current chat context.
- **Returns**: A dictionary representing the current chat context.

##### `update_context(self, new_context)`
- **Purpose**: Updates the chat context with new values.
- **Parameters**:
  - `new_context` (`dict`): New chat context values.

##### `add_agent(self, agent)`
- **Purpose**: Adds an agent to the chat.
- **Parameters**:
  - `agent` (`Agent`): The agent to be added.

##### `remove_agent(self, agent_id)`
- **Purpose**: Removes an agent from the chat.
- **Parameters**:
  - `agent_id` (`str`): ID of the agent to be removed.

#### Private Helper Methods:
##### `_messages_to_dataframe(self, messages)`
- **Purpose**: Converts messages to a pandas DataFrame.
- **Parameters**:
  - `messages` (`list`): Messages to be converted.
- **Returns**: `pandas.DataFrame` of messages.

##### `_messages_to_json(self, messages)`
- **Purpose**: Converts messages to JSON format.
- **Parameters**:
  - `messages` (`list`): Messages to be converted.
- **Returns**: `list` of messages in JSON format.

## Example Usage

### Initializing a Chat Session
```python
chat_session = Chat(storage_path='my_chat_data')
```

### Adding a Message
```python
chat_session.add_message(sender_id='user123', message='Hello, world!')
```

### Retrieving Messages as DataFrame
```python
messages_df = chat_session.get_messages(type='dataframe')
```

### Updating Chat Context
```python
new_context = {'topic': 'AI'}
chat_session.update_context(new_context)
```

### Adding an Agent
Assuming `agent` is an instance of the `Agent` class:
```python
chat_session.add_agent(agent)
```

## Notes
- Ensure that the storage path provided during initialization is accessible and writable.
- The `Chat` class is designed to interact seamlessly with other components of the MiniAutoGen framework, such as `Agent` and `ChatStorage`.