import { Frame, OnEnter, OnExit, OnRender, OnUpdate, pop, push } from '@core';
import game from '@game';
import { Player, Position } from '@models';

import { MenuState } from './menu';

export class StartState implements OnRender, OnUpdate, OnEnter, OnExit {
  readonly player: Player = new Player();

  readonly #keypress = (event: KeyboardEvent) => {
    /**
     * Example code; can be safely removed.
     */
    switch (event.key) {
      case 'm':
        push(
          new MenuState(
            // title
            'Menu',
            // items
            Array.from(new Array(10000), (_, i) => `Item ${i}`),
            // done callback
            (index) => {
              pop();
              alert(`Chose item ${index}`);
            }
          )
        );
        break;
    }
  };

  public enter(): void {
    document.addEventListener('keypress', this.#keypress);
  }

  public update(frame: Frame): void {
    /**
     * Example code; can be safely removed.
     */
    this.player.update(frame.delta);
  }

  public exit(): void {
    document.removeEventListener('keypress', this.#keypress);
  }

  public render(ctx: CanvasRenderingContext2D): void {
    /**
     * Example code; can be safely removed.
     */
    // Render background
    ctx.fillStyle = '#61C1F2';
    ctx.fillRect(0, 0, ctx.canvas.width, ctx.canvas.height);

    // Render foreground
    ctx.fillStyle = '#29A415';
    ctx.fillRect(
      0,
      ctx.canvas.height / 2,
      ctx.canvas.width,
      ctx.canvas.height / 2
    );

    // Render player
    this.player.render(ctx);

    // Render title
    ctx.fillStyle = '#000000';
    ctx.font = 'bold 32px monospace';
    ctx.textAlign = 'center';
    ctx.fillText('My Awesome Game', ctx.canvas.width / 2, 64);

    // Render key bindings
    ctx.font = 'bold 16px monospace';
    ctx.fillText(
      '[M] - Show Menu',
      ctx.canvas.width / 2,
      ctx.canvas.height - 64
    );
  }
}
