import { Animator } from '@core';
import animators from '@animators';

type PlayerFacing = 'left' | 'right';
type PlayerState = 'idle';

export class Player {
  readonly animator: Animator = animators.player;

  private state: PlayerState = 'idle';
  private facing: PlayerFacing = 'right';

  render(ctx: CanvasRenderingContext2D) {
    ctx.imageSmoothingEnabled = false;

    const scale = 5;
    const size = 16;
    const cx = ctx.canvas.width / 2 - (size * scale) / 2;
    const cy = ctx.canvas.height / 2 - (size * scale) / 2;

    this.animator.render(ctx, {
      x: cx,
      y: cy,
      scaleY: 5,
      scaleX: 5,
    });
  }

  update(delta: number) {
    this.animator.update(delta);
    this.animator.play(`${this.state}_${this.facing}`, true);
  }

  face(facing: PlayerFacing) {
    this.facing = facing;
  }
}
