import { State } from './state';

export class Stack {
  static #instance: Stack = new Stack();
  public static get instance(): Stack {
    return Stack.#instance;
  }

  public get top(): State | null {
    return this.states.length ? this.states[this.states.length - 1] : null;
  }

  public get size(): number {
    return this.states.length;
  }

  #states: State[] = [];
  public get states() {
    return this.#states;
  }

  #queue: { (): void }[] = [];

  public push(state: State): void {
    this.enqueue(() => {
      this.states.push(state);
      state.enter?.();
    });
  }

  public pop(): void {
    this.enqueue(() => {
      const state = this.states.pop();
      state.exit?.();
    });
  }

  public resolve(): void {
    for (const fn of this.#queue) {
      fn();
    }
  }

  private enqueue(fn: () => void) {
    this.#queue.push(fn);
  }
}

export function push(state: State) {
  Stack.instance.push(state);
}

export function pop() {
  Stack.instance.pop();
}
