[![Build status](https://github.com/brndnmtthws/cracking-the-coding-interview-rust/actions/workflows/build-and-test.yml/badge.svg)](https://github.com/brndnmtthws/cracking-the-coding-interview-rust/actions/workflows/build-and-test.yml) [![Dependabot Status](https://api.dependabot.com/badges/status?host=github&repo=brndnmtthws/cracking-the-coding-interview-rust)](https://dependabot.com) [![Coverage Status](https://coveralls.io/repos/github/brndnmtthws/cracking-the-coding-interview-rust/badge.svg?branch=master)](https://coveralls.io/github/brndnmtthws/cracking-the-coding-interview-rust?branch=master)

# Cracking the Coding Interview with Rust

This repository contains code for my YouTube programming interview practice & learning series about [Rust](https://www.rust-lang.org/). The problems are based on the book "Cracking the Coding Interview" by Gayle Laakmann McDowell. You can find the [existing solutions here](https://github.com/careercup/CtCI-6th-Edition).

To follow along, you can:

- [📹 Subscribe to my YouTube channel](https://www.youtube.com/c/BrendenMatthews/live), or
- [🎮 Follow me on Twitch](https://www.twitch.tv/letsmakestuff)

You can find the existing videos on YouTube below:

- [📽 Chapter 1, problems 1-4](https://youtu.be/MoTEALq5UjI)
- [📽 Chapter 1, problems 5-9](https://youtu.be/dTp7d7xqqAo)
- [📽 Chapter 2, problem 1 (part 1)](https://youtu.be/zLuGFOLDA4Q)
- [📽 Chapter 2, problem 1 (part 2)](https://youtu.be/uAV5H1SiPVE)
- [📽 Chapter 2, problems 1-3](https://youtu.be/SdsgfnwPNT4)
- [📽 Chapter 2, problems 4-6](https://youtu.be/V5ngI_V_kI8?t=749)
- [📽 Chapter 2, problems 7-8, Chapter 3, problems 1-2](https://youtu.be/sC9HMy5Tilw)
- [📽 Chapter 3, problems 3-6](https://youtu.be/JRWVesPoIbQ)
- [📽 Chapter 4, problems 1-3](https://youtu.be/EUJAy5_At6o)
- [📽 Chapter 4, problems 4-9](https://youtu.be/Q-Z_B9sZHYc)
- [📽 Chapter 4, problems 10-12, Chapter 5, problems 1-8](https://youtu.be/Evd-z6aGIAA)
- [📽 Chapter 6, problems 1-10](https://youtu.be/1bowu80HSHg)
- [📽 Chapter 7, problems 1-3](https://youtu.be/uOTIWwVtgfI)
- [📽 Chapter 7, problems 4-6](https://youtu.be/lqrUScbFLgQ)
- [📽 Chapter 7, problems 7-9, Part 1](https://youtu.be/mIU-GhHpATg)
- [📽 Chapter 7, problems 7-9, Part 2](https://youtu.be/1FioBErAYew)
- [📽 Chapter 7, problems 10-11](https://youtu.be/P_KrbWKabeA)
- [📽 Chapter 7, problem 12, Chapter 8, problems 1-4](https://youtu.be/W209V_dqakM)
- [📽 Chapter 8, problems 5-11](https://youtu.be/L6GqbfKwldg)
- [📽 Chapter 8, problems 12-14 (part 1)](https://youtu.be/5axLcIOVnbE)
- [📽 Chapter 8, problems 12-14 (part 2)](https://youtu.be/jV5BFjVGftI)
- [📽 Chapter 8, problems 12-14 (part 3)](https://youtu.be/A8pNIwpZdoU)

## Prerequisites

To run the code, you'll need an up-to-date version of Rust. The recommended way of
installing Rust is [using a tool called rustup](https://rustup.rs/):

```ShellSession
$ curl https://sh.rustup.rs -sSf | sh
...
```

Once you have Rust installed, you can build and run the tests.

### Running the Code

```ShellSession
$ cargo build
$ cargo test
...
```
