// eslint-disable
// ⚠️ DO NOT EDIT ⚠️
// This file is automatically generated, run yarn run generate to update

import { gql } from '@apollo/client'
import * as Apollo from '@apollo/client'
export type Maybe<T> = T | null
export type InputMaybe<T> = Maybe<T>
export type Exact<T extends { [key: string]: unknown }> = {
  [K in keyof T]: T[K]
}
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]?: Maybe<T[SubKey]>
}
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
  [SubKey in K]: Maybe<T[SubKey]>
}
const defaultOptions = {} as const
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
  ID: string
  String: string
  Boolean: boolean
  Int: number
  Float: number
  Date: any
}

export type AddBookmarkInput = {
  tag: Scalars['String']
  url: Scalars['String']
}

export type AddPostInput = {
  excerpt?: InputMaybe<Scalars['String']>
  slug: Scalars['String']
  text: Scalars['String']
  title: Scalars['String']
}

export type AddQuestionInput = {
  description?: InputMaybe<Scalars['String']>
  title: Scalars['String']
}

export type AddStackInput = {
  description: Scalars['String']
  image: Scalars['String']
  name: Scalars['String']
  tag?: InputMaybe<Scalars['String']>
  url: Scalars['String']
}

export type Bookmark = {
  __typename?: 'Bookmark'
  createdAt: Scalars['Date']
  description?: Maybe<Scalars['String']>
  faviconUrl?: Maybe<Scalars['String']>
  host: Scalars['String']
  id: Scalars['ID']
  image?: Maybe<Scalars['String']>
  reactionCount?: Maybe<Scalars['Int']>
  tags: Array<Maybe<Tag>>
  title?: Maybe<Scalars['String']>
  updatedAt: Scalars['Date']
  url: Scalars['String']
  viewerHasReacted?: Maybe<Scalars['Boolean']>
}

export type BookmarkEdge = {
  __typename?: 'BookmarkEdge'
  cursor?: Maybe<Scalars['String']>
  node?: Maybe<Bookmark>
}

export type BookmarkFilter = {
  host?: InputMaybe<Scalars['String']>
  tag?: InputMaybe<Scalars['String']>
}

export type BookmarksConnection = {
  __typename?: 'BookmarksConnection'
  edges: Array<Maybe<BookmarkEdge>>
  pageInfo?: Maybe<PageInfo>
}

export type Comment = {
  __typename?: 'Comment'
  author: User
  createdAt: Scalars['Date']
  id: Scalars['ID']
  text?: Maybe<Scalars['String']>
  updatedAt?: Maybe<Scalars['Date']>
  viewerCanDelete?: Maybe<Scalars['Boolean']>
  viewerCanEdit?: Maybe<Scalars['Boolean']>
}

export enum CommentType {
  Bookmark = 'BOOKMARK',
  Post = 'POST',
  Question = 'QUESTION',
  Stack = 'STACK',
}

export type EditBookmarkInput = {
  description?: InputMaybe<Scalars['String']>
  faviconUrl?: InputMaybe<Scalars['String']>
  tag?: InputMaybe<Scalars['String']>
  title: Scalars['String']
}

export type EditPostInput = {
  excerpt?: InputMaybe<Scalars['String']>
  published?: InputMaybe<Scalars['Boolean']>
  slug: Scalars['String']
  text: Scalars['String']
  title: Scalars['String']
}

export type EditQuestionInput = {
  description?: InputMaybe<Scalars['String']>
  title: Scalars['String']
}

export type EditStackInput = {
  description: Scalars['String']
  image: Scalars['String']
  name: Scalars['String']
  tag?: InputMaybe<Scalars['String']>
  url: Scalars['String']
}

export type EditUserInput = {
  email?: InputMaybe<Scalars['String']>
  username?: InputMaybe<Scalars['String']>
}

export type EmailSubscription = {
  __typename?: 'EmailSubscription'
  subscribed?: Maybe<Scalars['Boolean']>
  type?: Maybe<EmailSubscriptionType>
}

export type EmailSubscriptionInput = {
  email?: InputMaybe<Scalars['String']>
  subscribed: Scalars['Boolean']
  type: EmailSubscriptionType
}

export enum EmailSubscriptionType {
  HackerNews = 'HACKER_NEWS',
  Newsletter = 'NEWSLETTER',
}

export type HackerNewsComment = {
  __typename?: 'HackerNewsComment'
  comments?: Maybe<Array<Maybe<HackerNewsComment>>>
  comments_count?: Maybe<Scalars['String']>
  content?: Maybe<Scalars['String']>
  id?: Maybe<Scalars['ID']>
  level?: Maybe<Scalars['Int']>
  time?: Maybe<Scalars['Int']>
  time_ago?: Maybe<Scalars['String']>
  user?: Maybe<Scalars['String']>
}

export type HackerNewsPost = {
  __typename?: 'HackerNewsPost'
  comments?: Maybe<Array<Maybe<HackerNewsComment>>>
  comments_count?: Maybe<Scalars['String']>
  content?: Maybe<Scalars['String']>
  domain?: Maybe<Scalars['String']>
  id?: Maybe<Scalars['ID']>
  time?: Maybe<Scalars['Int']>
  time_ago?: Maybe<Scalars['String']>
  title?: Maybe<Scalars['String']>
  url?: Maybe<Scalars['String']>
  user?: Maybe<Scalars['String']>
}

export type Mutation = {
  __typename?: 'Mutation'
  addBookmark?: Maybe<Bookmark>
  addComment?: Maybe<Comment>
  addPost?: Maybe<Post>
  addQuestion?: Maybe<Question>
  addStack?: Maybe<Stack>
  deleteBookmark?: Maybe<Scalars['Boolean']>
  deleteComment?: Maybe<Scalars['Boolean']>
  deletePost?: Maybe<Scalars['Boolean']>
  deleteQuestion?: Maybe<Scalars['Boolean']>
  deleteStack?: Maybe<Scalars['Boolean']>
  deleteUser?: Maybe<Scalars['Boolean']>
  editBookmark?: Maybe<Bookmark>
  editComment?: Maybe<Comment>
  editEmailSubscription?: Maybe<User>
  editPost?: Maybe<Post>
  editQuestion?: Maybe<Question>
  editStack?: Maybe<Stack>
  editUser?: Maybe<User>
  toggleReaction?: Maybe<Reactable>
  toggleStackUser?: Maybe<Stack>
}

export type MutationAddBookmarkArgs = {
  data: AddBookmarkInput
}

export type MutationAddCommentArgs = {
  refId: Scalars['ID']
  text: Scalars['String']
  type: CommentType
}

export type MutationAddPostArgs = {
  data: AddPostInput
}

export type MutationAddQuestionArgs = {
  data: AddQuestionInput
}

export type MutationAddStackArgs = {
  data: AddStackInput
}

export type MutationDeleteBookmarkArgs = {
  id: Scalars['ID']
}

export type MutationDeleteCommentArgs = {
  id: Scalars['ID']
}

export type MutationDeletePostArgs = {
  id: Scalars['ID']
}

export type MutationDeleteQuestionArgs = {
  id: Scalars['ID']
}

export type MutationDeleteStackArgs = {
  id: Scalars['ID']
}

export type MutationEditBookmarkArgs = {
  data: EditBookmarkInput
  id: Scalars['ID']
}

export type MutationEditCommentArgs = {
  id: Scalars['ID']
  text?: InputMaybe<Scalars['String']>
}

export type MutationEditEmailSubscriptionArgs = {
  data?: InputMaybe<EmailSubscriptionInput>
}

export type MutationEditPostArgs = {
  data: EditPostInput
  id: Scalars['ID']
}

export type MutationEditQuestionArgs = {
  data: EditQuestionInput
  id: Scalars['ID']
}

export type MutationEditStackArgs = {
  data: EditStackInput
  id: Scalars['ID']
}

export type MutationEditUserArgs = {
  data?: InputMaybe<EditUserInput>
}

export type MutationToggleReactionArgs = {
  refId: Scalars['ID']
  type: ReactionType
}

export type MutationToggleStackUserArgs = {
  id: Scalars['ID']
}

export type PageInfo = {
  __typename?: 'PageInfo'
  endCursor?: Maybe<Scalars['String']>
  hasNextPage?: Maybe<Scalars['Boolean']>
  totalCount?: Maybe<Scalars['Int']>
}

export type Post = {
  __typename?: 'Post'
  author?: Maybe<User>
  createdAt?: Maybe<Scalars['Date']>
  excerpt?: Maybe<Scalars['String']>
  featureImage?: Maybe<Scalars['String']>
  id: Scalars['ID']
  publishedAt?: Maybe<Scalars['Date']>
  reactionCount?: Maybe<Scalars['Int']>
  slug?: Maybe<Scalars['String']>
  text?: Maybe<Scalars['String']>
  title?: Maybe<Scalars['String']>
  updatedAt?: Maybe<Scalars['Date']>
  viewerHasReacted?: Maybe<Scalars['Boolean']>
}

export type Query = {
  __typename?: 'Query'
  bookmark?: Maybe<Bookmark>
  bookmarks: BookmarksConnection
  comment?: Maybe<Comment>
  comments: Array<Maybe<Comment>>
  hackerNewsPost?: Maybe<HackerNewsPost>
  hackerNewsPosts: Array<Maybe<HackerNewsPost>>
  post?: Maybe<Post>
  posts: Array<Maybe<Post>>
  question?: Maybe<Question>
  questions: QuestionsConnection
  stack?: Maybe<Stack>
  stacks: StacksConnection
  tags: Array<Maybe<Tag>>
  user?: Maybe<User>
  viewer?: Maybe<User>
}

export type QueryBookmarkArgs = {
  id: Scalars['ID']
}

export type QueryBookmarksArgs = {
  after?: InputMaybe<Scalars['String']>
  filter?: InputMaybe<BookmarkFilter>
  first?: InputMaybe<Scalars['Int']>
}

export type QueryCommentArgs = {
  id: Scalars['ID']
}

export type QueryCommentsArgs = {
  refId: Scalars['ID']
  type: CommentType
}

export type QueryHackerNewsPostArgs = {
  id: Scalars['ID']
}

export type QueryPostArgs = {
  slug: Scalars['String']
}

export type QueryPostsArgs = {
  filter?: InputMaybe<WritingFilter>
}

export type QueryQuestionArgs = {
  id: Scalars['ID']
}

export type QueryQuestionsArgs = {
  after?: InputMaybe<Scalars['String']>
  filter?: InputMaybe<QuestionFilter>
  first?: InputMaybe<Scalars['Int']>
}

export type QueryStackArgs = {
  slug: Scalars['String']
}

export type QueryStacksArgs = {
  after?: InputMaybe<Scalars['String']>
  first?: InputMaybe<Scalars['Int']>
}

export type QueryUserArgs = {
  username: Scalars['String']
}

export type Question = {
  __typename?: 'Question'
  author?: Maybe<User>
  createdAt: Scalars['Date']
  description?: Maybe<Scalars['String']>
  id: Scalars['ID']
  reactionCount?: Maybe<Scalars['Int']>
  status?: Maybe<QuestionStatus>
  title: Scalars['String']
  updatedAt?: Maybe<Scalars['Date']>
  viewerCanComment?: Maybe<Scalars['Boolean']>
  viewerCanEdit?: Maybe<Scalars['Boolean']>
  viewerHasReacted?: Maybe<Scalars['Boolean']>
}

export type QuestionEdge = {
  __typename?: 'QuestionEdge'
  cursor?: Maybe<Scalars['String']>
  node?: Maybe<Question>
}

export type QuestionFilter = {
  status?: InputMaybe<QuestionStatus>
}

export enum QuestionStatus {
  Answered = 'ANSWERED',
  Pending = 'PENDING',
}

export type QuestionsConnection = {
  __typename?: 'QuestionsConnection'
  edges: Array<Maybe<QuestionEdge>>
  pageInfo?: Maybe<PageInfo>
}

export type Reactable = Bookmark | Post | Question | Stack

export enum ReactionType {
  Bookmark = 'BOOKMARK',
  Post = 'POST',
  Question = 'QUESTION',
  Stack = 'STACK',
}

export type Stack = {
  __typename?: 'Stack'
  createdAt: Scalars['Date']
  description?: Maybe<Scalars['String']>
  id: Scalars['ID']
  image?: Maybe<Scalars['String']>
  name: Scalars['String']
  reactionCount?: Maybe<Scalars['Int']>
  slug: Scalars['String']
  tags: Array<Maybe<Tag>>
  updatedAt?: Maybe<Scalars['Date']>
  url: Scalars['String']
  usedBy: Array<Maybe<User>>
  usedByViewer?: Maybe<Scalars['Boolean']>
  viewerHasReacted?: Maybe<Scalars['Boolean']>
}

export type StackEdge = {
  __typename?: 'StackEdge'
  cursor?: Maybe<Scalars['String']>
  node?: Maybe<Stack>
}

export type StacksConnection = {
  __typename?: 'StacksConnection'
  edges: Array<Maybe<StackEdge>>
  pageInfo?: Maybe<PageInfo>
}

export type Tag = {
  __typename?: 'Tag'
  name: Scalars['String']
}

export type User = {
  __typename?: 'User'
  avatar?: Maybe<Scalars['String']>
  createdAt?: Maybe<Scalars['Date']>
  email?: Maybe<Scalars['String']>
  emailSubscriptions?: Maybe<Array<Maybe<EmailSubscription>>>
  id: Scalars['ID']
  isAdmin?: Maybe<Scalars['Boolean']>
  isViewer?: Maybe<Scalars['Boolean']>
  name?: Maybe<Scalars['String']>
  pendingEmail?: Maybe<Scalars['String']>
  role?: Maybe<UserRole>
  username?: Maybe<Scalars['String']>
}

export enum UserRole {
  Admin = 'ADMIN',
  Blocked = 'BLOCKED',
  User = 'USER',
}

export type WritingFilter = {
  published?: InputMaybe<Scalars['Boolean']>
}

export type BookmarkCoreFragment = {
  __typename: 'Bookmark'
  id: string
  url: string
  host: string
  title?: string | null
  description?: string | null
  faviconUrl?: string | null
}

export type BookmarkListItemFragment = {
  __typename: 'Bookmark'
  id: string
  url: string
  host: string
  title?: string | null
  description?: string | null
  faviconUrl?: string | null
}

export type BookmarkDetailFragment = {
  __typename: 'Bookmark'
  reactionCount?: number | null
  viewerHasReacted?: boolean | null
  id: string
  url: string
  host: string
  title?: string | null
  description?: string | null
  faviconUrl?: string | null
  tags: Array<{ __typename?: 'Tag'; name: string } | null>
}

export type BookmarksConnectionFragment = {
  __typename?: 'BookmarksConnection'
  pageInfo?: {
    __typename?: 'PageInfo'
    hasNextPage?: boolean | null
    totalCount?: number | null
    endCursor?: string | null
  } | null
  edges: Array<{
    __typename?: 'BookmarkEdge'
    cursor?: string | null
    node?: {
      __typename: 'Bookmark'
      id: string
      url: string
      host: string
      title?: string | null
      description?: string | null
      faviconUrl?: string | null
    } | null
  } | null>
}

export type CommentInfoFragment = {
  __typename: 'Comment'
  id: string
  createdAt: any
  updatedAt?: any | null
  text?: string | null
  viewerCanEdit?: boolean | null
  viewerCanDelete?: boolean | null
  author: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  }
}

export type HackerNewsListItemInfoFragment = {
  __typename?: 'HackerNewsPost'
  id?: string | null
  title?: string | null
  domain?: string | null
  url?: string | null
}

export type HackerNewsCommentInfoFragment = {
  __typename?: 'HackerNewsComment'
  id?: string | null
  user?: string | null
  comments_count?: string | null
  time_ago?: string | null
  level?: number | null
  content?: string | null
}

export type HackerNewsPostInfoFragment = {
  __typename?: 'HackerNewsPost'
  user?: string | null
  time?: number | null
  time_ago?: string | null
  comments_count?: string | null
  url?: string | null
  domain?: string | null
  content?: string | null
  id?: string | null
  title?: string | null
  comments?: Array<{
    __typename?: 'HackerNewsComment'
    id?: string | null
    user?: string | null
    comments_count?: string | null
    time_ago?: string | null
    level?: number | null
    content?: string | null
    comments?: Array<{
      __typename?: 'HackerNewsComment'
      id?: string | null
      user?: string | null
      comments_count?: string | null
      time_ago?: string | null
      level?: number | null
      content?: string | null
      comments?: Array<{
        __typename?: 'HackerNewsComment'
        id?: string | null
        user?: string | null
        comments_count?: string | null
        time_ago?: string | null
        level?: number | null
        content?: string | null
        comments?: Array<{
          __typename?: 'HackerNewsComment'
          id?: string | null
          user?: string | null
          comments_count?: string | null
          time_ago?: string | null
          level?: number | null
          content?: string | null
        } | null> | null
      } | null> | null
    } | null> | null
  } | null> | null
}

export type PostCoreFragment = {
  __typename: 'Post'
  id: string
  publishedAt?: any | null
  title?: string | null
  slug?: string | null
  excerpt?: string | null
}

export type PostListItemFragment = {
  __typename: 'Post'
  id: string
  publishedAt?: any | null
  title?: string | null
  slug?: string | null
  excerpt?: string | null
}

export type PostDetailFragment = {
  __typename: 'Post'
  text?: string | null
  featureImage?: string | null
  reactionCount?: number | null
  viewerHasReacted?: boolean | null
  id: string
  publishedAt?: any | null
  title?: string | null
  slug?: string | null
  excerpt?: string | null
}

export type QuestionCoreFragment = {
  __typename: 'Question'
  id: string
  title: string
  createdAt: any
  author?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type QuestionListItemFragment = {
  __typename: 'Question'
  id: string
  title: string
  createdAt: any
  author?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type QuestionDetailFragment = {
  __typename: 'Question'
  description?: string | null
  status?: QuestionStatus | null
  viewerCanEdit?: boolean | null
  viewerCanComment?: boolean | null
  reactionCount?: number | null
  viewerHasReacted?: boolean | null
  id: string
  title: string
  createdAt: any
  author?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type QuestionsConnectionFragment = {
  __typename?: 'QuestionsConnection'
  pageInfo?: {
    __typename?: 'PageInfo'
    hasNextPage?: boolean | null
    totalCount?: number | null
    endCursor?: string | null
  } | null
  edges: Array<{
    __typename?: 'QuestionEdge'
    cursor?: string | null
    node?: {
      __typename: 'Question'
      id: string
      title: string
      createdAt: any
      author?: {
        __typename: 'User'
        id: string
        username?: string | null
        avatar?: string | null
        name?: string | null
        role?: UserRole | null
        isViewer?: boolean | null
        isAdmin?: boolean | null
      } | null
    } | null
  } | null>
}

export type StackCoreFragment = {
  __typename: 'Stack'
  id: string
  name: string
  image?: string | null
  url: string
  slug: string
}

export type StackListItemFragment = {
  __typename: 'Stack'
  id: string
  name: string
  image?: string | null
  url: string
  slug: string
}

export type StackDetailFragment = {
  __typename: 'Stack'
  createdAt: any
  description?: string | null
  reactionCount?: number | null
  viewerHasReacted?: boolean | null
  usedByViewer?: boolean | null
  id: string
  name: string
  image?: string | null
  url: string
  slug: string
  usedBy: Array<{
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null>
  tags: Array<{ __typename?: 'Tag'; name: string } | null>
}

export type StacksConnectionFragment = {
  __typename?: 'StacksConnection'
  pageInfo?: {
    __typename?: 'PageInfo'
    hasNextPage?: boolean | null
    totalCount?: number | null
    endCursor?: string | null
  } | null
  edges: Array<{
    __typename?: 'StackEdge'
    cursor?: string | null
    node?: {
      __typename: 'Stack'
      id: string
      name: string
      image?: string | null
      url: string
      slug: string
    } | null
  } | null>
}

export type UserInfoFragment = {
  __typename: 'User'
  id: string
  username?: string | null
  avatar?: string | null
  name?: string | null
  role?: UserRole | null
  isViewer?: boolean | null
  isAdmin?: boolean | null
}

export type UserSettingsFragment = {
  __typename?: 'User'
  email?: string | null
  pendingEmail?: string | null
  emailSubscriptions?: Array<{
    __typename?: 'EmailSubscription'
    type?: EmailSubscriptionType | null
    subscribed?: boolean | null
  } | null> | null
}

export type EditBookmarkMutationVariables = Exact<{
  id: Scalars['ID']
  data: EditBookmarkInput
}>

export type EditBookmarkMutation = {
  __typename?: 'Mutation'
  editBookmark?: {
    __typename: 'Bookmark'
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    url: string
    host: string
    title?: string | null
    description?: string | null
    faviconUrl?: string | null
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type DeleteBookmarkMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type DeleteBookmarkMutation = {
  __typename?: 'Mutation'
  deleteBookmark?: boolean | null
}

export type AddBookmarkMutationVariables = Exact<{
  data: AddBookmarkInput
}>

export type AddBookmarkMutation = {
  __typename?: 'Mutation'
  addBookmark?: {
    __typename: 'Bookmark'
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    url: string
    host: string
    title?: string | null
    description?: string | null
    faviconUrl?: string | null
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type AddCommentMutationVariables = Exact<{
  refId: Scalars['ID']
  type: CommentType
  text: Scalars['String']
}>

export type AddCommentMutation = {
  __typename?: 'Mutation'
  addComment?: {
    __typename: 'Comment'
    id: string
    createdAt: any
    updatedAt?: any | null
    text?: string | null
    viewerCanEdit?: boolean | null
    viewerCanDelete?: boolean | null
    author: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    }
  } | null
}

export type EditCommentMutationVariables = Exact<{
  id: Scalars['ID']
  text: Scalars['String']
}>

export type EditCommentMutation = {
  __typename?: 'Mutation'
  editComment?: {
    __typename: 'Comment'
    id: string
    createdAt: any
    updatedAt?: any | null
    text?: string | null
    viewerCanEdit?: boolean | null
    viewerCanDelete?: boolean | null
    author: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    }
  } | null
}

export type DeleteCommentMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type DeleteCommentMutation = {
  __typename?: 'Mutation'
  deleteComment?: boolean | null
}

export type EditEmailSubscriptionMutationVariables = Exact<{
  data?: InputMaybe<EmailSubscriptionInput>
}>

export type EditEmailSubscriptionMutation = {
  __typename?: 'Mutation'
  editEmailSubscription?: {
    __typename?: 'User'
    emailSubscriptions?: Array<{
      __typename?: 'EmailSubscription'
      subscribed?: boolean | null
      type?: EmailSubscriptionType | null
    } | null> | null
  } | null
}

export type EditPostMutationVariables = Exact<{
  id: Scalars['ID']
  data: EditPostInput
}>

export type EditPostMutation = {
  __typename?: 'Mutation'
  editPost?: {
    __typename: 'Post'
    text?: string | null
    featureImage?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    publishedAt?: any | null
    title?: string | null
    slug?: string | null
    excerpt?: string | null
  } | null
}

export type DeletePostMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type DeletePostMutation = {
  __typename?: 'Mutation'
  deletePost?: boolean | null
}

export type AddPostMutationVariables = Exact<{
  data: AddPostInput
}>

export type AddPostMutation = {
  __typename?: 'Mutation'
  addPost?: {
    __typename: 'Post'
    text?: string | null
    featureImage?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    publishedAt?: any | null
    title?: string | null
    slug?: string | null
    excerpt?: string | null
  } | null
}

export type EditQuestionMutationVariables = Exact<{
  id: Scalars['ID']
  data: EditQuestionInput
}>

export type EditQuestionMutation = {
  __typename?: 'Mutation'
  editQuestion?: {
    __typename: 'Question'
    description?: string | null
    status?: QuestionStatus | null
    viewerCanEdit?: boolean | null
    viewerCanComment?: boolean | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    title: string
    createdAt: any
    author?: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null
  } | null
}

export type DeleteQuestionMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type DeleteQuestionMutation = {
  __typename?: 'Mutation'
  deleteQuestion?: boolean | null
}

export type AddQuestionMutationVariables = Exact<{
  data: AddQuestionInput
}>

export type AddQuestionMutation = {
  __typename?: 'Mutation'
  addQuestion?: {
    __typename: 'Question'
    description?: string | null
    status?: QuestionStatus | null
    viewerCanEdit?: boolean | null
    viewerCanComment?: boolean | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    title: string
    createdAt: any
    author?: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null
  } | null
}

export type ToggleReactionMutationVariables = Exact<{
  refId: Scalars['ID']
  type: ReactionType
}>

export type ToggleReactionMutation = {
  __typename?: 'Mutation'
  toggleReaction?:
    | {
        __typename?: 'Bookmark'
        id: string
        url: string
        reactionCount?: number | null
        viewerHasReacted?: boolean | null
      }
    | {
        __typename?: 'Post'
        id: string
        reactionCount?: number | null
        viewerHasReacted?: boolean | null
      }
    | {
        __typename?: 'Question'
        id: string
        reactionCount?: number | null
        viewerHasReacted?: boolean | null
      }
    | {
        __typename?: 'Stack'
        id: string
        reactionCount?: number | null
        viewerHasReacted?: boolean | null
      }
    | null
}

export type EditStackMutationVariables = Exact<{
  id: Scalars['ID']
  data: EditStackInput
}>

export type EditStackMutation = {
  __typename?: 'Mutation'
  editStack?: {
    __typename: 'Stack'
    createdAt: any
    description?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    usedByViewer?: boolean | null
    id: string
    name: string
    image?: string | null
    url: string
    slug: string
    usedBy: Array<{
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null>
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type DeleteStackMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type DeleteStackMutation = {
  __typename?: 'Mutation'
  deleteStack?: boolean | null
}

export type AddStackMutationVariables = Exact<{
  data: AddStackInput
}>

export type AddStackMutation = {
  __typename?: 'Mutation'
  addStack?: {
    __typename: 'Stack'
    createdAt: any
    description?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    usedByViewer?: boolean | null
    id: string
    name: string
    image?: string | null
    url: string
    slug: string
    usedBy: Array<{
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null>
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type ToggleStackUserMutationVariables = Exact<{
  id: Scalars['ID']
}>

export type ToggleStackUserMutation = {
  __typename?: 'Mutation'
  toggleStackUser?: {
    __typename: 'Stack'
    id: string
    name: string
    image?: string | null
    url: string
    slug: string
    usedBy: Array<{
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null>
  } | null
}

export type DeleteUserMutationVariables = Exact<{ [key: string]: never }>

export type DeleteUserMutation = {
  __typename?: 'Mutation'
  deleteUser?: boolean | null
}

export type EditUserMutationVariables = Exact<{
  data?: InputMaybe<EditUserInput>
}>

export type EditUserMutation = {
  __typename?: 'Mutation'
  editUser?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type GetBookmarksQueryVariables = Exact<{
  first?: InputMaybe<Scalars['Int']>
  after?: InputMaybe<Scalars['String']>
  filter?: InputMaybe<BookmarkFilter>
}>

export type GetBookmarksQuery = {
  __typename?: 'Query'
  bookmarks: {
    __typename?: 'BookmarksConnection'
    pageInfo?: {
      __typename?: 'PageInfo'
      hasNextPage?: boolean | null
      totalCount?: number | null
      endCursor?: string | null
    } | null
    edges: Array<{
      __typename?: 'BookmarkEdge'
      cursor?: string | null
      node?: {
        __typename: 'Bookmark'
        id: string
        url: string
        host: string
        title?: string | null
        description?: string | null
        faviconUrl?: string | null
      } | null
    } | null>
  }
}

export type GetBookmarkQueryVariables = Exact<{
  id: Scalars['ID']
}>

export type GetBookmarkQuery = {
  __typename?: 'Query'
  bookmark?: {
    __typename: 'Bookmark'
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    url: string
    host: string
    title?: string | null
    description?: string | null
    faviconUrl?: string | null
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type GetCommentsQueryVariables = Exact<{
  refId: Scalars['ID']
  type: CommentType
}>

export type GetCommentsQuery = {
  __typename?: 'Query'
  comments: Array<{
    __typename: 'Comment'
    id: string
    createdAt: any
    updatedAt?: any | null
    text?: string | null
    viewerCanEdit?: boolean | null
    viewerCanDelete?: boolean | null
    author: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    }
  } | null>
}

export type GetHackerNewsPostsQueryVariables = Exact<{ [key: string]: never }>

export type GetHackerNewsPostsQuery = {
  __typename?: 'Query'
  hackerNewsPosts: Array<{
    __typename?: 'HackerNewsPost'
    id?: string | null
    title?: string | null
    domain?: string | null
    url?: string | null
  } | null>
}

export type GetHackerNewsPostQueryVariables = Exact<{
  id: Scalars['ID']
}>

export type GetHackerNewsPostQuery = {
  __typename?: 'Query'
  hackerNewsPost?: {
    __typename?: 'HackerNewsPost'
    user?: string | null
    time?: number | null
    time_ago?: string | null
    comments_count?: string | null
    url?: string | null
    domain?: string | null
    content?: string | null
    id?: string | null
    title?: string | null
    comments?: Array<{
      __typename?: 'HackerNewsComment'
      id?: string | null
      user?: string | null
      comments_count?: string | null
      time_ago?: string | null
      level?: number | null
      content?: string | null
      comments?: Array<{
        __typename?: 'HackerNewsComment'
        id?: string | null
        user?: string | null
        comments_count?: string | null
        time_ago?: string | null
        level?: number | null
        content?: string | null
        comments?: Array<{
          __typename?: 'HackerNewsComment'
          id?: string | null
          user?: string | null
          comments_count?: string | null
          time_ago?: string | null
          level?: number | null
          content?: string | null
          comments?: Array<{
            __typename?: 'HackerNewsComment'
            id?: string | null
            user?: string | null
            comments_count?: string | null
            time_ago?: string | null
            level?: number | null
            content?: string | null
          } | null> | null
        } | null> | null
      } | null> | null
    } | null> | null
  } | null
}

export type GetPostsQueryVariables = Exact<{
  filter?: InputMaybe<WritingFilter>
}>

export type GetPostsQuery = {
  __typename?: 'Query'
  posts: Array<{
    __typename: 'Post'
    id: string
    publishedAt?: any | null
    title?: string | null
    slug?: string | null
    excerpt?: string | null
  } | null>
}

export type GetPostQueryVariables = Exact<{
  slug: Scalars['String']
}>

export type GetPostQuery = {
  __typename?: 'Query'
  post?: {
    __typename: 'Post'
    text?: string | null
    featureImage?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    publishedAt?: any | null
    title?: string | null
    slug?: string | null
    excerpt?: string | null
  } | null
}

export type GetQuestionsQueryVariables = Exact<{
  first?: InputMaybe<Scalars['Int']>
  after?: InputMaybe<Scalars['String']>
  filter?: InputMaybe<QuestionFilter>
}>

export type GetQuestionsQuery = {
  __typename?: 'Query'
  questions: {
    __typename?: 'QuestionsConnection'
    pageInfo?: {
      __typename?: 'PageInfo'
      hasNextPage?: boolean | null
      totalCount?: number | null
      endCursor?: string | null
    } | null
    edges: Array<{
      __typename?: 'QuestionEdge'
      cursor?: string | null
      node?: {
        __typename: 'Question'
        id: string
        title: string
        createdAt: any
        author?: {
          __typename: 'User'
          id: string
          username?: string | null
          avatar?: string | null
          name?: string | null
          role?: UserRole | null
          isViewer?: boolean | null
          isAdmin?: boolean | null
        } | null
      } | null
    } | null>
  }
}

export type GetQuestionQueryVariables = Exact<{
  id: Scalars['ID']
}>

export type GetQuestionQuery = {
  __typename?: 'Query'
  question?: {
    __typename: 'Question'
    description?: string | null
    status?: QuestionStatus | null
    viewerCanEdit?: boolean | null
    viewerCanComment?: boolean | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    id: string
    title: string
    createdAt: any
    author?: {
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null
  } | null
}

export type GetStacksQueryVariables = Exact<{
  first?: InputMaybe<Scalars['Int']>
  after?: InputMaybe<Scalars['String']>
}>

export type GetStacksQuery = {
  __typename?: 'Query'
  stacks: {
    __typename?: 'StacksConnection'
    pageInfo?: {
      __typename?: 'PageInfo'
      hasNextPage?: boolean | null
      totalCount?: number | null
      endCursor?: string | null
    } | null
    edges: Array<{
      __typename?: 'StackEdge'
      cursor?: string | null
      node?: {
        __typename: 'Stack'
        id: string
        name: string
        image?: string | null
        url: string
        slug: string
      } | null
    } | null>
  }
}

export type GetStackQueryVariables = Exact<{
  slug: Scalars['String']
}>

export type GetStackQuery = {
  __typename?: 'Query'
  stack?: {
    __typename: 'Stack'
    createdAt: any
    description?: string | null
    reactionCount?: number | null
    viewerHasReacted?: boolean | null
    usedByViewer?: boolean | null
    id: string
    name: string
    image?: string | null
    url: string
    slug: string
    usedBy: Array<{
      __typename: 'User'
      id: string
      username?: string | null
      avatar?: string | null
      name?: string | null
      role?: UserRole | null
      isViewer?: boolean | null
      isAdmin?: boolean | null
    } | null>
    tags: Array<{ __typename?: 'Tag'; name: string } | null>
  } | null
}

export type GetTagsQueryVariables = Exact<{ [key: string]: never }>

export type GetTagsQuery = {
  __typename?: 'Query'
  tags: Array<{ __typename?: 'Tag'; name: string } | null>
}

export type GetUserQueryVariables = Exact<{
  username: Scalars['String']
}>

export type GetUserQuery = {
  __typename?: 'Query'
  user?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type ViewerQueryVariables = Exact<{ [key: string]: never }>

export type ViewerQuery = {
  __typename?: 'Query'
  viewer?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
  } | null
}

export type GetViewerWithSettingsQueryVariables = Exact<{
  [key: string]: never
}>

export type GetViewerWithSettingsQuery = {
  __typename?: 'Query'
  viewer?: {
    __typename: 'User'
    id: string
    username?: string | null
    avatar?: string | null
    name?: string | null
    role?: UserRole | null
    isViewer?: boolean | null
    isAdmin?: boolean | null
    email?: string | null
    pendingEmail?: string | null
    emailSubscriptions?: Array<{
      __typename?: 'EmailSubscription'
      type?: EmailSubscriptionType | null
      subscribed?: boolean | null
    } | null> | null
  } | null
}

export const BookmarkCoreFragmentDoc = gql`
  fragment BookmarkCore on Bookmark {
    __typename
    id
    url
    host
    title
    description
    faviconUrl
  }
`
export const BookmarkDetailFragmentDoc = gql`
  fragment BookmarkDetail on Bookmark {
    ...BookmarkCore
    reactionCount
    viewerHasReacted
    tags {
      name
    }
  }
  ${BookmarkCoreFragmentDoc}
`
export const BookmarkListItemFragmentDoc = gql`
  fragment BookmarkListItem on Bookmark {
    ...BookmarkCore
  }
  ${BookmarkCoreFragmentDoc}
`
export const BookmarksConnectionFragmentDoc = gql`
  fragment BookmarksConnection on BookmarksConnection {
    pageInfo {
      hasNextPage
      totalCount
      endCursor
    }
    edges {
      cursor
      node {
        ...BookmarkListItem
      }
    }
  }
  ${BookmarkListItemFragmentDoc}
`
export const UserInfoFragmentDoc = gql`
  fragment UserInfo on User {
    __typename
    id
    username
    avatar
    name
    role
    isViewer
    isAdmin
  }
`
export const CommentInfoFragmentDoc = gql`
  fragment CommentInfo on Comment {
    __typename
    id
    createdAt
    updatedAt
    text
    viewerCanEdit
    viewerCanDelete
    author {
      ...UserInfo
    }
  }
  ${UserInfoFragmentDoc}
`
export const HackerNewsListItemInfoFragmentDoc = gql`
  fragment HackerNewsListItemInfo on HackerNewsPost {
    id
    title
    domain
    url
  }
`
export const HackerNewsCommentInfoFragmentDoc = gql`
  fragment HackerNewsCommentInfo on HackerNewsComment {
    id
    user
    comments_count
    time_ago
    level
    content
  }
`
export const HackerNewsPostInfoFragmentDoc = gql`
  fragment HackerNewsPostInfo on HackerNewsPost {
    ...HackerNewsListItemInfo
    user
    time
    time_ago
    comments_count
    url
    domain
    content
    comments {
      ...HackerNewsCommentInfo
      comments {
        ...HackerNewsCommentInfo
        comments {
          ...HackerNewsCommentInfo
          comments {
            ...HackerNewsCommentInfo
          }
        }
      }
    }
  }
  ${HackerNewsListItemInfoFragmentDoc}
  ${HackerNewsCommentInfoFragmentDoc}
`
export const PostCoreFragmentDoc = gql`
  fragment PostCore on Post {
    __typename
    id
    publishedAt
    title
    slug
    excerpt
  }
`
export const PostListItemFragmentDoc = gql`
  fragment PostListItem on Post {
    ...PostCore
  }
  ${PostCoreFragmentDoc}
`
export const PostDetailFragmentDoc = gql`
  fragment PostDetail on Post {
    ...PostCore
    text
    featureImage
    reactionCount
    viewerHasReacted
  }
  ${PostCoreFragmentDoc}
`
export const QuestionCoreFragmentDoc = gql`
  fragment QuestionCore on Question {
    __typename
    id
    title
    createdAt
    author {
      ...UserInfo
    }
  }
  ${UserInfoFragmentDoc}
`
export const QuestionDetailFragmentDoc = gql`
  fragment QuestionDetail on Question {
    ...QuestionCore
    description
    status
    viewerCanEdit
    viewerCanComment
    reactionCount
    viewerHasReacted
  }
  ${QuestionCoreFragmentDoc}
`
export const QuestionListItemFragmentDoc = gql`
  fragment QuestionListItem on Question {
    ...QuestionCore
  }
  ${QuestionCoreFragmentDoc}
`
export const QuestionsConnectionFragmentDoc = gql`
  fragment QuestionsConnection on QuestionsConnection {
    pageInfo {
      hasNextPage
      totalCount
      endCursor
    }
    edges {
      cursor
      node {
        ...QuestionListItem
      }
    }
  }
  ${QuestionListItemFragmentDoc}
`
export const StackCoreFragmentDoc = gql`
  fragment StackCore on Stack {
    __typename
    id
    name
    image
    url
    slug
  }
`
export const StackDetailFragmentDoc = gql`
  fragment StackDetail on Stack {
    ...StackCore
    createdAt
    description
    reactionCount
    viewerHasReacted
    usedByViewer
    usedBy {
      ...UserInfo
    }
    tags {
      name
    }
  }
  ${StackCoreFragmentDoc}
  ${UserInfoFragmentDoc}
`
export const StackListItemFragmentDoc = gql`
  fragment StackListItem on Stack {
    ...StackCore
  }
  ${StackCoreFragmentDoc}
`
export const StacksConnectionFragmentDoc = gql`
  fragment StacksConnection on StacksConnection {
    pageInfo {
      hasNextPage
      totalCount
      endCursor
    }
    edges {
      cursor
      node {
        ...StackListItem
      }
    }
  }
  ${StackListItemFragmentDoc}
`
export const UserSettingsFragmentDoc = gql`
  fragment UserSettings on User {
    email
    pendingEmail
    emailSubscriptions {
      type
      subscribed
    }
  }
`
export const EditBookmarkDocument = gql`
  mutation editBookmark($id: ID!, $data: EditBookmarkInput!) {
    editBookmark(id: $id, data: $data) {
      ...BookmarkDetail
    }
  }
  ${BookmarkDetailFragmentDoc}
`
export type EditBookmarkMutationFn = Apollo.MutationFunction<
  EditBookmarkMutation,
  EditBookmarkMutationVariables
>

/**
 * __useEditBookmarkMutation__
 *
 * To run a mutation, you first call `useEditBookmarkMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditBookmarkMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editBookmarkMutation, { data, loading, error }] = useEditBookmarkMutation({
 *   variables: {
 *      id: // value for 'id'
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditBookmarkMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditBookmarkMutation,
    EditBookmarkMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    EditBookmarkMutation,
    EditBookmarkMutationVariables
  >(EditBookmarkDocument, options)
}
export type EditBookmarkMutationHookResult = ReturnType<
  typeof useEditBookmarkMutation
>
export type EditBookmarkMutationResult =
  Apollo.MutationResult<EditBookmarkMutation>
export type EditBookmarkMutationOptions = Apollo.BaseMutationOptions<
  EditBookmarkMutation,
  EditBookmarkMutationVariables
>
export const DeleteBookmarkDocument = gql`
  mutation deleteBookmark($id: ID!) {
    deleteBookmark(id: $id)
  }
`
export type DeleteBookmarkMutationFn = Apollo.MutationFunction<
  DeleteBookmarkMutation,
  DeleteBookmarkMutationVariables
>

/**
 * __useDeleteBookmarkMutation__
 *
 * To run a mutation, you first call `useDeleteBookmarkMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteBookmarkMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteBookmarkMutation, { data, loading, error }] = useDeleteBookmarkMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteBookmarkMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteBookmarkMutation,
    DeleteBookmarkMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    DeleteBookmarkMutation,
    DeleteBookmarkMutationVariables
  >(DeleteBookmarkDocument, options)
}
export type DeleteBookmarkMutationHookResult = ReturnType<
  typeof useDeleteBookmarkMutation
>
export type DeleteBookmarkMutationResult =
  Apollo.MutationResult<DeleteBookmarkMutation>
export type DeleteBookmarkMutationOptions = Apollo.BaseMutationOptions<
  DeleteBookmarkMutation,
  DeleteBookmarkMutationVariables
>
export const AddBookmarkDocument = gql`
  mutation addBookmark($data: AddBookmarkInput!) {
    addBookmark(data: $data) {
      ...BookmarkDetail
    }
  }
  ${BookmarkDetailFragmentDoc}
`
export type AddBookmarkMutationFn = Apollo.MutationFunction<
  AddBookmarkMutation,
  AddBookmarkMutationVariables
>

/**
 * __useAddBookmarkMutation__
 *
 * To run a mutation, you first call `useAddBookmarkMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddBookmarkMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addBookmarkMutation, { data, loading, error }] = useAddBookmarkMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useAddBookmarkMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddBookmarkMutation,
    AddBookmarkMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<AddBookmarkMutation, AddBookmarkMutationVariables>(
    AddBookmarkDocument,
    options
  )
}
export type AddBookmarkMutationHookResult = ReturnType<
  typeof useAddBookmarkMutation
>
export type AddBookmarkMutationResult =
  Apollo.MutationResult<AddBookmarkMutation>
export type AddBookmarkMutationOptions = Apollo.BaseMutationOptions<
  AddBookmarkMutation,
  AddBookmarkMutationVariables
>
export const AddCommentDocument = gql`
  mutation addComment($refId: ID!, $type: CommentType!, $text: String!) {
    addComment(refId: $refId, type: $type, text: $text) {
      ...CommentInfo
    }
  }
  ${CommentInfoFragmentDoc}
`
export type AddCommentMutationFn = Apollo.MutationFunction<
  AddCommentMutation,
  AddCommentMutationVariables
>

/**
 * __useAddCommentMutation__
 *
 * To run a mutation, you first call `useAddCommentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddCommentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addCommentMutation, { data, loading, error }] = useAddCommentMutation({
 *   variables: {
 *      refId: // value for 'refId'
 *      type: // value for 'type'
 *      text: // value for 'text'
 *   },
 * });
 */
export function useAddCommentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddCommentMutation,
    AddCommentMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<AddCommentMutation, AddCommentMutationVariables>(
    AddCommentDocument,
    options
  )
}
export type AddCommentMutationHookResult = ReturnType<
  typeof useAddCommentMutation
>
export type AddCommentMutationResult = Apollo.MutationResult<AddCommentMutation>
export type AddCommentMutationOptions = Apollo.BaseMutationOptions<
  AddCommentMutation,
  AddCommentMutationVariables
>
export const EditCommentDocument = gql`
  mutation editComment($id: ID!, $text: String!) {
    editComment(id: $id, text: $text) {
      ...CommentInfo
    }
  }
  ${CommentInfoFragmentDoc}
`
export type EditCommentMutationFn = Apollo.MutationFunction<
  EditCommentMutation,
  EditCommentMutationVariables
>

/**
 * __useEditCommentMutation__
 *
 * To run a mutation, you first call `useEditCommentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditCommentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editCommentMutation, { data, loading, error }] = useEditCommentMutation({
 *   variables: {
 *      id: // value for 'id'
 *      text: // value for 'text'
 *   },
 * });
 */
export function useEditCommentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditCommentMutation,
    EditCommentMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<EditCommentMutation, EditCommentMutationVariables>(
    EditCommentDocument,
    options
  )
}
export type EditCommentMutationHookResult = ReturnType<
  typeof useEditCommentMutation
>
export type EditCommentMutationResult =
  Apollo.MutationResult<EditCommentMutation>
export type EditCommentMutationOptions = Apollo.BaseMutationOptions<
  EditCommentMutation,
  EditCommentMutationVariables
>
export const DeleteCommentDocument = gql`
  mutation deleteComment($id: ID!) {
    deleteComment(id: $id)
  }
`
export type DeleteCommentMutationFn = Apollo.MutationFunction<
  DeleteCommentMutation,
  DeleteCommentMutationVariables
>

/**
 * __useDeleteCommentMutation__
 *
 * To run a mutation, you first call `useDeleteCommentMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteCommentMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteCommentMutation, { data, loading, error }] = useDeleteCommentMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteCommentMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteCommentMutation,
    DeleteCommentMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    DeleteCommentMutation,
    DeleteCommentMutationVariables
  >(DeleteCommentDocument, options)
}
export type DeleteCommentMutationHookResult = ReturnType<
  typeof useDeleteCommentMutation
>
export type DeleteCommentMutationResult =
  Apollo.MutationResult<DeleteCommentMutation>
export type DeleteCommentMutationOptions = Apollo.BaseMutationOptions<
  DeleteCommentMutation,
  DeleteCommentMutationVariables
>
export const EditEmailSubscriptionDocument = gql`
  mutation editEmailSubscription($data: EmailSubscriptionInput) {
    editEmailSubscription(data: $data) {
      emailSubscriptions {
        subscribed
        type
      }
    }
  }
`
export type EditEmailSubscriptionMutationFn = Apollo.MutationFunction<
  EditEmailSubscriptionMutation,
  EditEmailSubscriptionMutationVariables
>

/**
 * __useEditEmailSubscriptionMutation__
 *
 * To run a mutation, you first call `useEditEmailSubscriptionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditEmailSubscriptionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editEmailSubscriptionMutation, { data, loading, error }] = useEditEmailSubscriptionMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditEmailSubscriptionMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditEmailSubscriptionMutation,
    EditEmailSubscriptionMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    EditEmailSubscriptionMutation,
    EditEmailSubscriptionMutationVariables
  >(EditEmailSubscriptionDocument, options)
}
export type EditEmailSubscriptionMutationHookResult = ReturnType<
  typeof useEditEmailSubscriptionMutation
>
export type EditEmailSubscriptionMutationResult =
  Apollo.MutationResult<EditEmailSubscriptionMutation>
export type EditEmailSubscriptionMutationOptions = Apollo.BaseMutationOptions<
  EditEmailSubscriptionMutation,
  EditEmailSubscriptionMutationVariables
>
export const EditPostDocument = gql`
  mutation editPost($id: ID!, $data: EditPostInput!) {
    editPost(id: $id, data: $data) {
      ...PostDetail
    }
  }
  ${PostDetailFragmentDoc}
`
export type EditPostMutationFn = Apollo.MutationFunction<
  EditPostMutation,
  EditPostMutationVariables
>

/**
 * __useEditPostMutation__
 *
 * To run a mutation, you first call `useEditPostMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditPostMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editPostMutation, { data, loading, error }] = useEditPostMutation({
 *   variables: {
 *      id: // value for 'id'
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditPostMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditPostMutation,
    EditPostMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<EditPostMutation, EditPostMutationVariables>(
    EditPostDocument,
    options
  )
}
export type EditPostMutationHookResult = ReturnType<typeof useEditPostMutation>
export type EditPostMutationResult = Apollo.MutationResult<EditPostMutation>
export type EditPostMutationOptions = Apollo.BaseMutationOptions<
  EditPostMutation,
  EditPostMutationVariables
>
export const DeletePostDocument = gql`
  mutation deletePost($id: ID!) {
    deletePost(id: $id)
  }
`
export type DeletePostMutationFn = Apollo.MutationFunction<
  DeletePostMutation,
  DeletePostMutationVariables
>

/**
 * __useDeletePostMutation__
 *
 * To run a mutation, you first call `useDeletePostMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeletePostMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deletePostMutation, { data, loading, error }] = useDeletePostMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeletePostMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeletePostMutation,
    DeletePostMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<DeletePostMutation, DeletePostMutationVariables>(
    DeletePostDocument,
    options
  )
}
export type DeletePostMutationHookResult = ReturnType<
  typeof useDeletePostMutation
>
export type DeletePostMutationResult = Apollo.MutationResult<DeletePostMutation>
export type DeletePostMutationOptions = Apollo.BaseMutationOptions<
  DeletePostMutation,
  DeletePostMutationVariables
>
export const AddPostDocument = gql`
  mutation addPost($data: AddPostInput!) {
    addPost(data: $data) {
      ...PostDetail
    }
  }
  ${PostDetailFragmentDoc}
`
export type AddPostMutationFn = Apollo.MutationFunction<
  AddPostMutation,
  AddPostMutationVariables
>

/**
 * __useAddPostMutation__
 *
 * To run a mutation, you first call `useAddPostMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddPostMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addPostMutation, { data, loading, error }] = useAddPostMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useAddPostMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddPostMutation,
    AddPostMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<AddPostMutation, AddPostMutationVariables>(
    AddPostDocument,
    options
  )
}
export type AddPostMutationHookResult = ReturnType<typeof useAddPostMutation>
export type AddPostMutationResult = Apollo.MutationResult<AddPostMutation>
export type AddPostMutationOptions = Apollo.BaseMutationOptions<
  AddPostMutation,
  AddPostMutationVariables
>
export const EditQuestionDocument = gql`
  mutation editQuestion($id: ID!, $data: EditQuestionInput!) {
    editQuestion(id: $id, data: $data) {
      ...QuestionDetail
    }
  }
  ${QuestionDetailFragmentDoc}
`
export type EditQuestionMutationFn = Apollo.MutationFunction<
  EditQuestionMutation,
  EditQuestionMutationVariables
>

/**
 * __useEditQuestionMutation__
 *
 * To run a mutation, you first call `useEditQuestionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditQuestionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editQuestionMutation, { data, loading, error }] = useEditQuestionMutation({
 *   variables: {
 *      id: // value for 'id'
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditQuestionMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditQuestionMutation,
    EditQuestionMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    EditQuestionMutation,
    EditQuestionMutationVariables
  >(EditQuestionDocument, options)
}
export type EditQuestionMutationHookResult = ReturnType<
  typeof useEditQuestionMutation
>
export type EditQuestionMutationResult =
  Apollo.MutationResult<EditQuestionMutation>
export type EditQuestionMutationOptions = Apollo.BaseMutationOptions<
  EditQuestionMutation,
  EditQuestionMutationVariables
>
export const DeleteQuestionDocument = gql`
  mutation deleteQuestion($id: ID!) {
    deleteQuestion(id: $id)
  }
`
export type DeleteQuestionMutationFn = Apollo.MutationFunction<
  DeleteQuestionMutation,
  DeleteQuestionMutationVariables
>

/**
 * __useDeleteQuestionMutation__
 *
 * To run a mutation, you first call `useDeleteQuestionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteQuestionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteQuestionMutation, { data, loading, error }] = useDeleteQuestionMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteQuestionMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteQuestionMutation,
    DeleteQuestionMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    DeleteQuestionMutation,
    DeleteQuestionMutationVariables
  >(DeleteQuestionDocument, options)
}
export type DeleteQuestionMutationHookResult = ReturnType<
  typeof useDeleteQuestionMutation
>
export type DeleteQuestionMutationResult =
  Apollo.MutationResult<DeleteQuestionMutation>
export type DeleteQuestionMutationOptions = Apollo.BaseMutationOptions<
  DeleteQuestionMutation,
  DeleteQuestionMutationVariables
>
export const AddQuestionDocument = gql`
  mutation addQuestion($data: AddQuestionInput!) {
    addQuestion(data: $data) {
      ...QuestionDetail
    }
  }
  ${QuestionDetailFragmentDoc}
`
export type AddQuestionMutationFn = Apollo.MutationFunction<
  AddQuestionMutation,
  AddQuestionMutationVariables
>

/**
 * __useAddQuestionMutation__
 *
 * To run a mutation, you first call `useAddQuestionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddQuestionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addQuestionMutation, { data, loading, error }] = useAddQuestionMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useAddQuestionMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddQuestionMutation,
    AddQuestionMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<AddQuestionMutation, AddQuestionMutationVariables>(
    AddQuestionDocument,
    options
  )
}
export type AddQuestionMutationHookResult = ReturnType<
  typeof useAddQuestionMutation
>
export type AddQuestionMutationResult =
  Apollo.MutationResult<AddQuestionMutation>
export type AddQuestionMutationOptions = Apollo.BaseMutationOptions<
  AddQuestionMutation,
  AddQuestionMutationVariables
>
export const ToggleReactionDocument = gql`
  mutation toggleReaction($refId: ID!, $type: ReactionType!) {
    toggleReaction(refId: $refId, type: $type) {
      ... on Stack {
        id
        reactionCount
        viewerHasReacted
      }
      ... on Bookmark {
        id
        url
        reactionCount
        viewerHasReacted
      }
      ... on Question {
        id
        reactionCount
        viewerHasReacted
      }
      ... on Post {
        id
        reactionCount
        viewerHasReacted
      }
    }
  }
`
export type ToggleReactionMutationFn = Apollo.MutationFunction<
  ToggleReactionMutation,
  ToggleReactionMutationVariables
>

/**
 * __useToggleReactionMutation__
 *
 * To run a mutation, you first call `useToggleReactionMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useToggleReactionMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [toggleReactionMutation, { data, loading, error }] = useToggleReactionMutation({
 *   variables: {
 *      refId: // value for 'refId'
 *      type: // value for 'type'
 *   },
 * });
 */
export function useToggleReactionMutation(
  baseOptions?: Apollo.MutationHookOptions<
    ToggleReactionMutation,
    ToggleReactionMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    ToggleReactionMutation,
    ToggleReactionMutationVariables
  >(ToggleReactionDocument, options)
}
export type ToggleReactionMutationHookResult = ReturnType<
  typeof useToggleReactionMutation
>
export type ToggleReactionMutationResult =
  Apollo.MutationResult<ToggleReactionMutation>
export type ToggleReactionMutationOptions = Apollo.BaseMutationOptions<
  ToggleReactionMutation,
  ToggleReactionMutationVariables
>
export const EditStackDocument = gql`
  mutation editStack($id: ID!, $data: EditStackInput!) {
    editStack(id: $id, data: $data) {
      ...StackDetail
    }
  }
  ${StackDetailFragmentDoc}
`
export type EditStackMutationFn = Apollo.MutationFunction<
  EditStackMutation,
  EditStackMutationVariables
>

/**
 * __useEditStackMutation__
 *
 * To run a mutation, you first call `useEditStackMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditStackMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editStackMutation, { data, loading, error }] = useEditStackMutation({
 *   variables: {
 *      id: // value for 'id'
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditStackMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditStackMutation,
    EditStackMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<EditStackMutation, EditStackMutationVariables>(
    EditStackDocument,
    options
  )
}
export type EditStackMutationHookResult = ReturnType<
  typeof useEditStackMutation
>
export type EditStackMutationResult = Apollo.MutationResult<EditStackMutation>
export type EditStackMutationOptions = Apollo.BaseMutationOptions<
  EditStackMutation,
  EditStackMutationVariables
>
export const DeleteStackDocument = gql`
  mutation deleteStack($id: ID!) {
    deleteStack(id: $id)
  }
`
export type DeleteStackMutationFn = Apollo.MutationFunction<
  DeleteStackMutation,
  DeleteStackMutationVariables
>

/**
 * __useDeleteStackMutation__
 *
 * To run a mutation, you first call `useDeleteStackMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteStackMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteStackMutation, { data, loading, error }] = useDeleteStackMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useDeleteStackMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteStackMutation,
    DeleteStackMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<DeleteStackMutation, DeleteStackMutationVariables>(
    DeleteStackDocument,
    options
  )
}
export type DeleteStackMutationHookResult = ReturnType<
  typeof useDeleteStackMutation
>
export type DeleteStackMutationResult =
  Apollo.MutationResult<DeleteStackMutation>
export type DeleteStackMutationOptions = Apollo.BaseMutationOptions<
  DeleteStackMutation,
  DeleteStackMutationVariables
>
export const AddStackDocument = gql`
  mutation addStack($data: AddStackInput!) {
    addStack(data: $data) {
      ...StackDetail
    }
  }
  ${StackDetailFragmentDoc}
`
export type AddStackMutationFn = Apollo.MutationFunction<
  AddStackMutation,
  AddStackMutationVariables
>

/**
 * __useAddStackMutation__
 *
 * To run a mutation, you first call `useAddStackMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useAddStackMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [addStackMutation, { data, loading, error }] = useAddStackMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useAddStackMutation(
  baseOptions?: Apollo.MutationHookOptions<
    AddStackMutation,
    AddStackMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<AddStackMutation, AddStackMutationVariables>(
    AddStackDocument,
    options
  )
}
export type AddStackMutationHookResult = ReturnType<typeof useAddStackMutation>
export type AddStackMutationResult = Apollo.MutationResult<AddStackMutation>
export type AddStackMutationOptions = Apollo.BaseMutationOptions<
  AddStackMutation,
  AddStackMutationVariables
>
export const ToggleStackUserDocument = gql`
  mutation toggleStackUser($id: ID!) {
    toggleStackUser(id: $id) {
      ...StackCore
      usedBy {
        ...UserInfo
      }
    }
  }
  ${StackCoreFragmentDoc}
  ${UserInfoFragmentDoc}
`
export type ToggleStackUserMutationFn = Apollo.MutationFunction<
  ToggleStackUserMutation,
  ToggleStackUserMutationVariables
>

/**
 * __useToggleStackUserMutation__
 *
 * To run a mutation, you first call `useToggleStackUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useToggleStackUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [toggleStackUserMutation, { data, loading, error }] = useToggleStackUserMutation({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useToggleStackUserMutation(
  baseOptions?: Apollo.MutationHookOptions<
    ToggleStackUserMutation,
    ToggleStackUserMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<
    ToggleStackUserMutation,
    ToggleStackUserMutationVariables
  >(ToggleStackUserDocument, options)
}
export type ToggleStackUserMutationHookResult = ReturnType<
  typeof useToggleStackUserMutation
>
export type ToggleStackUserMutationResult =
  Apollo.MutationResult<ToggleStackUserMutation>
export type ToggleStackUserMutationOptions = Apollo.BaseMutationOptions<
  ToggleStackUserMutation,
  ToggleStackUserMutationVariables
>
export const DeleteUserDocument = gql`
  mutation deleteUser {
    deleteUser
  }
`
export type DeleteUserMutationFn = Apollo.MutationFunction<
  DeleteUserMutation,
  DeleteUserMutationVariables
>

/**
 * __useDeleteUserMutation__
 *
 * To run a mutation, you first call `useDeleteUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useDeleteUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [deleteUserMutation, { data, loading, error }] = useDeleteUserMutation({
 *   variables: {
 *   },
 * });
 */
export function useDeleteUserMutation(
  baseOptions?: Apollo.MutationHookOptions<
    DeleteUserMutation,
    DeleteUserMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<DeleteUserMutation, DeleteUserMutationVariables>(
    DeleteUserDocument,
    options
  )
}
export type DeleteUserMutationHookResult = ReturnType<
  typeof useDeleteUserMutation
>
export type DeleteUserMutationResult = Apollo.MutationResult<DeleteUserMutation>
export type DeleteUserMutationOptions = Apollo.BaseMutationOptions<
  DeleteUserMutation,
  DeleteUserMutationVariables
>
export const EditUserDocument = gql`
  mutation editUser($data: EditUserInput) {
    editUser(data: $data) {
      ...UserInfo
    }
  }
  ${UserInfoFragmentDoc}
`
export type EditUserMutationFn = Apollo.MutationFunction<
  EditUserMutation,
  EditUserMutationVariables
>

/**
 * __useEditUserMutation__
 *
 * To run a mutation, you first call `useEditUserMutation` within a React component and pass it any options that fit your needs.
 * When your component renders, `useEditUserMutation` returns a tuple that includes:
 * - A mutate function that you can call at any time to execute the mutation
 * - An object with fields that represent the current status of the mutation's execution
 *
 * @param baseOptions options that will be passed into the mutation, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options-2;
 *
 * @example
 * const [editUserMutation, { data, loading, error }] = useEditUserMutation({
 *   variables: {
 *      data: // value for 'data'
 *   },
 * });
 */
export function useEditUserMutation(
  baseOptions?: Apollo.MutationHookOptions<
    EditUserMutation,
    EditUserMutationVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useMutation<EditUserMutation, EditUserMutationVariables>(
    EditUserDocument,
    options
  )
}
export type EditUserMutationHookResult = ReturnType<typeof useEditUserMutation>
export type EditUserMutationResult = Apollo.MutationResult<EditUserMutation>
export type EditUserMutationOptions = Apollo.BaseMutationOptions<
  EditUserMutation,
  EditUserMutationVariables
>
export const GetBookmarksDocument = gql`
  query getBookmarks($first: Int, $after: String, $filter: BookmarkFilter) {
    bookmarks(first: $first, after: $after, filter: $filter) {
      ...BookmarksConnection
    }
  }
  ${BookmarksConnectionFragmentDoc}
`

/**
 * __useGetBookmarksQuery__
 *
 * To run a query within a React component, call `useGetBookmarksQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetBookmarksQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetBookmarksQuery({
 *   variables: {
 *      first: // value for 'first'
 *      after: // value for 'after'
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useGetBookmarksQuery(
  baseOptions?: Apollo.QueryHookOptions<
    GetBookmarksQuery,
    GetBookmarksQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetBookmarksQuery, GetBookmarksQueryVariables>(
    GetBookmarksDocument,
    options
  )
}
export function useGetBookmarksLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetBookmarksQuery,
    GetBookmarksQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetBookmarksQuery, GetBookmarksQueryVariables>(
    GetBookmarksDocument,
    options
  )
}
export type GetBookmarksQueryHookResult = ReturnType<
  typeof useGetBookmarksQuery
>
export type GetBookmarksLazyQueryHookResult = ReturnType<
  typeof useGetBookmarksLazyQuery
>
export type GetBookmarksQueryResult = Apollo.QueryResult<
  GetBookmarksQuery,
  GetBookmarksQueryVariables
>
export const GetBookmarkDocument = gql`
  query getBookmark($id: ID!) {
    bookmark(id: $id) {
      ...BookmarkDetail
    }
  }
  ${BookmarkDetailFragmentDoc}
`

/**
 * __useGetBookmarkQuery__
 *
 * To run a query within a React component, call `useGetBookmarkQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetBookmarkQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetBookmarkQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetBookmarkQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetBookmarkQuery,
    GetBookmarkQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetBookmarkQuery, GetBookmarkQueryVariables>(
    GetBookmarkDocument,
    options
  )
}
export function useGetBookmarkLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetBookmarkQuery,
    GetBookmarkQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetBookmarkQuery, GetBookmarkQueryVariables>(
    GetBookmarkDocument,
    options
  )
}
export type GetBookmarkQueryHookResult = ReturnType<typeof useGetBookmarkQuery>
export type GetBookmarkLazyQueryHookResult = ReturnType<
  typeof useGetBookmarkLazyQuery
>
export type GetBookmarkQueryResult = Apollo.QueryResult<
  GetBookmarkQuery,
  GetBookmarkQueryVariables
>
export const GetCommentsDocument = gql`
  query getComments($refId: ID!, $type: CommentType!) {
    comments(refId: $refId, type: $type) {
      ...CommentInfo
    }
  }
  ${CommentInfoFragmentDoc}
`

/**
 * __useGetCommentsQuery__
 *
 * To run a query within a React component, call `useGetCommentsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetCommentsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetCommentsQuery({
 *   variables: {
 *      refId: // value for 'refId'
 *      type: // value for 'type'
 *   },
 * });
 */
export function useGetCommentsQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetCommentsQuery,
    GetCommentsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetCommentsQuery, GetCommentsQueryVariables>(
    GetCommentsDocument,
    options
  )
}
export function useGetCommentsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetCommentsQuery,
    GetCommentsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetCommentsQuery, GetCommentsQueryVariables>(
    GetCommentsDocument,
    options
  )
}
export type GetCommentsQueryHookResult = ReturnType<typeof useGetCommentsQuery>
export type GetCommentsLazyQueryHookResult = ReturnType<
  typeof useGetCommentsLazyQuery
>
export type GetCommentsQueryResult = Apollo.QueryResult<
  GetCommentsQuery,
  GetCommentsQueryVariables
>
export const GetHackerNewsPostsDocument = gql`
  query getHackerNewsPosts {
    hackerNewsPosts {
      ...HackerNewsListItemInfo
    }
  }
  ${HackerNewsListItemInfoFragmentDoc}
`

/**
 * __useGetHackerNewsPostsQuery__
 *
 * To run a query within a React component, call `useGetHackerNewsPostsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetHackerNewsPostsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetHackerNewsPostsQuery({
 *   variables: {
 *   },
 * });
 */
export function useGetHackerNewsPostsQuery(
  baseOptions?: Apollo.QueryHookOptions<
    GetHackerNewsPostsQuery,
    GetHackerNewsPostsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<
    GetHackerNewsPostsQuery,
    GetHackerNewsPostsQueryVariables
  >(GetHackerNewsPostsDocument, options)
}
export function useGetHackerNewsPostsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetHackerNewsPostsQuery,
    GetHackerNewsPostsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<
    GetHackerNewsPostsQuery,
    GetHackerNewsPostsQueryVariables
  >(GetHackerNewsPostsDocument, options)
}
export type GetHackerNewsPostsQueryHookResult = ReturnType<
  typeof useGetHackerNewsPostsQuery
>
export type GetHackerNewsPostsLazyQueryHookResult = ReturnType<
  typeof useGetHackerNewsPostsLazyQuery
>
export type GetHackerNewsPostsQueryResult = Apollo.QueryResult<
  GetHackerNewsPostsQuery,
  GetHackerNewsPostsQueryVariables
>
export const GetHackerNewsPostDocument = gql`
  query getHackerNewsPost($id: ID!) {
    hackerNewsPost(id: $id) {
      ...HackerNewsPostInfo
    }
  }
  ${HackerNewsPostInfoFragmentDoc}
`

/**
 * __useGetHackerNewsPostQuery__
 *
 * To run a query within a React component, call `useGetHackerNewsPostQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetHackerNewsPostQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetHackerNewsPostQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetHackerNewsPostQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetHackerNewsPostQuery,
    GetHackerNewsPostQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<
    GetHackerNewsPostQuery,
    GetHackerNewsPostQueryVariables
  >(GetHackerNewsPostDocument, options)
}
export function useGetHackerNewsPostLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetHackerNewsPostQuery,
    GetHackerNewsPostQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<
    GetHackerNewsPostQuery,
    GetHackerNewsPostQueryVariables
  >(GetHackerNewsPostDocument, options)
}
export type GetHackerNewsPostQueryHookResult = ReturnType<
  typeof useGetHackerNewsPostQuery
>
export type GetHackerNewsPostLazyQueryHookResult = ReturnType<
  typeof useGetHackerNewsPostLazyQuery
>
export type GetHackerNewsPostQueryResult = Apollo.QueryResult<
  GetHackerNewsPostQuery,
  GetHackerNewsPostQueryVariables
>
export const GetPostsDocument = gql`
  query getPosts($filter: WritingFilter) {
    posts(filter: $filter) {
      ...PostListItem
    }
  }
  ${PostListItemFragmentDoc}
`

/**
 * __useGetPostsQuery__
 *
 * To run a query within a React component, call `useGetPostsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetPostsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetPostsQuery({
 *   variables: {
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useGetPostsQuery(
  baseOptions?: Apollo.QueryHookOptions<GetPostsQuery, GetPostsQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetPostsQuery, GetPostsQueryVariables>(
    GetPostsDocument,
    options
  )
}
export function useGetPostsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetPostsQuery,
    GetPostsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetPostsQuery, GetPostsQueryVariables>(
    GetPostsDocument,
    options
  )
}
export type GetPostsQueryHookResult = ReturnType<typeof useGetPostsQuery>
export type GetPostsLazyQueryHookResult = ReturnType<
  typeof useGetPostsLazyQuery
>
export type GetPostsQueryResult = Apollo.QueryResult<
  GetPostsQuery,
  GetPostsQueryVariables
>
export const GetPostDocument = gql`
  query getPost($slug: String!) {
    post(slug: $slug) {
      ...PostDetail
    }
  }
  ${PostDetailFragmentDoc}
`

/**
 * __useGetPostQuery__
 *
 * To run a query within a React component, call `useGetPostQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetPostQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetPostQuery({
 *   variables: {
 *      slug: // value for 'slug'
 *   },
 * });
 */
export function useGetPostQuery(
  baseOptions: Apollo.QueryHookOptions<GetPostQuery, GetPostQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetPostQuery, GetPostQueryVariables>(
    GetPostDocument,
    options
  )
}
export function useGetPostLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GetPostQuery, GetPostQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetPostQuery, GetPostQueryVariables>(
    GetPostDocument,
    options
  )
}
export type GetPostQueryHookResult = ReturnType<typeof useGetPostQuery>
export type GetPostLazyQueryHookResult = ReturnType<typeof useGetPostLazyQuery>
export type GetPostQueryResult = Apollo.QueryResult<
  GetPostQuery,
  GetPostQueryVariables
>
export const GetQuestionsDocument = gql`
  query getQuestions($first: Int, $after: String, $filter: QuestionFilter) {
    questions(first: $first, after: $after, filter: $filter) {
      ...QuestionsConnection
    }
  }
  ${QuestionsConnectionFragmentDoc}
`

/**
 * __useGetQuestionsQuery__
 *
 * To run a query within a React component, call `useGetQuestionsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetQuestionsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetQuestionsQuery({
 *   variables: {
 *      first: // value for 'first'
 *      after: // value for 'after'
 *      filter: // value for 'filter'
 *   },
 * });
 */
export function useGetQuestionsQuery(
  baseOptions?: Apollo.QueryHookOptions<
    GetQuestionsQuery,
    GetQuestionsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetQuestionsQuery, GetQuestionsQueryVariables>(
    GetQuestionsDocument,
    options
  )
}
export function useGetQuestionsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetQuestionsQuery,
    GetQuestionsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetQuestionsQuery, GetQuestionsQueryVariables>(
    GetQuestionsDocument,
    options
  )
}
export type GetQuestionsQueryHookResult = ReturnType<
  typeof useGetQuestionsQuery
>
export type GetQuestionsLazyQueryHookResult = ReturnType<
  typeof useGetQuestionsLazyQuery
>
export type GetQuestionsQueryResult = Apollo.QueryResult<
  GetQuestionsQuery,
  GetQuestionsQueryVariables
>
export const GetQuestionDocument = gql`
  query getQuestion($id: ID!) {
    question(id: $id) {
      ...QuestionDetail
    }
  }
  ${QuestionDetailFragmentDoc}
`

/**
 * __useGetQuestionQuery__
 *
 * To run a query within a React component, call `useGetQuestionQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetQuestionQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetQuestionQuery({
 *   variables: {
 *      id: // value for 'id'
 *   },
 * });
 */
export function useGetQuestionQuery(
  baseOptions: Apollo.QueryHookOptions<
    GetQuestionQuery,
    GetQuestionQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetQuestionQuery, GetQuestionQueryVariables>(
    GetQuestionDocument,
    options
  )
}
export function useGetQuestionLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetQuestionQuery,
    GetQuestionQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetQuestionQuery, GetQuestionQueryVariables>(
    GetQuestionDocument,
    options
  )
}
export type GetQuestionQueryHookResult = ReturnType<typeof useGetQuestionQuery>
export type GetQuestionLazyQueryHookResult = ReturnType<
  typeof useGetQuestionLazyQuery
>
export type GetQuestionQueryResult = Apollo.QueryResult<
  GetQuestionQuery,
  GetQuestionQueryVariables
>
export const GetStacksDocument = gql`
  query getStacks($first: Int, $after: String) {
    stacks(first: $first, after: $after) {
      ...StacksConnection
    }
  }
  ${StacksConnectionFragmentDoc}
`

/**
 * __useGetStacksQuery__
 *
 * To run a query within a React component, call `useGetStacksQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetStacksQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetStacksQuery({
 *   variables: {
 *      first: // value for 'first'
 *      after: // value for 'after'
 *   },
 * });
 */
export function useGetStacksQuery(
  baseOptions?: Apollo.QueryHookOptions<GetStacksQuery, GetStacksQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetStacksQuery, GetStacksQueryVariables>(
    GetStacksDocument,
    options
  )
}
export function useGetStacksLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetStacksQuery,
    GetStacksQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetStacksQuery, GetStacksQueryVariables>(
    GetStacksDocument,
    options
  )
}
export type GetStacksQueryHookResult = ReturnType<typeof useGetStacksQuery>
export type GetStacksLazyQueryHookResult = ReturnType<
  typeof useGetStacksLazyQuery
>
export type GetStacksQueryResult = Apollo.QueryResult<
  GetStacksQuery,
  GetStacksQueryVariables
>
export const GetStackDocument = gql`
  query getStack($slug: String!) {
    stack(slug: $slug) {
      ...StackDetail
    }
  }
  ${StackDetailFragmentDoc}
`

/**
 * __useGetStackQuery__
 *
 * To run a query within a React component, call `useGetStackQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetStackQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetStackQuery({
 *   variables: {
 *      slug: // value for 'slug'
 *   },
 * });
 */
export function useGetStackQuery(
  baseOptions: Apollo.QueryHookOptions<GetStackQuery, GetStackQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetStackQuery, GetStackQueryVariables>(
    GetStackDocument,
    options
  )
}
export function useGetStackLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetStackQuery,
    GetStackQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetStackQuery, GetStackQueryVariables>(
    GetStackDocument,
    options
  )
}
export type GetStackQueryHookResult = ReturnType<typeof useGetStackQuery>
export type GetStackLazyQueryHookResult = ReturnType<
  typeof useGetStackLazyQuery
>
export type GetStackQueryResult = Apollo.QueryResult<
  GetStackQuery,
  GetStackQueryVariables
>
export const GetTagsDocument = gql`
  query getTags {
    tags {
      name
    }
  }
`

/**
 * __useGetTagsQuery__
 *
 * To run a query within a React component, call `useGetTagsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetTagsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetTagsQuery({
 *   variables: {
 *   },
 * });
 */
export function useGetTagsQuery(
  baseOptions?: Apollo.QueryHookOptions<GetTagsQuery, GetTagsQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetTagsQuery, GetTagsQueryVariables>(
    GetTagsDocument,
    options
  )
}
export function useGetTagsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GetTagsQuery, GetTagsQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetTagsQuery, GetTagsQueryVariables>(
    GetTagsDocument,
    options
  )
}
export type GetTagsQueryHookResult = ReturnType<typeof useGetTagsQuery>
export type GetTagsLazyQueryHookResult = ReturnType<typeof useGetTagsLazyQuery>
export type GetTagsQueryResult = Apollo.QueryResult<
  GetTagsQuery,
  GetTagsQueryVariables
>
export const GetUserDocument = gql`
  query getUser($username: String!) {
    user(username: $username) {
      ...UserInfo
    }
  }
  ${UserInfoFragmentDoc}
`

/**
 * __useGetUserQuery__
 *
 * To run a query within a React component, call `useGetUserQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetUserQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetUserQuery({
 *   variables: {
 *      username: // value for 'username'
 *   },
 * });
 */
export function useGetUserQuery(
  baseOptions: Apollo.QueryHookOptions<GetUserQuery, GetUserQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<GetUserQuery, GetUserQueryVariables>(
    GetUserDocument,
    options
  )
}
export function useGetUserLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<GetUserQuery, GetUserQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<GetUserQuery, GetUserQueryVariables>(
    GetUserDocument,
    options
  )
}
export type GetUserQueryHookResult = ReturnType<typeof useGetUserQuery>
export type GetUserLazyQueryHookResult = ReturnType<typeof useGetUserLazyQuery>
export type GetUserQueryResult = Apollo.QueryResult<
  GetUserQuery,
  GetUserQueryVariables
>
export const ViewerDocument = gql`
  query viewer {
    viewer {
      ...UserInfo
    }
  }
  ${UserInfoFragmentDoc}
`

/**
 * __useViewerQuery__
 *
 * To run a query within a React component, call `useViewerQuery` and pass it any options that fit your needs.
 * When your component renders, `useViewerQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useViewerQuery({
 *   variables: {
 *   },
 * });
 */
export function useViewerQuery(
  baseOptions?: Apollo.QueryHookOptions<ViewerQuery, ViewerQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<ViewerQuery, ViewerQueryVariables>(
    ViewerDocument,
    options
  )
}
export function useViewerLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<ViewerQuery, ViewerQueryVariables>
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<ViewerQuery, ViewerQueryVariables>(
    ViewerDocument,
    options
  )
}
export type ViewerQueryHookResult = ReturnType<typeof useViewerQuery>
export type ViewerLazyQueryHookResult = ReturnType<typeof useViewerLazyQuery>
export type ViewerQueryResult = Apollo.QueryResult<
  ViewerQuery,
  ViewerQueryVariables
>
export const GetViewerWithSettingsDocument = gql`
  query getViewerWithSettings {
    viewer {
      ...UserInfo
      ...UserSettings
    }
  }
  ${UserInfoFragmentDoc}
  ${UserSettingsFragmentDoc}
`

/**
 * __useGetViewerWithSettingsQuery__
 *
 * To run a query within a React component, call `useGetViewerWithSettingsQuery` and pass it any options that fit your needs.
 * When your component renders, `useGetViewerWithSettingsQuery` returns an object from Apollo Client that contains loading, error, and data properties
 * you can use to render your UI.
 *
 * @param baseOptions options that will be passed into the query, supported options are listed on: https://www.apollographql.com/docs/react/api/react-hooks/#options;
 *
 * @example
 * const { data, loading, error } = useGetViewerWithSettingsQuery({
 *   variables: {
 *   },
 * });
 */
export function useGetViewerWithSettingsQuery(
  baseOptions?: Apollo.QueryHookOptions<
    GetViewerWithSettingsQuery,
    GetViewerWithSettingsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useQuery<
    GetViewerWithSettingsQuery,
    GetViewerWithSettingsQueryVariables
  >(GetViewerWithSettingsDocument, options)
}
export function useGetViewerWithSettingsLazyQuery(
  baseOptions?: Apollo.LazyQueryHookOptions<
    GetViewerWithSettingsQuery,
    GetViewerWithSettingsQueryVariables
  >
) {
  const options = { ...defaultOptions, ...baseOptions }
  return Apollo.useLazyQuery<
    GetViewerWithSettingsQuery,
    GetViewerWithSettingsQueryVariables
  >(GetViewerWithSettingsDocument, options)
}
export type GetViewerWithSettingsQueryHookResult = ReturnType<
  typeof useGetViewerWithSettingsQuery
>
export type GetViewerWithSettingsLazyQueryHookResult = ReturnType<
  typeof useGetViewerWithSettingsLazyQuery
>
export type GetViewerWithSettingsQueryResult = Apollo.QueryResult<
  GetViewerWithSettingsQuery,
  GetViewerWithSettingsQueryVariables
>
