export default {
  id: 'patching',
  title: 'Keep your devices up to date',
  description: `Many of the most damaging hacks in recent history were only possible because someone failed to update software. While update notifications delivered by your smartphone, computer, and other internet-connected devices can be disruptive, *applying* those updates in a timely manner is the single-most effective action you can take to protect yourself from these types of attacks.

  \n\nYou should apply software updates to every device you own as soon as they are made available, and develop a habit of checking for updates on devices that do *not* notify you of available patches to ensure their security.`,
  resources: [
    {
      name: "Stop putting off your device updates—here's why",
      url: 'https://www.popsci.com/update-every-gadget',
    },
    {
      name: 'Rarely Patched Software Bugs in Home Routers Cripple Security',
      url: 'https://www.wsj.com/articles/rarely-patched-software-bugs-in-home-routers-cripple-security-1453136285',
    },
    {
      name: 'Why Installing Software Updates Makes Us WannaCry',
      url: 'https://www.scientificamerican.com/article/why-installing-software-updates-makes-us-wannacry/',
    },
    {
      name: 'Everything You Ever Wanted to Know About Microsoft Windows Updates',
      url: 'https://www.automox.com/blog/everything-you-want-microsoft-windows-updates',
    },
    {
      name: 'Patching Is Failing as a Security Paradigm',
      url: 'https://motherboard.vice.com/en_us/article/439wbw/patching-is-failing-as-a-security-paradigm',
    },
  ],
}
