export default {
  id: 'appPermissions',
  title: 'Review location, camera, and other sensitive device permissions',
  description: `You should review all applications that have access to your photos, camera, location, and microphone. Ensure that you trust apps with sensitive permissions.
  `,
  resources: [
    {
      name: 'iOS camera permissions allow rogue apps to surreptitiously photograph & video users',
      url: 'https://9to5mac.com/2017/10/26/ios-camera-permissions-abuse/',
    },
    {
      name: 'How to stop your iPhone from tracking locations you frequently visit',
      url: 'https://www.imore.com/stop-iphone-tracking-frequent-locations',
    },
    {
      name: 'How to manage app permissions on iOS',
      url: 'https://www.howtogeek.com/211623/how-to-manage-app-permissions-on-your-iphone-or-ipad/',
    },
    {
      name: 'How to manage app permissions on Android',
      url: 'https://www.howtogeek.com/230683/how-to-manage-app-permissions-on-android-6.0/',
    },
    {
      name: 'How to manage app permissions on macOS',
      url: 'https://www.idownloadblog.com/2018/08/16/howto-mac-camera-microphone-permission/',
    },
    {
      name: 'How to manage app permissions on Windows',
      url: 'https://www.intowindows.com/how-to-change-app-permissions-in-windows-10/',
    },
    {
      name: 'Apps and services with access to your Google account',
      url: 'https://myaccount.google.com/permissions',
    },
    {
      name: 'Apps and services with access to your Facebook account',
      url: 'https://www.facebook.com/settings?tab=applications',
    },
    {
      name: 'Apps and services with access to your Twitter account',
      url: 'https://twitter.com/settings/applications',
    },
    {
      name: 'Opt out of all the data sharing you wouldn’t opt in to',
      url: 'http://simpleoptout.com/',
    },
  ],
}
