export default [
  {
    description:
      'As you’re scrolling through your feed on Tumblr, tapping the ‘Home’ icon in the tab bar will, as expected, return you to the top of the view. What Tumblr does here though, that I’ve never seen on any other app, is toggle the ‘Home’ icon with a new ‘Return to position’ icon. Tapping once more will scroll you back down to your previous place in the feed.\r\n\r\nThis is amazing. I honestly wish other apps would do this already – Twitter, Facebook and Instagram all come to mind as places where I might accidentally tap to the top of the feed only to have lost my previous position.',
    title: 'Scroll position',
    media: [
      'https://videodelivery.net/44955c6351f751e7d0980af9cbfaaa67/downloads/default.mp4',
    ],
  },
  {
    description:
      'The springy animations that trigger when you tap the ‘Compose’ icon in the tab bar is great – it looks slick and provides some nice interactivity.\r\n\r\nWhat I thought was cool is that this view also responds to the accelerometer in the iPhone providing a subtle panning movement as you tilt the device. There’s not really much to say for this in the way of usability, but I appreciate the fact that there are people out there paying attention to these small things (even if most people might not notice).',
    title: 'Compose',
    media: [
      'https://videodelivery.net/3df0cb63e4f850c720ba3d66eafab80c/downloads/default.mp4',
    ],
  },
  {
    description:
      'For some reason Tumblr lets you drag a blog’s profile picture around – similar to a Facebook chat head. I couldn’t quite figure out why this is supported, but hey – it’s fun, right?\r\n\r\nI also really appreciated some of the subtle scaling transitions that happen to the body layer whenever you expand/hide the profile photo. The obvious solution here might have been to just enlarge/shrink the profile picture on top of a static view. In this case, however, the view responds to the interaction and fades out+back or in+forward depending on the input.',
    title: 'Profile pictures',
    media: [
      'https://videodelivery.net/964ceb7cefa9b28bbbcd0818686c98bc/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you land on an empty view (in this case I went to view my non-existent favorites), Tumblr gently guides you in the right direction to begin exploring content. This is incredibly smart and something I haven’t actually seen too many other apps do. Guiding users to a desired behavior is good; guiding them when they’re potentially lost or confused – well, that’s just great.',
    title: 'Empty views',
    media: [
      'https://videodelivery.net/9df91f7a53bab7bf7da67b1bb2ad33f9/downloads/default.mp4',
    ],
  },
  {
    description:
      'This video captures the (almost) over-the-top animation and motion that accompanies a new following interaction. After a few times triggering this interaction I realized just how helpful this bit of feedback could be to new users, helping them to understand not only the navigation patterns of the app but also how to get value out of the app. Follow people, fill up your feed, like, repost…etc.',
    title: 'Quick follow',
    media: [
      'https://videodelivery.net/e6aaec4de96201d6a04c27b12f4ef288/downloads/default.mp4',
    ],
  },
  {
    description:
      'Any sort of ‘Like’ or ‘Favorite’ interaction on iOS is super low-hanging fruit for any designer/developer out there. Adding small touches of interactivity and feedback make the whole process so much more gratifying and fulfilling to users.\r\n\r\nAnd if you’re smart, you’ll do this right and include a reverse animation for un-liking/favoriting!',
    title: 'Liking a post',
    media: [
      'https://videodelivery.net/5783ca1cc71235ac3f17fc421fb7c0db/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you’re going to reblog a piece of content, you can toggle the visibility of the attribution within the composer. As a non-seasoned user of Tumblr, I honestly don’t understand reblogging. When I saw the initial reblog window, I tapped the ( x ) to get rid of the attribution out of curiosity. That curiosity may have turned into frustration if the attribution had been completely removed, but instead it turned into a feeling of safety and flexibility once I knew that I could restore it with a tap.',
    title: 'Reblogging',
    media: [
      'https://videodelivery.net/f14bdeea674cbc81e2489d1052e3d8e7/downloads/default.mp4',
    ],
  },
  {
    description:
      'Just another quick video to show the scale and grandeur that Tumblr gives to the following interaction. Moving an element across the entire view is dramatic and, I suspect, highly effective.',
    title: 'Tooltip',
    media: [
      'https://videodelivery.net/e5fa04302ab2c217377a13ab0d2e25e3/downloads/default.mp4',
    ],
  },
  {
    description:
      'I spent a while playing around with the composer, trying to share different content types and seeing what was possible. My favorite interaction that came out of this whole process was the simplicity of reordering images in a gallery. Subtle movements give hints as to where your photo is going to go so that you can build a gallery exactly how you want it.',
    title: 'Composer',
    media: [
      'https://videodelivery.net/94774282f772cea136e885f442094ef3/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you somehow manage to get to this empty dashboard view (trust me, it’s quite hard – Tumblr really never wants this view to be empty so they usually populate it with suggested content), Tumblr adds a nice animated splash. This one is cool to me because it’s so clear that someone put in the time and energy to make this view feel friendly and open, even with the understanding that it might never be seen.',
    title: 'Empty feed',
    media: [
      'https://videodelivery.net/30f1a03f60e15e0cc9f446000d6fdebe/downloads/default.mp4',
    ],
  },
  {
    description:
      'Toggling the show/hide password field also opens/closes the little eye icon. I appreciate the subtlety of this one and that it breaks away from more tradition password visibility toggles!',
    title: 'Visible password',
    media: [
      'https://videodelivery.net/7fecd693b9b368870cbd9fcce42d48f2/downloads/default.mp4',
    ],
  },
  {
    description:
      'In my longest-ever Design Details recording, I sign up for a new account with Tumblr to show off the onboarding flow. It’s insane how fast they get users to content so that they can start favoriting, sharing, etc.\r\n\r\nAbout halfway through the video we see a nice tutorial view slide into view. That whole interaction is gorgeous, too – it’s unlike anything else I’ve seen in other app walkthroughs. I love the way it gently pushes the main view out of the way and back into the distance. The motion is buttery and builds up a certain feeling of trust and friendliness.',
    title: 'Tap to focus',
    media: [
      'https://videodelivery.net/2a670af55a22383e4ee75655bf51b364/downloads/default.mp4',
    ],
  },
  {
    description:
      'Some profiles on Tumblr interact with the bottom tab bar in a wonderful way with color and contrast. I found three profiles in this video that all change the color of the tab bar in one way or another, making users feel at-home while looking through vastly different types of content and profiles.',
    title: 'Adaptive profiles',
    media: [
      'https://videodelivery.net/25e954bf42317dc39b9b95f88397076b/downloads/default.mp4',
    ],
  },
  {
    description:
      'Tapping the little ‘x’ on a suggested card in the feed will slide it gently out of view. Interestingly, the cards will slide off to both the left and right (at random, I believe). This is another one of those details that might not feel like it matters. Will anyone really notice? Maybe, maybe not – but in my opinion this attention to detail breathes life and passion into the app for those who care to notice.',
    title: 'Hiding cards',
    media: [
      'https://videodelivery.net/c901c4107dd400216e0b1d3bb41a5e9f/downloads/default.mp4',
    ],
  },
  {
    description:
      'I stumbled across another walkthrough tip and managed to get a pretty clean video of the interactivity here.\r\n\r\nTake a look at the micro-copy: how often do you see “Rad” being used as confirmation text? I’d venture a guess: never.\r\n\r\nTumblr adds these small splashes of personality and humanity into different parts of the app which made me feel oddly connected to the product on an emotional level. Mission accomplished.',
    title: 'Walkthrough guides',
    media: [
      'https://videodelivery.net/c901c4107dd400216e0b1d3bb41a5e9f/downloads/default.mp4',
    ],
  },
  {
    description:
      'This detail came through on Twitter – you can scrub along an animated gif to quickly skim or skip to a different section! More apps should have this – I’m looking at you, Reddit!',
    title: 'GIF scrubbing',
    media: [
      'https://videodelivery.net/67163f4bcf7659ae8cc6ded51e5f012b/downloads/default.mp4',
    ],
  },
  {
    description:
      'Another recommendation from Twitter, this is one I can’t believe I overlooked! If you tap + hold to reblog a post, we get this nice bubbly progress paired with an incrementing notes count. This is really great because it can actually save you a lot of time compared to the normal reblogging flow (which lets you edit the post).',
    title: 'Reblog',
    media: [
      'https://videodelivery.net/54e4651f851824c786596b47f822722a/downloads/default.mp4',
    ],
  },
]
