import details from './details'

export default {
  title: 'Square Order',
  slug: 'square-order-ios',
  createdAt: '2016-03-01T03:18:20.560Z',
  description:
    'I’ve admired the design work at [Square](https://squareup.com/) for years. They have a striking aesthetic which allows their hardware and software to stand out in marvelous ways. Square’s products can now be found almost anywhere – surely, a large number of readers here have seen the beautiful [Square Stand](https://squareup.com/stand), or used the Square card reader at some point.\r\n\r\nSquare made its big splash in 2009 and 2010 with a delightfully-simple card reader. I remember being totally blown away by the elegance of their solution to mobile payment processing. Within a day of receiving mine, I was selling t-shirts out of my car with only a phone in hand.\r\n\r\nBut it’s 2014 now. The world is no longer impressed by card readers. Square knows this, and so they forge their path ahead against competitors like Shopify and PayPal with new ideas and more powerful tools for exchanging money. We’re now witnessing Square filling out their portfolio of side projects and experiments, which leads us to the focal point of this blog post: [Square Order](https://squareup.com/order).\r\n\r\nThe app lets you order food or coffee ahead of time from your favorite lunch spot or coffee bar. Using Bluetooth and geolocation, the restaurant/coffee shop is able to know when you’re nearby and can begin preparing your order before you’ve arrived. One value proposition that isn’t highlighted enough, in my opinion, is that you never have to wait in line again (assuming, of course, that everything works as planned)! Because your payment information is stored in Square, it also means you don’t have to worry about paying once you’ve picked up your order; just show up, grab you food or coffee and be on your way.\r\n\r\nI admit up-front that I haven’t yet used Square Order. [Early reviews](http://www.sfweekly.com/foodie/2014/11/05/square-has-a-new-ordering-app-i-got-coffee-it-was-kind-of-amazing) sound promising though, so I’ll try not to let my lack of real-world usage sway my conclusion on the app’s practicality.\r\n\r\nWhen it comes to the app itself, I’m totally love-struck by some of the design patterns Square has released into the world. Tighter motion and animation, fewer view changes, colorful animation and a warm aesthetic make Square Order one of the most accessible and beautiful apps I’ve ever used.\r\n\r\nLet’s dive in…',
  details,
  tint: '#2b8cd4',
}
