export default [
  {
    description:
      'I love the warm simplicity of the app when it first opens. The transitions here are well-paced, the colors feel inviting and the illustrations create a feeling of intimacy; that’s not something to take lightly considering the size of Square as a corporation.',
    title: 'Welcome splash',
    media: [
      'https://videodelivery.net/620cfdc405c405b81fd1564e866d800d/downloads/default.mp4',
    ],
  },
  {
    description:
      'While this walkthrough design pattern is used by just about every app coming out these days, I’m struck by how Square moved beyond static imagery to incorporate gestures, movement and light animations to draw users in and help them to focus on each step’s instructions. Even the little things – like the way the birds bounce up and down on the roof in the third slide – add a significant amount of emotional connection for first-time users.',
    title: 'Walkthrough',
    media: [
      'https://videodelivery.net/68242687b5f04e338f390e288baf316a/downloads/default.mp4',
    ],
  },
  {
    description:
      'Square Order starts to set user expectations about navigation and design from the very first interaction. Here, I’m entering my email address. Since I already have an account, the screen immediately transitions to prompt for my password. The whole view doesn’t change, but rather the information I need slides gently into view.\r\n\r\nFrom a UX point of view, I could see this being a potential point of confusion for some people. When I enter my email, it’s actually not super clear that the text input has changed and that I’m being prompted for a password. I’m of two minds about whether this was the right decision:\r\n\r\nOn one hand, I think that Square’s target market for this app is technologically-literate folks who are familiar with applications and will pay attention to what’s on the screen. That’s great for me, because it means Square can be a bit more daring with their usability patterns and step out of the typical login-flow comfort zone.\r\n\r\nOne the other hand, I can’t help but feel that Square Order was built only for a younger crowd with some degree of familiarity with technology. In this regard, I wonder if they might be limiting the accessibility of the application overall for people who might not be early adopter techies. What do you think?',
    title: 'Signing up',
    media: [
      'https://videodelivery.net/69b812108311061afa2dfb8b711ed0c5/downloads/default.mp4',
    ],
  },
  {
    description:
      'Oh boy, this detail is slick – when you first log into the app there aren’t any jerky transitions or sudden view changes. Instead, the loading spinner fades lightly out of view while the UI constructs itself, one piece at a time. I’ll likely repeat this point throughout this post, but I really can’t emphasize enough how well-paced the entire app feels. Transitions are crisp and smooth, there’s a perfect amount of easing and friction with every movement and you can’t help but feel a certain sense of tangibility with different elements on the screen.',
    title: 'First view',
    media: [
      'https://videodelivery.net/a70b45c8a9f20e5bc0e92432389e3198/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you don’t have Bluetooth turned on, you’ll see a yellow alert in the app’s header. This doesn’t feel like the most obvious way to alert a user that they’ll need Bluetooth in order to use the app, however I like that it doesn’t completely stop me from interacting with other parts of the app. The transition of elements here feels really great as well.',
    title: 'Bluetooth off',
    media: [
      'https://videodelivery.net/0cad7185516226af1edb68f36ddd388f/downloads/default.mp4',
    ],
  },
  {
    description:
      'Once you find something that looks good, tapping the price brings you to an order confirmation screen. I appreciate that I don’t have to reorient my fingers on the screen to place the order. The button transitions and the way content fades in and out of view feels intentional and solid.',
    title: 'Select an item',
    media: [
      'https://videodelivery.net/8e835e3ab55d5914f1ac0901166878e1/downloads/default.mp4',
    ],
  },
  {
    description:
      'Tapping on the ‘details’ link brings up a slick paper receipt (flat, of course – but the jagged edge along the top is a nice touch) with your order information. I love the typographic hierarchy here – the view is super easy to scan and makes it abundantly clear what you’re paying for.',
    title: 'Order details',
    media: [
      'https://videodelivery.net/55f3e203a5944538f3314698567b1506/downloads/default.mp4',
    ],
  },
  {
    description:
      'I really like how smooth and effortless it is to change the details of your order. I look at other apps like GrubHub and recall just how painful it is to change quantities or make small modifications to an item. With Square Order, it really is simple and fast. It’s nice how the bottom part of the screen narrows to become the ‘Done’ button. It’s a subtle gesture – which may raise some questions about the usability of this particular flow – but once you get the hang of it, it’s a great experience.',
    title: 'Modify an order',
    media: [
      'https://videodelivery.net/b468a8d6efc5afe6bc275818b6a49906/downloads/default.mp4',
    ],
  },
  {
    description:
      'It’s refreshing to see Order ditch the now-commonplace sidebar/drawer design. In this case, selecting your profile in the upper-left corner transitions in my available options. Usually with entire UI changes like these, you’ll see some dropped frames or odd movements as you rearrange elements on the screen. In this case though, I’m continually impressed with the consistency and fluidity of each motion.',
    title: 'My profile',
    media: [
      'https://videodelivery.net/b6531f1067527b8acbb630d0ea70e745/downloads/default.mp4',
    ],
  },
  {
    description:
      'This might be my favorite detail in the entire app – I love the way the link to change card details or phone number transitions into the placeholder for the digits. This feels so much nicer than a modal input. Even Squares number bad design is a refreshing change of pace from the iOS default.',
    title: 'Changing details',
    media: [
      'https://videodelivery.net/ca7f2848dd756c86a8242b569319af53/downloads/default.mp4',
    ],
  },
  {
    description:
      'This detail has the same premise as the previous one, but perhaps feels a bit less polished in the transitions. Tapping my name in the account settings view doesn’t move the label into the placeholder field, like it does for my credit card or phone number. Overall it’s not that noticeable, but still lacks total cohesiveness.',
    title: 'Changing name',
    media: [
      'https://videodelivery.net/a2aa27506571f19a6a1f2621905be1ea/downloads/default.mp4',
    ],
  },
  {
    description:
      'I really like how simple Square Order makes it to change your profile picture. I appreciate that the viewport for the camera is a circle as well, so I know exactly how my picture will appear in all other areas of the app and don’t need to worry about parts of my face being cropped.',
    title: 'Profile picture',
    media: [
      'https://videodelivery.net/a0f270e50ab89d0f1cf45cbd6453de9a/downloads/default.mp4',
    ],
  },
  {
    description:
      'Designing for mobile is incredibly challenging. Creating visual separation and hierarchy among elements on a small screen requires skill and tact – I think Square Order has pulled these things off wonderfully.\r\n\r\nRather than constraining themselves to a tried-and-true design pattern in iOS apps to have the navbar separated by line or color, this app uses a light transition gradient to provide a sense of cohesion across the entire screen. It doesn’t feel like I’m looking at separate “chunks” of information displayed on a screen, but rather that I’m looking at one whole screen with a fluid stream of information.\r\n\r\nI fully expect a search option in the app soon, but for now you’ll need to scroll to find the right places for your order.',
    title: 'Scrolling',
    media: [
      'https://videodelivery.net/fdb86fa91470dd16f8bfc03869c94aa7/downloads/default.mp4',
    ],
  },
  {
    description:
      'This flow is a bit hard to follow since you can’t see my tap locations – sorry about that. All I’m doing is adding an item to my shopping bag in this movie, taking me to a clean illustration and check out button. I like the way the sticker on the shopping bag bears the logo of the store – a nice touch.\r\n\r\nThese small details provide extra context for users, and also add a certain level of real-world parallelism to our normal shopping experiences at stores.',
    title: 'Add an item',
    media: [
      'https://videodelivery.net/b1d6d3116805373399de4cd86ebacf52/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you try to check out without any card information stored on your account, you get this clean alert. On one hand I appreciate that this notice isn’t too intrusive or obnoxious (i.e. not a red warning exclamation or a modal). Conversely, it feels a bit weird to not know what information is missing. If I click on ‘Update Profile,’ what do I need to fix? Making that clear here might help first-time users have a smoother checkout experience.',
    title: 'Checking out',
    media: [
      'https://videodelivery.net/4b922eaa1fcc77cd9cc738eef9d9c148/downloads/default.mp4',
    ],
  },
  {
    description:
      'It feels like this detail is so close to being polished, but just doesn’t quite stick the landing. In the video I’m deleting my shopping bag to start over – the resulting animations are jerky and disorienting. Notably, my shopping bag appears back in view for a split second before taking me back to the app’s home.\r\n\r\nThis isn’t a huge problem, although it might make a user feel as though the action wasn’t successful. Did my bag really get cleared? A small ‘Success’ message might make this infinitely more clear.',
    title: 'Deleting my bag',
    media: [
      'https://videodelivery.net/7a1c2174ac458aa263e515b811e9752f/downloads/default.mp4',
    ],
  },
  {
    description:
      'Tapping on the ellipsis in the top-right corner of the store view reveals contact options for the store – either a direct call or directions. I’m not totally sold on using an ellipsis here, when perhaps using text (“Info”) – while not as aesthetically sexy – would be more clear.',
    title: 'Store info',
    media: [
      'https://videodelivery.net/7e8c800f1cb037dbf31643cd84cd9ed8/downloads/default.mp4',
    ],
  },
  {
    description:
      'When you first open Square Order the main view has a few different “featured” or highlighted menu options from different stores. Over time, Square learns your favorite places and most common orders and tries to save you a step by featuring them here.\r\n\r\nIf you scroll through all of the featured items, you’re greeted with this cute illustration pointing you towards the full shop list. While I admire the design and playfulness of this character, I wonder if there is a way to make the browsing experience a more continuous flow (i.e. not having to teach me a new navigation pattern while I’m still browsing for something).',
    title: 'More options',
    media: [
      'https://videodelivery.net/00a4795d161ed16b245957a2105fb250/downloads/default.mp4',
    ],
  },
  {
    description:
      'Ah, continuity is so beautiful. [Square Order on the web](https://squareup.com/order) is a nice little landing page directing users to text a link for the app to their phone. I love the way the buttons and text inputs behave in the same way that we saw in the app – it’s a nice primer for the subset of users who find the app on the website first.',
    title: 'Web view',
    media: [
      'https://videodelivery.net/4a887a9b6185718c06404a462f6c92b4/downloads/default.mp4',
    ],
  },
]
