export default [
  {
    description:
      'Skype has adopted this really slick new design pattern for navigations and menus. This video captures the moment when you go to upload a new profile photo – notice the bounce and stretched corners of the menu as it pops into view.',
    title: 'Choose a profile picture',
    media: [
      'https://videodelivery.net/2ed554ed3e5d3680743827fce90938da/downloads/default.mp4',
    ],
  },
  {
    description:
      'You might need to watch this one a few times to catch everything going on during the login flow. Starting with a really slick loading indicator, Skype has built a really solid feel to their “first view” flow.\r\n\r\nOnce you hit the dashboard of the app, several elements bubble in – the navigation slides in from the right and the clouds pop up in the background while your profile picture bounces into view. It’s a lot of simultaneous movement, but it gives a very satisfying feel to the app.',
    title: 'Signing in',
    media: [
      'https://videodelivery.net/70beafb33ef3a04d85af844867feb056/downloads/default.mp4',
    ],
  },
  {
    description:
      'This video is just another crisp example of Skype’s menu-display design pattern. To be honest, I’m a bit torn on this one – I love the playfulness of the animation, however after moving around the app for a while it makes certain interactions feel quite sluggish.\r\n\r\nIt’s a tough tradeoff here to get the interaction elements + navigation speed just right; I’m excited to see what Skype’s design team will iterate upon here :)',
    title: 'Add a contact',
    media: [
      'https://videodelivery.net/3c1bee7e61da9f6066eb80f08b19d4fc/downloads/default.mp4',
    ],
  },
  {
    description:
      'Here’s another really slick design pattern that Skype has put into place across the app. When you switch views, the new one bounces into place – if you look really closely, you can actually see the new view overextend to the left before settling back in within the screen boundaries!\r\n\r\nThis will be easier to notice on your phone, with the screen’s bezel providing contrast against all the white on the screen.\r\n\r\nOne other thing to notice is the way the old view fades away into the background, almost falling away behind the new view. It’s such a fast and subtle detail, but adds up to create the overall experience for users.',
    title: 'View changes',
    media: [
      'https://videodelivery.net/b06762292db79051dba4b6668dc2ed25/downloads/default.mp4',
    ],
  },
  {
    description:
      'Here’s another video highlighting just how smooth these view changes are. Again, we see playful bouncing, fading and sliding for so many different elements at once.',
    title: 'More view changes',
    media: [
      'https://videodelivery.net/b3a86c347e820aee2d73ac47ce344a40/downloads/default.mp4',
    ],
  },
  {
    description:
      'I’m on the fence about this details – on one hand, the ‘talking’ emote adds some personality to the app and certainly brings an element of humanity to the pixels. On the other hand, it feels really out of place amongst all the clean lines and flat elements that have been brought into this update.\r\n\r\nI’m going to go out on a limb here and say that Skype has done a lot of user testing on this view – on all of their apps – and for whatever psychological reason, this one converts the best. Just a hunch.',
    title: 'Skype credit emote',
    media: [
      'https://videodelivery.net/a6f76b80f691be9fcdd2f9862980953c/downloads/default.mp4',
    ],
  },
  {
    description:
      'This is absolutely my favorite part of the new Skype app – swiping through the navigation. What I love the most is how swiping subtly moves the header, but not in a repetitive way. In fact, you can keep swiping in one direction and see totally different parts of the “sky” in the header – sometimes its completely covered by clouds, but swipe far enough and the blue glow will come into view.\r\n\r\nThis parallax-style navigation feels really nice as a user. I fully expect other developers to explore this design pattern – I can’t wait to see more!',
    title: 'Swiping through navigation',
    media: [
      'https://videodelivery.net/2eb9f2d58684514f470dd00e55bcc952/downloads/default.mp4',
    ],
  },
  {
    description:
      'You might need to play this video a couple times through, as this design detail happens quite quickly. When you go to add an attachment to the message, the ‘attach’ icon turns into an ‘x’, while the ‘send’ button fades away preventing a premature message send.\r\n\r\nThis adds a lot to the overall UX, in my opinion, by guiding users subtly through these different actions, making sure they don’t accidentally tap a button that they might regret (in this case, hitting send before successfully adding an attachment).',
    title: 'Attachments in messages',
    media: [
      'https://videodelivery.net/c9a5c30644ef09b45cd68851f3a0e65f/downloads/default.mp4',
    ],
  },
  {
    description:
      'When you go to attach a video recording, this helpful popup appears telling you to hit the record button whenever you’re ready. I like the way the tooltip interacts so nicely with the Skype design language – bubbles, clouds and lots of circles. Even the text here – “looking good!” – adds to the personality of the app.',
    title: 'Record a video',
    media: [
      'https://videodelivery.net/e7012398e0e96414f21d8dab0cabd1e3/downloads/default.mp4',
    ],
  },
  {
    description:
      'Here’s another small detail that came up while I was creating a new message. Once I selected a contact, the attachments icon lit up while the send icon switched from an airplane icon to a check-mark. I’m not totally sure why the icon switch here is necessary, but again I’ll lend my best judgement to the fact that the Skype team has tested this interaction out with users and found that it helped guide them through this task better than other alternatives.',
    title: 'Starting a new chat',
    media: [
      'https://videodelivery.net/839f23a5d32846c6628f5fd8e7100996/downloads/default.mp4',
    ],
  },
]
