export default [
  {
    description:
      'Tapping a secret to view the comments section has a wonderful little animation – the card slides to the top of the screen, gently pushing the status bar out of sight.',
    title: 'Viewing a secret',
    media: [
      'https://videodelivery.net/d27ea1da0605e844c897b49e0bc6c4f0/downloads/default.mp4',
    ],
  },
  {
    description:
      'When viewing a secret with just a couple comments, we get a nice preview of what happens when you start to scroll. The image starts to fade, the text blurs, and the ‘rubberband’ tightens up, giving the user an almost physical resistance to the scroll.',
    title: 'Scrolling a secret',
    media: [
      'https://videodelivery.net/c503053163e979ae8c5ec8cd5acae0f5/downloads/default.mp4',
    ],
  },
  {
    description:
      'Here’s the same interaction as above, but this time we get to see the full effect. As we scroll through the comments, a tiny piece of the secret is blurred out but remains at the top of the screen – a subtle reminder of what content the user is looking at.',
    title: 'The full scroll',
    media: [
      'https://videodelivery.net/84da09b545aad81486c529ebb48b5811/downloads/default.mp4',
    ],
  },
  {
    description:
      'I really like what Secret has done with the composer. The traditional approach here would have been to add toggles or dropdowns for users to select background colors or textures. Secret does away with this completely, making the background color change with a horizontal swish of the finger.',
    title: 'The composer - colors',
    media: [
      'https://videodelivery.net/0cd3d94e472fb4a16207cbe232257f0b/downloads/default.mp4',
    ],
  },
  {
    description:
      'Swiping up and down within the composer lets users toggle the texture for their post. Again, I love how this visual preview is so tactile, doing away with traditional sliders or toggles.',
    title: 'The composer - textures',
    media: [
      'https://videodelivery.net/696157fb74715139c4ee73234926d50b/downloads/default.mp4',
    ],
  },
  {
    description:
      'I thought that this detail was quite clever, and something that could have easily been overlooked. If you upload a photo for your post’s background, sliding horizontally with your finger allows you to adjust the blur of the photo. This is a nice way to add subtle, artistic touches to your posts.',
    title: 'Slide to blur',
    media: [
      'https://videodelivery.net/b7692e742d117d751013589ad33f3160/downloads/default.mp4',
    ],
  },
  {
    description:
      'Along the same lines, sliding vertically within the photo view allows you to quickly adjust the saturation of your photo. Why don’t more photo editing apps have these little details?',
    title: 'Slide to saturate',
    media: [
      'https://videodelivery.net/5879bf6f4550276f7c5ea203a7b75735/downloads/default.mp4',
    ],
  },
  {
    description:
      'When you first use Secret, the app guides you through many different interactions and walks you through all the different buttons and their meanings. Tapping on the ellipsis, next to the comments and hearts, brings up a window to hide or report that specific post.\r\n\r\nI found that this same window can be activated by swiping horizontally along the post, rather than tapping the ellipsis. I love how the post itself is blurred out in the process, helping you to focus on the current dialog.',
    title: 'Post options',
    media: [
      'https://videodelivery.net/2ed7c15d6d7535b610c0476a90a9231d/downloads/default.mp4',
    ],
  },
  {
    description:
      'Swiping from the left, alternatively, lets you quickly like a post. I love the interaction here – the app lets you over-swipe, moving the heart off-center to the right of the post. Once you release your finger though, the heart snaps into place before dropping down into the like count. The movement and gestures here are fluid and snappy.',
    title: 'Liking a post',
    media: [
      'https://videodelivery.net/6f0d8b5fbc588c41d9050fbee44bebd1/downloads/default.mp4',
    ],
  },
  {
    description:
      'I wanted to showcase this detail to highlight a different approach to view switching in iOS. Here, Secret has created a subtle animation in the title bar to indicate a view change. It’s a nice touch to have the activity view bounce lightly off the bottom of the screen, although it admittedly doesn’t feel quite natural – perhaps some easing tweaks here could help make the bounce feel more realistic.',
    title: 'Activity view',
    media: [
      'https://videodelivery.net/326b98086e0c9b1a6f0f828e3abfb29f/downloads/default.mp4',
    ],
  },
  {
    description:
      'This last detail shows how a user brings in the app settings. I love the way the settings cog spins in the background before being blurred out of view. It’s the movement and subtle touches here that bring life into a part of the app that could easily have been overlooked in favor of static comps.',
    title: 'Settings',
    media: [
      'https://videodelivery.net/3064976db0976341c3b53fca2e73ec8b/downloads/default.mp4',
    ],
  },
]
