export default [
  {
    description:
      'I’d love to start exploring more onboarding experiences for different apps. Onboarding and user activation is an incredibly nuanced and challenging problem for designers, and it’s an ever-evolving process to understand and improve the experience for people new to a product. I really appreciate what Pinterest does – both on their app and website – with their new user experience.\r\n\r\nThe focus here is entirely on benefits, not features. They don’t talk about pins, sharing, social media, et cetera. No – they talk about how people are using the app to solve real challenges or problems in their lives. The panning images here, accompanied by the simple value statements, make for a compelling (and intriguing) experience.',
    title: 'Splash screen',
    media: [
      'https://videodelivery.net/4db8546aa43168dd137d24f612248d8c/downloads/default.mp4',
    ],
  },
  {
    description:
      'I’m biased towards apps that don’t hesitate to break away from default iOS design patterns, yet still retain usability and clarity. Here, Pinterest’s search filters add a nice touch that separates themselves from the standard iOS toggles.',
    title: 'Search filters',
    media: [
      'https://videodelivery.net/e261b975c8a5d13e62690399acbf2ca3/downloads/default.mp4',
    ],
  },
  {
    description:
      'After exploring the app for some time, you start to notice the subtle things that make the product so enjoyable to use. Subtle transitions, entrances and the use of fading elements helps create this incredibly smooth experience for users. There’s not too many instances of sudden, static state changes that I was able to find anywhere in the app.',
    title: 'Board view',
    media: [
      'https://videodelivery.net/3c449c124859833faf64e93a09dae89c/downloads/default.mp4',
    ],
  },
  {
    description:
      'My hat goes off to anyone willing to try something different from the default iOS7 loading indicator. Here, Pinterest goes with something simple and clear – nothing too wild or out of the ordinary – but it adds a nice touch and polish that goes a long way for building a memorable product.',
    title: 'Pull to refresh',
    media: [
      'https://videodelivery.net/4725bcc65cb40bbafa3aa267751be90f/downloads/default.mp4',
    ],
  },
  {
    description:
      'This recording is a bit jumpy – sorry about that. I wanted to highlight the tooltip here as general nod towards Pinterest’s clean visual style and clear instructions to guide new users around different parts of the app.\r\n\r\nThe second part of this design detail is so easy to overlook; I missed it myself a few times. Keep an eye here on the follower count as I follow this board. The text springs to life, using motion to help me understand the context of my actions.',
    title: 'Tooltip + following',
    media: [
      'https://videodelivery.net/451b46b2730a732391bbf8b7d2206dd8/downloads/default.mp4',
    ],
  },
  {
    description:
      'Plants!\r\n\r\nScrolling + blurring image backgrounds aren’t really new anymore – although they still provide a really slick experience for users. What I wanted to really focus on here was what happens as you get past the header here – notice the way the text ‘Plants’ bounces into place. The fluidity here is amazing – it would have been so easy to have that text just…appear. But the motion here adds life and depth to the app that I think people out there will appreciate.\r\n\r\nEven when I start to scroll back up, the text bounces and scales away into the distance. Nice touch!',
    title: 'Scrolling in a board',
    media: [
      'https://videodelivery.net/2e4fa88bd7763a8a47aadc4cd2b70bb9/downloads/default.mp4',
    ],
  },
  {
    description:
      'This recording emphasizes the overall smoothness that users experience when browsing around the app. Every transition is carefully planned and designed. I love the way the main view blurs and scales back into the distance whenever a new modal-view appears. Slick.',
    title: 'Pin details',
    media: [
      'https://videodelivery.net/2a8b2f21bab692ebc59fedbd618ab990/downloads/default.mp4',
    ],
  },
  {
    description:
      'When you like a photo, the heart bounces to life.\r\n\r\nThese are the kinds of details that are so easy to overlook and brush aside, yet for me, they are the details that add the most life and character to an app. Knowing that the designers and developers out there care about these small details means a lot to me as a consumer.',
    title: 'Liking a photo',
    media: [
      'https://videodelivery.net/c6e1432ae3e3e0892ac9b0c49213b395/downloads/default.mp4',
    ],
  },
  {
    description:
      'It takes a keen eye here to spot the subtle tilt of a pin as it fades in and out of view. The transition is so small, and happens so fast – and I can’t get enough of it! The tilt of the cards and the way the new one swings in from the bottom adds depth and tangibility to the photos – these are the kinds of details that matter.',
    title: 'Navigating pins',
    media: [
      'https://videodelivery.net/00593bf506d9be83a500f976a629734c/downloads/default.mp4',
    ],
  },
  {
    description:
      'Bouncy! Pulling down on a pin takes you back to the main board. Everything is super springy and the transitions here are quite smooth.',
    title: 'Back to the board',
    media: [
      'https://videodelivery.net/6083efa2804af0194420e75c25aac619/downloads/default.mp4',
    ],
  },
  {
    description:
      'Tap and hold a pin to bring up these quick actions – bubbly, playful little icons that let you quickly interact with content or share photos with friends. The physics here are remarkable – there’s a certain resistance and “magnetism” that the icons have with your touch. If you haven’t tried this in person, I’d highly recommend it!',
    title: 'Quick actions',
    media: [
      'https://videodelivery.net/356da6e98afde60dd614cbfeb8761e62/downloads/default.mp4',
    ],
  },
  {
    description:
      'The consistency here is great whenever you quick-pin an item. The modal slides into view while the background blurs and scales into the distance. Super clean.',
    title: 'Quick pin',
    media: [
      'https://videodelivery.net/dc6390c245c9c7881c30e6fbd210cbef/downloads/default.mp4',
    ],
  },
  {
    description:
      'When you quick-like a photo, check out the little heart that bubbles on top of the photo – a subtle confirmation that the user’s action was completed successfully.',
    title: 'Quick like',
    media: [
      'https://videodelivery.net/af5f1923aa33b06904cfad84e983eaa5/downloads/default.mp4',
    ],
  },
  {
    description:
      'Oh my, this one is good. Unliking an item here works as expected, but the icon changes to a broken heart. For some reason this small change adds a lot of emotional charge to the un-liking action – I have a hunch that in user testing this actually resulted in fewer folks un-liking a post…but that’s just a guess!',
    title: 'Unlike',
    media: [
      'https://videodelivery.net/b5071b03120886e7f36e7319b5180862/downloads/default.mp4',
    ],
  },
  {
    description:
      'Sending a photo gives us the same slick transitions and blurs that we’ve come to expect in the Pinterest ecosystem. It’s also worth paying attention to the little black confirmation bubble at the bottom of the screen once the message has been sent.',
    title: 'Sending a pin',
    media: [
      'https://videodelivery.net/e95db6482f520addb99c41c0b1d04b9f/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you add a custom message to a shared pin, the textarea has a really slick expansion – I love the way it pushes the title bar to the top of the screen, filling the space and removing all distraction.',
    title: 'Add a message',
    media: [
      'https://videodelivery.net/efb4a979bb1b6af26df4593cf36cbeca/downloads/default.mp4',
    ],
  },
  {
    description:
      'Adding content from the tab bar here is so slick – the plus icon rotates to an x, giving users a quick way to close out and cancel. I’m not sure about the usability of this design pattern, but man it looks good! As always, I appreciate the transition of the icons into view, using scale and color to bring attention to the key actions on the screen.',
    title: 'Tab-bar actions',
    media: [
      'https://videodelivery.net/f8c27bcdc9eeb69b673618b43ba85983/downloads/default.mp4',
    ],
  },
  {
    description:
      'As the final detail in this post, I wanted to highlight some of the subtle brilliance nested on the Pinterest homepage. The background, slowly scrolling through rows of photos, is tied directly to the headline and value prop. I grabbed a view videos here to show some of the different contexts that are used – planning a trip, planting a garden, going for a run – I can only dream about data the designers here were able to play with to end up with this landing page design style.',
    title: 'Pinterest landing page',
    media: [
      'https://videodelivery.net/b4667f3e7d7f5df389303bc30f48cd35/downloads/default.mp4',
    ],
  },
  {
    description: ' ',
    title: 'Pinterest landing page pt. 2',
    media: [
      'https://videodelivery.net/2570cc102674df729b96183929782d8b/downloads/default.mp4',
    ],
  },
  {
    description: ' ',
    title: 'Pinterest landing page pt. 3',
    media: [
      'https://videodelivery.net/fb31bf3916096803ddb06bd676d1d4e2/downloads/default.mp4',
    ],
  },
]
