export default [
  {
    id: '1',
    description:
      'Notice the ‘hamburger’ menu flipping into an X, with the most subtle bouncing effect. I love the slight delay on the sliding animation as my pages and groups come into view.',
    title: 'View pages and groups',
    media: [
      'https://videodelivery.net/e62413bcd9503b93fbbf764e0482036c/downloads/default.mp4',
    ],
  },
  {
    id: '2',
    description:
      'Just about every popup or menu in Paper can be closed by pulling up or down when there’s no more room to scroll. You can see this implemented on the publicity setting here when composing a new post.',
    title: 'Closing a popup',
    media: [
      'https://videodelivery.net/b827ee2a99c1e110a1e8e377f729ae5d/downloads/default.mp4',
    ],
  },
  {
    id: '3',
    description:
      'Just about every heading or title in Paper has this beautiful shine effect to it, which reminds me of iOS’s ‘Slide to Unlock’ text. Turns out that this shine doubles as a loading indicator.',
    title: 'Glossy headlines',
    media: [
      'https://videodelivery.net/98575355a295709505af49af9f4c7677/downloads/default.mp4',
    ],
  },
  {
    id: '4',
    description:
      'Watch this one a few times and pay attention to everything going on. When you pull down, the background slides down just a tad, the arrow at the top of the message bubble stretches and ‘pops’, and everything bounces lightly back into place. Amazing.',
    title: 'Closing tooltips',
    media: [
      'https://videodelivery.net/7f3d155326e990d9fb4ca89584a0b57e/downloads/default.mp4',
    ],
  },
  {
    id: '5',
    description:
      'I noticed that as you’re opening a card to view a webpage, Paper starts to load things in before you’ve fully expanded the card. This beautiful little bit helps keep browsing fluid and fast.',
    title: 'Background loading',
    media: [
      'https://videodelivery.net/ff2501acbc923d658c2d761bfc3c7423/downloads/default.mp4',
    ],
  },
  {
    id: '6',
    description:
      'Again, pay attention to the light bounces in different parts of this view as you flip a web page closed. Did you see that little sheen of light go across the top of the card as it closes? Stunning.',
    title: 'Closing a webpage',
    media: [
      'https://videodelivery.net/1d5ef3f13dce7b87bcf260b57cca8a24/downloads/default.mp4',
    ],
  },
  {
    id: '7',
    description:
      'This one was highlighted in Paper’s debut demo video, and has certainly gathered a lot of attention. I love the small scroll bar that shows your current position on the photo. Someone has already replicated this effect with HTML/CSS/JS – [here’s the tutorial](http://jt.io/2014/photo-tilt/).',
    title: 'Panorama photos',
    media: [
      'https://videodelivery.net/13a9e87fbd472daa5b99416ff1aa484d/downloads/default.mp4',
    ],
  },
  {
    id: '8',
    description:
      'No animation in Paper is jerky or unrefined. When I start to type out a search, notice the subtle fading in and out of the various elements on the page?',
    title: 'Searching',
    media: [
      'https://videodelivery.net/c1ce9c944b9376d3adf3354ec7253587/downloads/default.mp4',
    ],
  },
  {
    id: '9',
    description:
      'Pay attention to the typographic changes on web cards, as Paper changes its own style to reflect those of the origin website.',
    title: 'Typography matching',
    media: [
      'https://videodelivery.net/2fde27de14ab8e1322c675f58370654e/downloads/default.mp4',
    ],
  },
  {
    id: '10',
    description:
      'Yep, you can even swipe left/right to close a news story, with the card folding neatly and bouncing back into place.',
    title: 'Swipe to close',
    media: [
      'https://videodelivery.net/056b926fdea1e1b8f905a5bd09b04b51/downloads/default.mp4',
    ],
  },
  {
    id: '11',
    description:
      'Chat Heads aren’t new to the Facebook ecosystem on iOS, but it’s still a delightful little interaction to see the person (or page’s) avatar slide into view with a familiar bounce.',
    title: 'Chat heads',
    media: [
      'https://videodelivery.net/096c262ccf33fe4acff911dabce0b32b/downloads/default.mp4',
    ],
  },
  {
    id: '12',
    description:
      'If you’re composing a post, you can pull down once to reveal the ‘Delete’ button. If you start pulling down again, we get this beautiful interaction that allows you to delete the draft by completing the ring.\r\n\r\nI was surprised that you had to pull down twice to activate this interaction, rather than having it be one longer-pull. Perhaps in user-testing the designers found that it was too easy to accidentally delete a draft with one pull.',
    title: 'Delete a draft',
    media: [
      'https://videodelivery.net/0c535e012ef7d1cfd46490f412d0e31f/downloads/default.mp4',
    ],
  },
  {
    id: '13',
    description:
      'I still haven’t figured out the utility of this detail, but swiping left/right when viewing a page or profile lets you navigate back in time through the timeline of updates.',
    title: 'Back in time',
    media: [
      'https://videodelivery.net/a9fe8e0776425b1cd90c732d7cc50afe/downloads/default.mp4',
    ],
  },
  {
    id: '14',
    description:
      'We’re used to seeing this interaction on the main Facebook app, but it still remains fun to play with. Flinging pictures around the page toggles them open/closed. I love how easy, and fun, Paper makes it to interact with photos.',
    title: 'Viewing/dismissing photos',
    media: [
      'https://videodelivery.net/8b163f07391ceb09031093532a60d2ba/downloads/default.mp4',
    ],
  },
  {
    id: '15',
    description:
      'This is one design detail in Paper that had me scratching my head. Which one is off? Which one is on? iOS toggles are turned ‘On’ when moved to the right, but for some reason this doesn’t feel obvious on Paper.',
    title: 'Toggles',
    media: [
      'https://videodelivery.net/f15844d462e73e66c2698ee15778ec1b/downloads/default.mp4',
    ],
  },
  {
    id: '16',
    description:
      'I love everything about this view. When adding or removing a photo from the composer, we are met with all sorts of subtle bouncing animations, paired with the text resizing/relocating.',
    title: 'Add/remove photos in composer',
    media: [
      'https://videodelivery.net/f8e28604ed76257124f56b193ed2359b/downloads/default.mp4',
    ],
  },
  {
    id: '17',
    description:
      'Tap + hold on the large photo that covers the top-half of the screen to open the customize view. I love how the cards slide around, just ready to be moved, rearranged, added and deleted.',
    title: 'Manage categories',
    media: [
      'https://videodelivery.net/115a148a81091abc1091271ab50abd70/downloads/default.mp4',
    ],
  },
  {
    id: '18',
    description:
      'Pull the search results side-to-side to see a beautiful rubber-banding of the list items.',
    title: 'Search details',
    media: [
      'https://videodelivery.net/1610409d7043662c67998e18c71304ae/downloads/default.mp4',
    ],
  },
  {
    id: '19',
    description:
      'Click on the “more likes” box on a popular post to see people’s names fly out into a long list.',
    title: 'Expanding likes',
    media: [
      'https://videodelivery.net/fea7bf2189ab36ab1d263c68cef59f87/downloads/default.mp4',
    ],
  },
  {
    id: '20',
    description:
      'This one is super slick. Watch the category title fade out as it gets closer to the icons in the upper right corner. And then right as the category title hits the right side of the screen, it fades smoothly back in.',
    title: 'Fading titles',
    media: [
      'https://videodelivery.net/3a6d512f9f3532e944b1b5935da9ddd7/downloads/default.mp4',
    ],
  },
  {
    id: '21',
    description:
      'I love the way that the cards slowly peek out from behind the front card. Even the status bar fades in and out of view, another small but beautifully executed detail.',
    title: 'Status bar reveal',
    media: [
      'https://videodelivery.net/185389ce4a5ceededc87dd9cda5bfed3/downloads/default.mp4',
    ],
  },
  {
    id: '22',
    description:
      'Tapping the ‘like’ button on a post results in a colorful explosion of blue fireworks, coupled with the signature Paper bouncing effect. I love this one!',
    title: 'Like button fireworks',
    media: [
      'https://videodelivery.net/b7dde740e2f262fc5ed6d5f180afe5e0/downloads/default.mp4',
    ],
  },
  {
    id: '23',
    description:
      'It’s still amazing to me to see how fluid the transitions are when toggling between different tooltips. Watching the icons in the bottom bar bounce and wiggle as they’re selected/deselected provides subtle context about which view the user is currently seeing.',
    title: 'Toggling tooltips',
    media: [
      'https://videodelivery.net/b460bf7da9a1eb57015e745527cef55b/downloads/default.mp4',
    ],
  },
  {
    id: '24',
    description:
      'As you expand the card views across Paper, it’s worth noting the way the background slowly scales back and fades into the distance. This interaction builds the user’s sense of location within the app and provides depth among the views. Beautiful!',
    title: 'Expanding cards',
    media: [
      'https://videodelivery.net/32aa3187190e9ff5daa52e9e3daaeb16/downloads/default.mp4',
    ],
  },
]
