export default [
  {
    description:
      'I have to address up front how challenging it was to record the videos for this post. I scoured the Play store for good mirroring apps, I Googled my way down a dozen rabbit holes and eventually had to resort to Twitter to find the right answer – shoutout to [Jeremy Le Van](https://twitter.com/jeremylv) for the help! The solution: I had to download the Android SDK and platform tools in order to record the videos via command line prompts. I’m a bit shocked that we still haven’t seen a better solution here for screen recording on Android – devs, I would have paid $5-10 for an easy-to-use solution here. Wink wink.\r\n\r\nThese quirks aside, I’ve totally fallen for Lollipop’s aesthetic. Material Design has found its away across more apps and OS-level tools, making the entire experience consistent and comfortable. This lock screen (aside from the pesky debugging notification) is really slick – I love the slowly glowing ring around the lock icon.\r\n\r\nFrom a usability perspective, I still feel like Apple wins the first-user-experience battle. Slide to unlock is more clear, and iOS’s gesture hints (right-facing arrow + animation on the text) provides users with more context about what to do.',
    title: 'Lock screen',
    media: [
      'https://videodelivery.net/8105d403accf2f1eb0c727ab576b6b17/downloads/default.mp4',
    ],
  },
  {
    description: 'Here’s what happens if you tap the lock icon.',
    title: '',
    media: [
      'https://videodelivery.net/b3c8506228789e4d5012076c84e5e2b7/downloads/default.mp4',
    ],
  },
  {
    description:
      'Circles everywhere. If you’re not familiar with Material Design, or Android in general, this post will surprise you with how versatile the circle can be in a software world dominated by rounded rectangles. The shapes provide an interesting contrast and a breath of fresh air to software design.\r\n\r\nThe Material Design spec provides some more information about this design decision in [Responsive Interaction](http://www.google.com/design/spec/animation/responsive-interaction.html#):\r\n\r\n<blockquote>“Responsive interaction builds trust with the user and engages them. When a user interacts with an app and beautiful yet perfectly logical things happen, the user feels satisfied—even delighted. The interaction is thoughtful and purposeful, not random, and can be gently whimsical but never distracting. It encourages deeper exploration of an app.”</blockquote>\r\n\r\nIn this video, you can quickly access the camera or phone by swiping the bottom icons inwards (again, the usability here is questionable). I do, however, like the way the interface adjusts to your actions by fading out the other two calls-to-action along the bottom bar.',
    title: 'Lock screen interactions',
    media: [
      'https://videodelivery.net/6e00d9cb3d4064587e740972bd143c72/downloads/default.mp4',
    ],
  },
  {
    description:
      'One thing I really want to highlight in this post is how powerful the notifications are on Android. This video highlights just one minor example (with more later in this post), but tapping + holding on a notification from the lock screen will unveil the settings for that parent application. Tapping the information icon will open the settings for that specific app, providing a faster way to manage your notifications.',
    title: 'Notification settings',
    media: [
      'https://videodelivery.net/a84db470c213aecf08127be10205d1ab/downloads/default.mp4',
    ],
  },
  {
    description:
      'The soft keys along the bottom of the screen – back, home and multi-tasking – are one of Androids biggest differentiators from iOS. Where iOS apps are adopting the swipe-to-go-back interaction, Android relies more heavily on the ‘back’ soft key that persists along the bottom of the screen. As a long-time iOS user, it’s hard for me to remember that this functionality even exists. But when I do remember, it’s a wonderful way to navigate through applications and it provides a beautifully-consistent navigation pattern across the entire system. This lack of consistency is a glaring usability issue on iOS.\r\n\r\nThis video just highlights some of the slick animations that accompany soft key taps. Pressing and holding the ‘home’ icon brings up the Google Now button – flicking your finger up will take you to Google Now.',
    title: 'Android navigation',
    media: [
      'https://videodelivery.net/6b7871464d3975d8f7c6b09cf3b57b81/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you swipe right on the home screen, Google Now starts to fade into view. Notice the menu icon slide into place in the search bar once you reach the halfway point. That icon, when pressed from the Google Now view, brings up your user settings and Google Now preferences.\r\n\r\nIt’s worth mentioning that Lollipop still has a few small consistency issues that are lingering, but will no doubt be cleaned up in future releases. For example, here’s the slideout menus in the Play Store versus Google Now:\r\n\r\n<img src="https://brianlovin.s3.amazonaws.com/lollipop-3.png" width="100%">',
    title: 'Google Now',
    media: [
      'https://videodelivery.net/b5c19ac159693981bc496e077962b8e6/downloads/default.mp4',
    ],
  },
  {
    description:
      'Circles all around! I had to rewatch this video several times to pick up all the subtle movements and animations that happen when you activate voice search. Things move quickly, so pay close attention!\r\n\r\nThis video perfectly captures the intense attention to detail across Lollipop. Elements respond gracefully to your touch, movements are quick and snappy with the perfect amount of easing, and a brilliant use of color breathes life into the OS.',
    title: 'Voice search',
    media: [
      'https://videodelivery.net/ea8074737a61eac58a6f6bde3363a511/downloads/default.mp4',
    ],
  },
  {
    description:
      'Lollipop’s multitasking is slick. It feels snappy and responsive, and creating a sense of depth adds character to the OS. I don’t have a preference either way on the iOS or Android multitasking menus – they both feel great and work well within their respective ecosystems.',
    title: 'Multitasking',
    media: [
      'https://videodelivery.net/84cfb04a0e26778c55ca5fcd76d89bd9/downloads/default.mp4',
    ],
  },
  {
    description:
      'Lollipop’s multitasking is slick. It feels snappy and responsive, and creating a sense of depth adds character to the OS. I don’t have a preference either way on the iOS or Android multitasking menus – they both feel great and work well within their respective ecosystems.',
    title: 'Multitasking',
    media: [
      'https://videodelivery.net/516d7810d3b8c58cfc1f0a79e904a6f8/downloads/default.mp4',
    ],
  },
  {
    description:
      'Scrolling through the multitasking menu feels so nice – movements are fluid and the physics here have just the right amount of friction. Because Android only shows a portion of each app’s screen at a time, more cards can be stacked at once in the multitasking view (remember that iOS only shows 3 apps at a time!).',
    title: 'Multitasking scrolling',
    media: [
      'https://videodelivery.net/f0cf26fb62e293677d057bf46a4aeb23/downloads/default.mp4',
    ],
  },
  {
    description:
      'When it comes to closing apps from the multitasking view, you can either swipe-to-close or tap the ‘x’ in the upper-right corner. It’s amazing how even the close icon here incorporates circular animations and movements to maintain consistent interaction design.',
    title: 'Multitasking close',
    media: [
      'https://videodelivery.net/9551887841fe980b36fd94e5cb3dd617/downloads/default.mp4',
    ],
  },
  {
    description:
      'Lollipop’s notification center is stunning. Seriously – it’s insanely useful, easy to read and quick to navigate. I love some of the animations and transitions here as I open up my settings view. Check out the cog that rolls into place or the way the divider line draws itself out from the center of the screen. I love the way the notification modules stack on top of one another when there’s no more space left on the screen – design details, indeed.',
    title: 'Notification center',
    media: [
      'https://videodelivery.net/97237160a56ff117509209f79ea260ff/downloads/default.mp4',
    ],
  },
  {
    description:
      'Android provides a way to create multiple users on one device, allowing multiple people to keep their apps and content separate. This isn’t really a privacy thing – switching between accounts isn’t locked down by default – but more of a way to give power back to users. In my mind this feature makes the most sense for tablets which are more likely to be shared among family members.\r\n\r\nIn terms of the design here, I found it odd that I could tap my user profile to open the user preferences, but couldn’t tap it again to close. You’ll see me try it in the video above. While Material Design brings consistency and life to the OS, the ‘More Settings’ and ‘Done’ buttons are not obvious ways to navigate within this view.',
    title: 'Users',
    media: [
      'https://videodelivery.net/0d4f4d9e14306d55b1aa45ebb5ca1f16/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you tap the cog from the notification center it opens up the device settings view. There’s an insane amount of whitespace here, which depending on your preferences is either a good thing or a frustrating waste of screen real estate. But still, the text is clear, the segmentation of controls makes sense and the navigation is easy. It’s interesting that iOS doesn’t have a quick way to access the settings like this from their control center – it really is quite useful and saves users from having to dig folders or pages of apps.',
    title: 'Settings view',
    media: [
      'https://videodelivery.net/3ad1ef29a95ecfebcd2674b8314b4a64/downloads/default.mp4',
    ],
  },
  {
    description:
      'I love this little detail: when you adjust the brightness of your phone, the settings view fades out of sight to reveal your content underneath. This helps gives users a more accurate understanding of what their content will actually look like once the brightness has been changed.',
    title: 'Brightness controls',
    media: [
      'https://videodelivery.net/575ca7c2efcd4f05108d3faa76dbf152/downloads/default.mp4',
    ],
  },
  {
    description:
      'I didn’t get the best recording here, so my apologies if it’s confusing! The key thing I wanted to highlight was that this settings view is really powerful. I can quickly toggle networking services on or off, turn on the flashlight or lock the screen orientation. What is not obvious, however, is that ‘Bluetooth’ and the wifi network name (Wu-Tang Lan, in my case) are separate labels which can open their own respective settings view. This isn’t really clear until you start tapping around.\r\n\r\nOne other cool thing that Dan pointed out to me was how different apps can secure a place in the settings pulldown. In this case, a screen capture app and a mobile hotspot automatically get added to this settings view. It’s still not quite clear how to customize these icons here, or delete them if I’d rather not have them shown, but I love this flexibility of the OS to accommodate each individual user:\r\n\r\n<img src="https://brianlovin.s3.amazonaws.com/lollipop-4.png" width="100%">',
    title: 'Settings pulldown',
    media: [
      'https://videodelivery.net/9930aef34e5920600fc541b0874bfb44/downloads/default.mp4',
    ],
  },
  {
    description:
      'Clear. All. Notifications. Thank you, Android, for this wonderful little touch. The icon to perform the action is not quite obvious, but the feature itself is so useful. I will be patiently awaiting this feature on iOS!',
    title: 'Clear all notifications',
    media: [
      'https://videodelivery.net/8ced393107f7d570d716226ec8e48da7/downloads/default.mp4',
    ],
  },
  {
    description:
      'This video captures a simple preferences toggle. The motion and color here are really nice touches. One thing about Lollipop, or Android in general, is that you can long-press on an option to move things in slow motion. I’m not sure what the practical reason for this could be, but it makes for an easy way to showcase everything going on with Material Design in this post!',
    title: 'Toggles',
    media: [
      'https://videodelivery.net/5c06f389111158980ed283c4328b8dc9/downloads/default.mp4',
    ],
  },
  {
    description:
      'Camera app design must be insanely fun, but impossibly challenging. Giving people easy access to controls and configurations without obscuring the view itself can be a tricky balance. I thought I’d share a comparison shot of Lollipop vs. iOS 8 below – of course, Android on the left and iOS on the right:\r\n\r\n<img src="https://brianlovin.s3.amazonaws.com/lollipop-2.png" width="100%">\r\n\r\nI suppose there’s no right answer to which design is better. Both make it easy to access settings and provide a clear way to snap a photo; that’s the most important thing. But for me iOS has built the interface in such a way that I feel in control while using my camera, but not bogged down in the configuration. That’s really important to casuals like myself.\r\n\r\nThe video above captures the camera app opening on Lollipop. The icon animations give context to users and helps them to know where more settings can be found. I thought that it could have been a nice touch to have the camera icon in the center of the screen during the loading transition move down to become the actual camera button rather than flying up and out of view.',
    title: 'Camera',
    media: [
      'https://videodelivery.net/dabdf13df0e7ec3a5ea3c48ed6ae84b7/downloads/default.mp4',
    ],
  },
  {
    description:
      'There are some quick options available within the camera app that let you toggle timers, gridlines, HDR images and flash. The icon on the right is to switch between the front and rear camera, which wasn’t immediately obvious. That icon seems like it could be a tricky one to design, and I’m not quite sure this one makes the most sense – in many ways it looks like an ‘exit’ icon: a door with an arrow to close the options panel.',
    title: 'Camera options',
    media: [
      'https://videodelivery.net/1eb0b4a4593403c41c92fa828213ae02/downloads/default.mp4',
    ],
  },
  {
    description:
      'I’ll end this post by looking more at Lollipop’s notification design. I have a hunch that I’ve only scratched the surface here on what developers are doing with interactive notifications, so if you know of any other cool ones give me a shout on [Twitter](https://twitter.com/brian_lovin)!\r\n\r\nIn this video, I have a few Twitter notifications stacked up. If I tap, it expands the notification giving me a complete at-a-glance view of what I missed in that specific app. The motion here is gorgeous and the way the notifications react to one another feels right.',
    title: 'Expanded notifications',
    media: [
      'https://videodelivery.net/ea3f06c0867d288efb4f7a68e3082035/downloads/default.mp4',
    ],
  },
  {
    description:
      'If you have more notifications than can fit on the lock screen, Lollipop begins to group and stack them to save space and prevent notification overload. A double tap expands everything at once which is a great way to manage information on the lock screen.',
    title: 'Notification overload',
    media: [
      'https://videodelivery.net/d7a93e70436f6cedfc0f831da0cbb2b1/downloads/default.mp4',
    ],
  },
  {
    description:
      'That’s it for part one of this Lollipop Design Details! I hope you’ve enjoyed the videos and thoughts here – give a shout on [Twitter](https://twitter.com/brian_lovin) if I’ve missed anything at all! Part 2 will be coming soon to take a closer look at some of the stock Android apps – if you’d like to be emailed about future posts, sign up for the [free newsletter](http://eepurl.com/Ox2I9)!',
    title: '',
    media: null,
  },
]
