export default [
  {
    description:
      'What better way to onboard someone into a new app than to instantly share some of the beautiful creations they’ll be able to make? Hyperlapse nails this part, highlighting the function of the app in a concise and tasteful way.\r\n\r\nMy only negative note here is that the dots at the bottom of the screen (which indicate your current page) are really hard to see. I can imagine some folks getting stuck here waiting for something to happen without realizing they need to swipe left.\r\n\r\nAlso of note: pay attention to the rounded corners of the app, throughout. A very small and subtle touch (that admittedly looks much sharper against the bezel of the iPhone) which adds a tasteful splash of character.',
    title: 'Onboarding',
    media: [
      'https://videodelivery.net/429a554573260dbae4eb94150b5053b1/downloads/default.mp4',
    ],
  },
  {
    description:
      'Blurring and springy physics (as we’ve come to expect from any Facebook-affiliated app) are a common thread that weave their way through the entirety of the Hyperlapse experience. Here, we initiate the app by giving permission to access the camera (which I’ve done prior to this recording).\r\n\r\nNote the responsiveness of the button to my touch, the way the video pauses and blurs, and of course, the way the tutorial tooltip springs into action.',
    title: 'Signing in',
    media: [
      'https://videodelivery.net/353f21748308b5a05c5fdc5140a680dd/downloads/default.mp4',
    ],
  },
  {
    description:
      'I hope a developer/designer at Instagram might chime in here and shed light on this particular detail: when the camera hits a certain field of view, the ring around the record button switches from black to a colorful rainbow. This change is a bit obscure; I’m not sure why the color is changing at all.',
    title: 'Button context',
    media: [
      'https://videodelivery.net/853dc778a5a26782d3ce10f0a46f09d1/downloads/default.mp4',
    ],
  },
  {
    description:
      'I found the ambient light sensor to frequently flash this tooltip, even though I’m clearly pointing at a well-lit environment (in this case, I’m outside in the afternoon). For the sake of this post, however, I’m glad to see this error – the contextual tooltip that shows can serves as a friendly guide to help users get the most value from the app.',
    title: 'Brightness',
    media: [
      'https://videodelivery.net/cf800cf239eb0244be2e441073632db2/downloads/default.mp4',
    ],
  },
  {
    description:
      'Pay attention here to the times at the bottom of the screen. During my first run-through of the app I wasn’t quite sure what was going on down there. As I came to find out, the times represent the original recording time versus the post-processed video length (which defaults to 6x, hence the time change at the 0:06 mark).\r\n\r\nThis is another one of those obscure interaction designs that a user could only possibly know after using the app once or twice. For the first timer, the experience might be confusing.',
    title: 'Length context',
    media: [
      'https://videodelivery.net/c548607b74159a99b3a838c26057f9a0/downloads/default.mp4',
    ],
  },
  {
    description:
      'My apologies if these recordings make you dizzy – I tried my best!\r\n\r\nThis is actually one of my favorite details in Hyperlapse; it’s quite clever indeed. As you change the timelapse speed, a transparent black overlay flashes on the screen with stenciled-out text to show the current multiplier. This is a lovely touch, considering most users’ fingers will be covering the button itself.',
    title: 'Rate changing',
    media: [
      'https://videodelivery.net/24bb2c9abf1242b966cbcaa4c74da005/downloads/default.mp4',
    ],
  },
  {
    description:
      'This is one of those hidden interactions that you might only come across by accident (or in my case, by following [Mike K’s Twitter](https://twitter.com/mikeyk/status/504367692380639232)). Pressing and holding on the video during the review process lets you quickly compare the stabilized vs. unstabilized versions. There’s not much utility here, except to highlight the improvements that Hyperlapse was able to provide.',
    title: 'Unstabilized',
    media: [
      'https://videodelivery.net/1f5644dd618c331e6177a470c2e5bd60/downloads/default.mp4',
    ],
  },
  {
    description:
      'This one is slick, another nice touch from the design team at Instagram: when you delete a hyperlapse, the clip flings away to the top-right, replaced by the soft-blurred background of your previous frame. It’s a smooth, seamless transition from one app view to another, and the motion here brings a certain playfulness to the product.',
    title: 'Deleting',
    media: [
      'https://videodelivery.net/16cedf2e7ba2cf096a08b24b1ff183e5/downloads/default.mp4',
    ],
  },
  {
    description:
      'Once you’ve saved your first hyperlapse, you’ll be greeted with this slick, minimal ‘next-steps’ view. The video here highlights the details of each button press, but it’s also worth paying attention to the way the entire interface plays with your video by blurring the frames in the background.',
    title: 'Save and share',
    media: [
      'https://videodelivery.net/a7bc5f5b4e4ad584dc5f93193d4019b0/downloads/default.mp4',
    ],
  },
  {
    description:
      'Tap and hold anywhere on the screen in the record view to lock your focus on a particular spot.',
    title: 'Lock focus',
    media: [
      'https://videodelivery.net/b72eb8b8ba9c73079d435a2323cfd2cd/downloads/default.mp4',
    ],
  },
  {
    description:
      'My last detail here shows the process of saving a hyperlapse for future editing. Hyperlapse does a wonderful job of using motion, color and the now-familiar image blurring to bring life and energy to this flow.',
    title: 'Save and edit',
    media: [
      'https://videodelivery.net/1428f73d71ffe126bc9532b6aa0d160c/downloads/default.mp4',
    ],
  },
]
