export default [
  {
    description:
      'The pull-to-refresh interaction has become a universally-known gesture for smartphone users. Being so universal provides a hidden challenge for app designers: how do we stand out? Foursquare has embodied a clear simplicity in this detail – a pulsating ring, honing in on your location.\r\n\r\nI love how smooth this detail is – the way the ring fills and expands as you pull down, springing to life once released.',
    title: 'Pull to refresh',
    media: [
      'https://videodelivery.net/88e1775511fab5fd82a6da3e05814e5e/downloads/default.mp4',
    ],
  },
  {
    description:
      'In previous versions of Foursquare, users needed to request permission to follow someone else. The nature of checking in and broadcasting your location necessitated a higher level of privacy for its users. With Foursquare’s latest shift, the emphasis is no longer on check-ins, but on recommendations. For this reason, following someone else no longer requires permission and is a low-barrier action that Foursquare hopes people will find useful.\r\n\r\nThis detail is small, but worth noting: when following someone (or…something perhaps), the transition of the checkmark element is quite slick. It’s certainly not a deal breaker, but I wish that there was an equal level of polish whenever I stopped following someone, rather than having such an instant, static state change.',
    title: 'Following',
    media: [
      'https://videodelivery.net/2c5b8ddaea85e07deb4256e4012715e7/downloads/default.mp4',
    ],
  },
  {
    description:
      'Small and subtle – notice the way the tags bounce in place as they’re selected.',
    title: 'Adding tastes',
    media: [
      'https://videodelivery.net/7a0e6ca135f4fc04ba81a9170a5a167e/downloads/default.mp4',
    ],
  },
  {
    description:
      'I’m a big fan of responsive interactions – when things behave as though they’re actually being touched. That’s wonderful. Foursquare is halfway there with their like button interaction. I love the way it springs to life when tapped. How could this be better? Go the full mile and put the same attention to detail when un-liking something.',
    title: 'Likes',
    media: [
      'https://videodelivery.net/09d17666101af753fc0fc36d764537f5/downloads/default.mp4',
    ],
  },
  {
    description:
      'If a user saves a place in Foursquare, what happens? Show, don’t tell.\r\n\r\nAt least, that’s the strategy the designers at Foursquare have chosen. Saving a place triggers this playful animation, bouncing the bookmark towards my Profile tab, using motion to subtly guide me through the app.',
    title: 'Saving places',
    media: [
      'https://videodelivery.net/2d1d42d9f5984967cf20622616dc0c9c/downloads/default.mp4',
    ],
  },
  {
    description:
      'Foursquare wants to know everything about the places it recommends. Crowdsourcing this data certainly makes their lives easier. I wanted to showcase this flow where users can fill in missing information about a specific restaurant – the view has a drastically different design and feel from the rest of the app. While I’m sure this was intentional, to a degree, it feels innocently out of place.',
    title: 'Rating a place',
    media: [
      'https://videodelivery.net/36b4f2c94f2a206dd0c630270ca09108/downloads/default.mp4',
    ],
  },
  {
    description:
      'After you’ve rated a place, Foursquare gently tries to guide you on your way back to the main app, or onwards to more ratings. The view here feels a bit static and rushed, not quite explaining why I should keep rating places or what those ratings even mean. I appreciate the detail here, but I’ll be anxious to see how Foursquare’s team develops and optimizes this flow over time.',
    title: 'Done rating',
    media: [
      'https://videodelivery.net/ec192ad170bddaebc486890d94d7ab11/downloads/default.mp4',
    ],
  },
  {
    description:
      'This detail is so close to being right! When scrolling up on a place, the title and meta information slowly fade out to reveal a static title bar. The only thing that feels off here is the way the top and bottom black gradients overlap mid-way through the transition.',
    title: 'Scrolling',
    media: [
      'https://videodelivery.net/f0158739106ad7b87d5a2b0c7f51738f/downloads/default.mp4',
    ],
  },
  {
    description:
      'This is probably one of the smoothest parts of the app, and someone clearly put a lot of time and attention into this view. When you’re logged out of the app (but the app recognizes a previous login), you have the option to continue or switch accounts. If you switch accounts, the view slides gracefully off the page. It’s a beautiful mixture of scaling, opacity and easing that make this feel wonderful to touch.',
    title: 'Changing accounts',
    media: [
      'https://videodelivery.net/58af5e641df3e355a7e9273becb6dca2/downloads/default.mp4',
    ],
  },
  {
    description:
      'When first logging in, I was happy to see the way a few elements bounced into place. The use of motion here guides a user’s eyes towards an intended action – in this case, picking a particular mood or desire (e.g. lunch). The rest of the app elements came into view quite suddenly, which feels jarring compared to the sliding list pictured here.',
    title: 'Logging in',
    media: [
      'https://videodelivery.net/0b802d6cf2cf91fb55e83a7b5d391b6d/downloads/default.mp4',
    ],
  },
  {
    description:
      'This might just be the best design detail of them all, on [Foursquare’s website](https://foursquare.com/download) no less. Visitors are greeted with the older, familiar Foursquare branding. It quickly disappears behind a wall of blue tiles as we’re introduced to the new Foursquare. Slick.',
    title: "Foursquare's website",
    media: [
      'https://videodelivery.net/770db5eb2d811c58c23e824dc60587eb/downloads/default.mp4',
    ],
  },
]
