const { css, StyleSheet } = require('aphrodite/no-important')
const React = require('react')
const iconStyles = require('./styles')

module.exports = ({ styles }) => {
  return <svg
    className={css(
      iconStyles.icon,
      iconStyles.icon_customDrawn,
      braveIconStyles.icon,
      styles
    )} xmlns='http://www.w3.org/2000/svg' width='11' height='14' viewBox='0 0 11 14'
  >
    <path className={css(iconStyles.icon__path_solid)} d='M10.7554655 4.92754302l-.3859837-1.05379668.2695759-.61267248c.0340615-.0781451.0170725-.16915769-.0428871-.22975218l-.73520697-.73827034c-.31955783-.32279888-.79545966-.43463581-1.22534497-.28795607l-.21137201.0735207L7.30305601.853271H5.40070794L3.47078962.86858781 2.34959898 2.07861597l-.20524529-.05514053c-.42992234-.14591826-.90541481-.03417753-1.22534496.28795607l-.75971388.75665052c-.0480751.04844861-.06145865.12144973-.033697.18380174l.28182935.6279893L.02144354 4.9367331l.25119572.94964235 1.13957082 4.33159446c.13367604.49543533.43591737.92875619.85467811 1.22534499 0 0 1.38463981.9741492 2.75702618 1.8625243.2226726.1759581.53704128.1759581.75971388 0 1.53168121-1.0047828 2.75702617-1.8655877 2.75702617-1.8655877.41743035-.2972817.71849457-.73046765.85161476-1.22534495l1.13344412-4.33465782.2297522-.95270571z' />
    <path className={css(braveIconStyles.icon__facePath)} d='M5.70398082 8.66178181a1.62664468 1.62664468 0 0 0-.22362545-.08271079h-.13478795a1.6266448 1.6266448 0 0 0-.22362546.08271079l-.34309659.15623148c-.10721768.04595044-.28182934.12559786-.3829203.18073838l-.61267248.32471642c-.04452056.01855023-.0735207.06205045-.0735207.11028105 0 .04823059.02900014.09173081.0735207.11028104l.5054548.36760349c.09496423.06739398.24506899.18380175.3339065.26038581l.15316812.13172458.30633624.27876598.14397804.12866122c.08992431.07055547.21641193.07055547.30633624 0l.15316812-.13172458.30633624-.27876598.15316812-.13478795c.08883751-.07658406.23894227-.19605519.33390651-.26344916l.54221514-.38904703c.04348046-.02145054.06968565-.06705163.06632681-.11541891-.00335884-.04836728-.03561558-.08990851-.08164362-.10514319l-.61267248-.30633624c-.10415432-.05207716-.27876598-.13172458-.38598367-.17767502l-.30327288-.14704139z'
      />
    <path className={css(braveIconStyles.icon__facePath)} d='M9.55156402 5.16342192l.01838018-.05514052a1.48573267 1.48573267 0 0 0 0-.22668882 1.90541166 1.90541166 0 0 0-.20218192-.37985694l-.35228668-.51770825c-.06433061-.0980276-.17767502-.25119572-.25119572-.34309659l-.49320135-.59122895a1.65421751 1.65421751 0 0 0-.14091467-.16542157l-.20830864.03982372-.72295354.14091467-.30633624.06126724c-.1040987.00418575-.20804699-.0114065-.30633624-.04595043l-.57284877-.18380175c-.11028105-.03676035-.30633624-.08577414-.4074272-.11334441a.86999533.86999533 0 0 0-.18073839 0 .86999523.86999523 0 0 0-.18073838 0c-.11334441.02757027-.30633624.07658406-.4074272.11334441l-.56978541.18380175c-.09828925.03454393-.20223754.05013618-.30633624.04595043l-.30633624-.06126724-.75665052-.13785131-.20830865-.03982371a1.65421526 1.65421526 0 0 0-.14091467.16542157l-.48401126.59429231c-.0735207.09190087-.18686511.24506899-.25119572.34309659l-.34922331.51770825a2.7754042 2.7754042 0 0 0-.16542157.27876598 1.26516803 1.26516803 0 0 0-.0490138.32777977l.01838017.05514053a.83935988.83935988 0 0 0 .03369699.10721768c.0735207.09190088.19911856.23587891.27876598.30633624l1.22534497 1.31418248c.08223834.09658151.10675601.22967744.06433061.34922332l-.20218192.47788454c-.04364723.12810893-.04364723.26706481 0 .39517375l.03982371.11028104c.06663233.18115913.18093448.34097048.33084314.46256773l.19299183.15929485c.10302188.07489062.23746879.09111697.35535004.04288707l.70151-.31552633a1.75530678 1.75530678 0 0 0 .34922331-.23281554l.5544686-.49932808c.0824766-.08545786.0824766-.22087838 0-.30633624L3.94254743 6.6736596c-.09780418-.06909994-.13036425-.19934021-.07658406-.30633625l.48401126-.91900872c.05595623-.11242747.06477644-.24252552.0245069-.36147677-.06048982-.11206656-.15790545-.19974062-.27570261-.24813235l-1.5163644-.55140524c-.11028105-.03982371-.10415432-.08271078 0-.09496423l.89143846-.08577415a1.37544963 1.37544963 0 0 1 .41661729.03676035l.77503069.21749873c.11389616.03514283.18447324.14885036.16542157.26651253l-.30633624 1.66340579a.86080495.86080495 0 0 0 0 .28182935c0 .03982371.11640777.09190087.22975218.11640777l.47175782.10109096c.13672238.02494991.27683154.02494991.41355392 0l.42580738-.09496424c.11334441-.0245069.21749873-.07964742.22975218-.11947113a.86080473.86080473 0 0 0-.01531681-.28182934l-.30633624-1.6634058c-.01905167-.11766217.05152541-.2313697.16542157-.26651253l.77503069-.21749873a1.3723862 1.3723862 0 0 1 .41661729-.03676035l.89143846.08271079c.11640777 0 .1225345.05514052 0 .09496423l-1.5163644.57591214c-.11779716.04839173-.21521279.13606579-.27570261.24813235-.04026954.11895125-.03144933.2490493.0245069.36147677l.48401126.91900872c.05378019.10699604.02122013.23723631-.07658406.30633625l-1.24678851.84242466c-.0824766.08545786-.0824766.22087838 0 .30633624l.5544686.49932808a1.75530657 1.75530657 0 0 0 .34922332.23281554l.68925654.32777978c.11788125.0482299.25232816.03200355.35535004-.04288707l.19299183-.15929485c.14878416-.12198676.26200219-.28176175.32777978-.46256773l.03982371-.11028104c.04364723-.12810894.04364723-.26706482 0-.39517375l-.20218191-.47788454c-.04325836-.11900922-.0199185-.2520464.06126724-.34922332l1.22534497-1.31418248c.07964742-.08577414.20524528-.22975218.27876598-.30633624a.83936057.83936057 0 0 0 .06433061-.12559786z'
      />
  </svg>
}

const braveIconStyles = StyleSheet.create({
  icon: {
    padding: '16%'
  },

  icon__facePath: {
    stroke: 'none',
    fill: 'var(--brave-logo-fill-color, white)'
  }
})
