# Test plan

## [0.11.6](https://github.com/brave/browser-laptop/releases/v0.11.6dev)

### Autofill

 - [ ]  Alignment and padding of title on add autofill data popups should match clear browsing data([#3360](https://github.com/brave/browser-laptop/issues/3360))
 - [ ]  Make autofill popup similar to clear browsing data([#3369](https://github.com/brave/browser-laptop/issues/3369))
 - [ ]  Tweaks to fix autofill context menu position ([#3389](https://github.com/brave/browser-laptop/issues/3389))
 - [ ]  Form autofill popup should appear under the focused field ([#3359](https://github.com/brave/browser-laptop/issues/3359))
 - [ ]  Add Autofill support ([#3241](https://github.com/brave/browser-laptop/issues/3241))
 - [ ]  Form fill (Autofill) enhancement ([#860](https://github.com/brave/browser-laptop/issues/860))
 - [ ]  Autofill should not happen on URL bar unless item in autocomplete list is clicked ([#3012](https://github.com/brave/browser-laptop/issues/3012))([#3225](https://github.com/brave/browser-laptop/issues/3225))
 - [ ]  Editing Autofill entries are not saved. Creates a blank entry([#3368](https://github.com/brave/browser-laptop/issues/3368))
 - [ ]  Brave crashes with segmentation fault when submitting a form ([#3398](https://github.com/brave/browser-laptop/issues/3398))
 - [ ]  Autofill - Add new entry buttons are not functional ([#3455](https://github.com/brave/browser-laptop/issues/3455))
 - [ ]  Autofill - Values are vacated ([#3491](https://github.com/brave/browser-laptop/issues/3491))


### Bookmarks

 - [ ]  Bookmark title is not updated unbookmarking/rebookmarking bug verified ([#3284](https://github.com/brave/browser-laptop/issues/3284))
 - [ ]  Adding bookmark will now properly update title + rendering fix ([#3339](https://github.com/brave/browser-laptop/issues/3339))
 - [ ]  bookmark title (onhover) on bookmark bar cannot be updated ([#3080](https://github.com/brave/browser-laptop/issues/3080))
 - [ ]  On clean install, adding a bookmark via the tabs tray does not open the bookmark tray. ([#3331](https://github.com/brave/browser-laptop/issues/3331))
 - [ ]  Fix bookmark toolbar not showing on first bookmark from context menu ([#3355](https://github.com/brave/browser-laptop/issues/3355))
 - [ ]  Bookmarked page cannot be removed from context menu ([#3332](https://github.com/brave/browser-laptop/issues/3332))
 - [ ]  If a site does not have a title, the bookmark should default to the url instead. ([#3344](https://github.com/brave/browser-laptop/issues/3344))
 - [ ]  Bookmarks Menu should list the bookmarks like other browsers do ([#1993](https://github.com/brave/browser-laptop/issues/1993))
 - [ ]  "auto open bookmarks toolbar for the first bookmark" test needs to be updated ([#2941](https://github.com/brave/browser-laptop/issues/2941))
 - [ ]  Bookmarks now show under Bookmarks menu ([#3055](https://github.com/brave/browser-laptop/issues/3055))
 - [ ]  Users can create bookmark folders with no name ([#3188](https://github.com/brave/browser-laptop/issues/3188))([#3190](https://github.com/brave/browser-laptop/issues/3190))
 - [ ]  Bookmark folder names should contain visible text ([#3347](https://github.com/brave/browser-laptop/issues/3347))([#3412](https://github.com/brave/browser-laptop/issues/3412))
 - [ ]  If a site does not have a title, the bookmark should default to the url instead. ([#3442](https://github.com/brave/browser-laptop/issues/3442))
 - [ ]  Bookmark folder cannot be deleted from dialog bug  ([#3409](https://github.com/brave/browser-laptop/issues/3409))

### History

 - [ ]  about:history contains bookmark items as browsing history which can't be cleared ([#3330](https://github.com/brave/browser-laptop/issues/3330))
 - [ ]  Bookmarked history entries now show context menu in about:history ([#3336](https://github.com/brave/browser-laptop/issues/3336))
 - [ ]  Ctrl + Y is not opening history ([#3312](https://github.com/brave/browser-laptop/issues/3312))
 - [ ]  Updates to history page: ([#3320](https://github.com/brave/browser-laptop/issues/3320))
 - [ ]  History follow up ([#3253](https://github.com/brave/browser-laptop/issues/3253))
 - [ ]  Back button history does not hint at options beyond a certain point.  ([#2889](https://github.com/brave/browser-laptop/issues/2889))
 - [ ]  Implement history and Ctrl +Y to bring it up ([#444](https://github.com/brave/browser-laptop/issues/444))
 - [ ]  Adds about:history, sets back/forward nav limit, more efficient dynamic menus ([#3206](https://github.com/brave/browser-laptop/issues/3206))
 - [ ]  History bugfixes  ([#3459](https://github.com/brave/browser-laptop/issues/3459))
 - [ ]  Bookmarked about pages appear in the history ([#3366](https://github.com/brave/browser-laptop/issues/3366))
 - [ ]  Bookmark folders are appearing in browser history ([#3453](https://github.com/brave/browser-laptop/issues/3453))
 - [ ]  Fixes extra separator in about:history context menu  ([#3444](https://github.com/brave/browser-laptop/issues/3444))
 - [ ]  Clearing history using modal now clears bookmark timestamps ([#3501](https://github.com/brave/browser-laptop/issues/3501))
 - [ ]  Clear browser history should work regardless of whether or not the page is bookmarked. bug  ([#3346](https://github.com/brave/browser-laptop/issues/3346))

### Ledger

 - [ ]  Ledger beta integration  ([#3195](https://github.com/brave/browser-laptop/issues/3195))
 - [ ]  Preferences : Payments : Add Funds modal alignment appears to be off for Brave wallet address ([#3378](https://github.com/brave/browser-laptop/issues/3378))
 - [ ]  Preferences : Payments : Add Funds - Transfer BTC link goes to jsfiddle ([#3380](https://github.com/brave/browser-laptop/issues/3380))
 - [ ]  Preferences : Payments : Add Funds modal is misaligned ([#3267](https://github.com/brave/browser-laptop/issues/3267))
 - [ ]  Preferences : Payments : monthly budget dropdown is missing units ([#3266](https://github.com/brave/browser-laptop/issues/3266))
 - [ ]  Duping texts on ledger welcome page in other languages than English ([#3379](https://github.com/brave/browser-laptop/issues/3379))
 - [ ]  Cannot create wallet in packaged builds bug ledger integration ([#3308](https://github.com/brave/browser-laptop/issues/3308))
 - [ ]  Left align elements on main ledger screen([#3395](https://github.com/brave/browser-laptop/issues/3395))([#3396](https://github.com/brave/browser-laptop/issues/3396))
 - [ ]  Monthly budget in payments misaligned ([#3476](https://github.com/brave/browser-laptop/issues/3476))
 - [ ]  update UX to include transaction history ([#2994](https://github.com/brave/browser-laptop/issues/2994))([#3473](https://github.com/brave/browser-laptop/issues/3473))
 - [ ]  Existing bitcoin wallet address is not displayed ledger ([#3440](https://github.com/brave/browser-laptop/issues/3440))
 - [ ]  updateLedgerInfo should run before client is assigned if previous state is present  ([#3470](https://github.com/brave/browser-laptop/issues/3470))
 - [ ]  update ledger welcome page with adjusted UI layout and partner logos ([#3353](https://github.com/brave/browser-laptop/issues/3353))
 - [ ]  Ledger logging happens frequently and unrequested on Linux terminal. ([#3452](https://github.com/brave/browser-laptop/issues/3452))
 - [ ]  use environment variables to control ledger-* package options ([#3462](https://github.com/brave/browser-laptop/issues/3462))
 - [ ]  Preferences : Payments : Create wallet control text and status flickers when disabling then enabling brave payments. ([#3376](https://github.com/brave/browser-laptop/issues/3376))
 - [ ]  Browser crashes when trying to signup on Coinbase bug ([#3382](https://github.com/brave/browser-laptop/issues/3382))
 - [ ]  Windows size grew ~26MB with ledger ([#3475](https://github.com/brave/browser-laptop/issues/3475))
 - [ ]  Ledger unconfirmed balance fix ([#3495](https://github.com/brave/browser-laptop/issues/3495))
 - [ ]  Ledger unconfirmed balance takes a long time to show up  ([#3480](https://github.com/brave/browser-laptop/issues/3480))
 - [ ]  a few minor things ([#3554](https://github.com/brave/browser-laptop/issues/3554))
 - [ ]  support new Set(...) in ledger publisher ruleset ([#3553](https://github.com/brave/browser-laptop/issues/3553))
 - [ ]  support new Set(...) in ledger publisher ruleset ([#3545](https://github.com/brave/browser-laptop/issues/3545))
 - [ ]  Ledger settings box alignment and style corrections ([#3523](https://github.com/brave/browser-laptop/issues/3523))
 - [ ]  increase back-off when recovering from ledger-client errors ([#3573](https://github.com/brave/browser-laptop/issues/3573))
 - [ ]  set ledger columns to right-align if appropriate ([#3567](https://github.com/brave/browser-laptop/issues/3567))
 - [ ]  Preferences : Payments : Text clipping for localized strings. ([#3539](https://github.com/brave/browser-laptop/issues/3539))
 - [ ]  Stop partner logos from floating below brave payments text ([#3551](https://github.com/brave/browser-laptop/issues/3551))
 - [ ]  set flags to hide CB button in Add funds… dialog when users chooses 10, 15,or 20 monthly value ([#3565](https://github.com/brave/browser-laptop/issues/3565))

### Fixes

 - [ ]  Escaping from fullscreen video leaves the browser in fullscreen mode instead of returning to windowed mode. ([#3338](https://github.com/brave/browser-laptop/issues/3338))
 - [ ]  Add '.jpg' extension to webpack file-loader ([#3309](https://github.com/brave/browser-laptop/issues/3309))
 - [ ]  Handle non-script version of DDG when blocked at filtering level ([#3293](https://github.com/brave/browser-laptop/issues/3293))
 - [ ]  Non-script version of DuckDuckGo when blocking scripts is not loaded from context menu ([#3285](https://github.com/brave/browser-laptop/issues/3285))
 - [ ]  Brave can't handle URLs with whitespace in it ([#3167](https://github.com/brave/browser-laptop/issues/3167))
 - [ ]  Whitespace in url fixes #3167 ([#3168](https://github.com/brave/browser-laptop/issues/3168))
 - [ ]  Flash on http://www.y8.com/games/superfighters does not work ([#3028](https://github.com/brave/browser-laptop/issues/3082))
 - [ ]  Handle mergeable entry after adding([#3373](https://github.com/brave/browser-laptop/issues/3373))
 - [ ]  Clear Browsing Data button on about:preferences not working ([#3335](https://github.com/brave/browser-laptop/issues/3335))
 - [ ]  0.11.6-beta3 always wants to report a crash -- when normally exiting -- on macOS([#3394](https://github.com/brave/browser-laptop/issues/3394))
 - [ ]  location.reload() does not reload the page title ([#2798](https://github.com/brave/browser-laptop/issues/2798))
 - [ ]  Add new tab button mouseover effect not working ([#3297](https://github.com/brave/browser-laptop/issues/3297))
 - [ ]  Filesystem API cookie not blocked ([#3286](https://github.com/brave/browser-laptop/issues/3286))
 - [ ]  Make bookmark and history management look nicer ([#441](https://github.com/brave/browser-laptop/issues/441))
 - [ ]  Clear "Recently Closed" when clearing history ([#3287](https://github.com/brave/browser-laptop/issues/3287))
 - [ ]  Shields down shows shows gray block on shield items. ([#3307](https://github.com/brave/browser-laptop/issues/3307))
 - [ ]  Cannot quit from hamburger menu. ([#3310](https://github.com/brave/browser-laptop/issues/3310))
 - [ ]  3rd party storage is not fully blocked ([#3214](https://github.com/brave/browser-laptop/issues/3214))
 - [ ]  Fixed : Address bar input ignored if no default search engine set ([#3254](https://github.com/brave/browser-laptop/issues/3254))([#3275](https://github.com/brave/browser-laptop/issues/3275))
 - [ ]  Reordered Hamburger Menu with layout mentioned in #1893 ([#3003](https://github.com/brave/browser-laptop/issues/3003))
 - [ ]  New tab button too high ([#3208](https://github.com/brave/browser-laptop/issues/3208))([#3213](https://github.com/brave/browser-laptop/issues/3213))
 - [ ]  After Back/Forward navigation, tab shows page URL instead of page title ([#3200](https://github.com/brave/browser-laptop/issues/3200))([#3202](https://github.com/brave/browser-laptop/issues/3202))
 - [ ]  Unit Test : "Pinning with partitions" test is failing but the functionality works ([#2942](https://github.com/brave/browser-laptop/issues/2942))
 - [ ]  Application icon is with poor resolution on Linux ([#3229](https://github.com/brave/browser-laptop/issues/3229))([#3230](https://github.com/brave/browser-laptop/issues/3230))
 - [ ]  Adblock files should download once, not repeatedly ([#3222](https://github.com/brave/browser-laptop/issues/3222))
 - [ ]  Update to https everywhere 5.2.0 ([#2581](https://github.com/brave/browser-laptop/issues/2581))
 - [ ]  Temporarily remove insertions ([#3211](https://github.com/brave/browser-laptop/issues/3211))
 - [ ]  HTTPS-E Improvement: Make targets.host UNIQUE, which auto-creates index ([#3215](https://github.com/brave/browser-laptop/issues/3215))
 - [ ]  Non-script version of DuckDuckGo when blocking scripts is not loaded from location bar at first instance ([#3189](https://github.com/brave/browser-laptop/issues/3189))([#3205](https://github.com/brave/browser-laptop/issues/3205))
 - [ ]  Market graph on wsj.com ([#2102](https://github.com/brave/browser-laptop/issues/2102))
 - [ ]  Tab-specific notifications should be closed when tab is closed ([#3169](https://github.com/brave/browser-laptop/issues/3169))
 - [ ]  Menu items should work immediately after launch ([#3022](https://github.com/brave/browser-laptop/issues/3022))
 - [ ]  Update localization files([#3414](https://github.com/brave/browser-laptop/issues/3414))
 - [ ]  route safebrowsing and httpse messages by tabId ([#3411](https://github.com/brave/browser-laptop/issues/3411))
 - [ ]  Warning message is not displayed when trying to open excellentmovies.net from URL bar ([#3367](https://github.com/brave/browser-laptop/issues/3367))
 - [ ]  Update test fails bug Major tests ([#3337](https://github.com/brave/browser-laptop/issues/3337))
 - [ ]  Retrieve status code from response object in metadata request ([#3407](https://github.com/brave/browser-laptop/issues/3407))
 - [ ]  Add themeColor data to sites ([#3406](https://github.com/brave/browser-laptop/issues/3406))
 - [ ]  fixed typo ([#3405](https://github.com/brave/browser-laptop/issues/3405))
 - [ ]  don't send unnecessary ipc messages ([#3393](https://github.com/brave/browser-laptop/issues/3393))
 - [ ]  Update test fails bug Major tests ([#3337](https://github.com/brave/browser-laptop/issues/3337))
 - [ ]  use different file name for development version ([#3472](https://github.com/brave/browser-laptop/issues/3472))
 - [ ]  redirect to basic auth hangs forever ([#3354](https://github.com/brave/browser-laptop/issues/3354))
 - [ ]  Improved UI/UX of find bar ([#3315](https://github.com/brave/browser-laptop/issues/3315))
 - [ ]  Open file action tries to search for the file in the default search engine ([#3296](https://github.com/brave/browser-laptop/issues/3296))
 - [ ]  Esc handler changes windowed / fullscreen mode depending on permissions ([#3464](https://github.com/brave/browser-laptop/issues/3464))
 - [ ]  Cannot delete saved passwords on about:passwords  ([#3481](https://github.com/brave/browser-laptop/issues/3481))
 - [ ]  Chrome.ipc.on is not working ([#3487](https://github.com/brave/browser-laptop/issues/3487))
 - [ ]  Fix deleting text going back fixes #3496  ([#3497](https://github.com/brave/browser-laptop/issues/3497))
 - [ ]  Remove placeholder ads by default ([#3506](https://github.com/brave/browser-laptop/issues/3506))
 - [ ]  Add cibuild script ([#3507](https://github.com/brave/browser-laptop/issues/3507))
 - [ ]  autocomplete db initialization fails on fresh profile ([#3577](https://github.com/brave/browser-laptop/issues/3577))
 - [ ]  username and password field for basic auth dialog are not showing up ([#3578](https://github.com/brave/browser-laptop/issues/3578))
 - [ ]  Modals are uncentered which leads to clipping when the window is narrow. ([#3575](https://github.com/brave/browser-laptop/issues/3575))
 - [ ]  overflowIndicator not appearing on bookmark toolbar if show only favicon option is enabled ([#3525](https://github.com/brave/browser-laptop/issues/3525))
 - [ ]  "Show only favicon" option should include folders on bookmark bar ([#3529](https://github.com/brave/browser-laptop/issues/3529))
 - [ ]  Fix cropped/narrow buttons in prefs panels via CSS ([#3507](https://github.com/brave/browser-laptop/issues/3563))
 - [ ]  After upgrade, context menu for password manager does not show ([#3549](https://github.com/brave/browser-laptop/issues/3549))
 - [ ]  check for valid data before upgrading and assign defaults after cleaning ([#3537](https://github.com/brave/browser-laptop/issues/3537))
 - [ ]  upgrade to 0.11.6 fails ([#3550](https://github.com/brave/browser-laptop/issues/3550))
 - [ ]  Tab close is causing fullscreen to be exited ([#3519](https://github.com/brave/browser-laptop/issues/3519))
 - [ ]  Building on Windows requires tedious work-arounds ([#3548](https://github.com/brave/browser-laptop/issues/3548))
 - [ ]  Passwords are not saved using default settings ([#3516](https://github.com/brave/browser-laptop/issues/3516))
 - [ ]  Flash on http://www.y8.com/games/superfighters does not work ([#3082](https://github.com/brave/browser-laptop/issues/3082))
 - [ ]  Update test fails ([#3337](https://github.com/brave/browser-laptop/issues/3337))
