# AI-101 🚀

Lecture notes, readings, code samples and resources for teaching yourself how PyTorch and Tensorflow.

This class was formerly taught as a bootcamp but is now a self-paced online resource.

# More Like This ⭐

See Brad's [GitHub Stars](https://github.com/predbrad?submit=Search&q=learn&tab=stars&type=&sort=&direction=&submit=Search) for a curated collection of helpful resources.

# Course Outline 📝

| Session   | Topic | TODO |
|-----------|---------| ---------|
| Preparation | N/A | See [preparation.md](./preparation.md) |
| 📅 Week 1 | 📚 [Roles, Machine Learning Basics, Tech Stack](./30000.md)| [How Deep Learning Works](https://www.youtube.com/watch?v=wBgW3ZtlPT8) and [Intro to Free Software](https://www.fsf.org/blogs/rms/20140407-geneva-tedx-talk-free-software-free-society) |
| 📅 Week 1 | 🎬 ["Foundations" Live Demos](./foundations.md) | [SuperDataScience Code Interpreter Guide](https://youtu.be/ac6580tuveo?si=dUlyNu1CzFkhDPek) |
| 📅 Week 2 | 💡 [Final Project Ideas](#-final-project-sequence-) | Pick a project! |
| 📅 Week 2 | 📊 [The Universal ML Workflow](https://livebook.manning.com/book/deep-learning-with-python-second-edition/chapter-6) | [The Universal ML Workflow](https://towardsdatascience.com/applying-the-universal-machine-learning-workflow-to-the-uci-mushroom-dataset-1939442d44e7) and [The Regression Theory of Everything](./AI_harmony_c3.pdf) |
| 📅 Week 3 | 👥 Pair Programming, Project Q&A | work on your project |
| 📅 Week 3 | 📝 [Data Engineering, ETL Basics](./etl.md) and [Data Wrangling Techniques](./wranglin.md) | work on your project |
| 📅 Week 4 | 📊  OpenRouter [Sommelier App](https://github.com/Medusa-ML/LLMmMm) in AWS, Azure and GCP Cloud Setup Demo | Setup [AWS Free Tier](https://aws.amazon.com/free/) |
| 📅 Week 5 | 🧠 [Metrics and Loss Functions, Model Architecture and Hyperparameters](./architecture.md) | [60 Minute Pytorch Blitz](https://pytorch.org/tutorials/beginner/deep_learning_60min_blitz.html) |
| 📅 Week 7 | 🎓 [After The Bootcamp...](./after_bootcamp.md) | go forth and win! |
| 📅 Weeks 7-8 | 🎉 [Project Presentations](https://www.youtube.com/@bradflaugher2452/videos)  | brag about yourself online |

---

# 🚀 **Final Project Sequence** 🚀

Participants will dedicate substantial time to final projects aligned with their ✨career aspirations✨. For an array of past presentations and source code, 📺 visit [Brad's Youtube Channel](https://www.youtube.com/@bradflaugher2452/videos).

| **Step**                                | **Details**                                                                                                                                                                                                                     |
|-----------------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **🅰️ Data Collection and Simple Model** | Generate synthetic text data using [Scikit-LLM](https://github.com/iryna-kondr/scikit-llm). Explore datasets on [Kaggle](https://www.kaggle.com/datasets) or [Hugging Face](https://huggingface.co/datasets). |
| **🅱️ Custom Model (Optional)**         | **Beginner:** Follow [TensorFlow quickstart](https://www.tensorflow.org/tutorials) for basic image/text classifiers. **Recommended:** Dive into [60 Minute PyTorch Blitz](https://pytorch.org/tutorials/beginner/deep_learning_60min_blitz.html), then explore 📜 [PyTorch Text Classification](https://pytorch.org/tutorials/beginner/text_sentiment_ngrams_tutorial.html) or [PyTorch Image Classification](https://pytorch.org/tutorials/beginner/blitz/cifar10_tutorial.html). **More Advanced:** Fine-tune pretrained models with [Hugging Face](https://huggingface.co/docs/transformers/training) for 📝 text or 📸 image classification. **Apple Nerds Only** Use [MLX](https://github.com/ml-explore/mlx). |
| **⭐ Challenge and Experiment (Optional)**| **Advanced:** Explore cross-platform frameworks like [Keras Core](https://keras.io/keras_core/guides/). 🏆 **Very Advanced:** Attempt to [Replicate a Winning Model from Kaggle](https://www.kaggle.com/code?types=competitions).                                                                                     |


---
