# Intro - The 30,000 foot view of Data and AI 🛰️

---

# AI Tutors and CS50 Approach
* Modified CS50 methodology
* [Explore CS50 approach (PDF)](./cs50.pdf)
* [Watch a brief video (7 min)](https://youtu.be/MYnoZP9ZggI?si=bBZUEKZ7bRNzg7jJ)

---

# Who's Who in Data?
* Data Scientist 📊
* Data Engineer 🛠️
* Data Analyst 📈
* Data Janitor 🧹

---

# Unveiling ML and AI 🧠💡
* Machine Learning - Teaching computers from data
* Artificial Intelligence - Machines with human-like cognition
* Neural Networks' role
* [Simple Neural Network Exercise](./simple_nn.xlsx)

---

# Foundation Models 🌐
* ImageNet - Visual Recognition
* BERT - NLP Breakthrough
* LLaMA and Stable Diffusion - Latest advancements

---

# Embracing Hacker Culture 🎨
* Unlimited access to computing resources 🌐💻
* Information freedom 🔓
* Authority mistrust, promote decentralization 🚫⚖️
* Judgment based on hacking skills, not titles 🔍
* [For Fun and Profit](https://www.penguinrandomhouse.com/books/657764/for-fun-and-profit-by-christopher-tozzi-foreword-by-jonathan-zittrain/)

---

# To Buy or To Build? 🛠️
* ![Deciding on tools](./buy_vs_build.png)
* Our *Freedom* & [*Popularity* Stack](https://survey.stackoverflow.co/2023/#technology-admired-and-desired)

---

# Tech Stack 🖥️🔍
* OS: Linux, macOS, Windows (w/ WSL)
* Programming: Python (Matplotlib, seaborn, pandas, numpy)
* ML Libraries: PyTorch, Tensorflow
* Data Storage: SQL* (Agnostic to DB type for now)
* Version Control: Git (and github)
* IDE/Editor: VSCode, Jupyter, [```vim```](https://www.youtube.com/watch?v=rysgxl35EGc)

---

# Training, Testing, and Deployment ☕🚀
* Model Training & Testing: Google Colab
* Multi-Env Testing & Deployment: Docker
* Cloud Services: AWS, Azure, GCP

---

# Why Python? 🐍💨
* [Python vs C Speed Test](./speed_test/)
* Python - The swiss army knife for data professionals

---

# Innovate Smartly 🌟
* [Innovation Horizons 1,2,3](https://www.boardofinnovation.com/blog/what-is-the-3-horizons-model-how-can-you-use-it/)
* Emphasis on starting small, scaling with need

---

# END

