from .commands import Command, Invoker, CommandHistory
from .mediator import GenericMediator, BaseComponent
from .notification import Observer, Subject
from .registry import ObjectRegistry, ObjectRegistryError
from .memoize import ObjectsPool
from .singleton import Singleton
from .transformations import Transformer
from .linear_mapping import MapOnLinearSpace
from .command_factory_interface import CommandFactoryInterface
from .subclass_registry import SubclassRegistry


class CommandFactoryType(SubclassRegistry):
    pass


__all__ = ['Command', 'Invoker', 'CommandHistory', 'GenericMediator', 'BaseComponent', 'Observer', 'Subject',
           'ObjectRegistry', 'ObjectRegistryError', 'ObjectsPool', 'Singleton', 'Transformer', 'MapOnLinearSpace',
           'CommandFactoryInterface', 'CommandFactoryType', 'SubclassRegistry']
