# 聊天简化器

[![discord](https://img.shields.io/badge/chat-on%20discord-7289da.svg?sanitize=true)](https://chat.imzbb.cc)

[English](https://github.com/zhengbangbo/chat-simplifier/blob/main/README.md) | 中文

此项目使用 AI 为您简化聊天内容

[![Chat Simplifier](./public/screenshot_zh.png)](https://chat-simplifier.vercel.app/)

## 它是怎么工作的

该项目使用 [Chat GPT API](https://platform.openai.com/docs/api-reference/chat) (gpt-3.5-turbo)和 [Vercel Edge functions](https://vercel.com/features/edge-functions) 流式传输。它根据表单和用户输入构建 Prompts，通过 Vercel Edge 函数发送到 GPT-3 API，然后将响应流回到应用程序。

## 本地运行

克隆存储库后，前往 [OpenAI](https://beta.openai.com/account/api-keys) 创建帐户，并参考[环境变量说明](#环境变量说明)将 API 密钥放入名为 `.env` 的文件中。

然后，在命令行中运行应用程序，它将在 `http://localhost:3000` 处可用。

> **Note**
> 本地运行时，服务端使用本地网络请求 OpenAI，因此需要配置好网络代理。

```bash
npm run dev
```

## 环境变量说明

| 环境变量 | 说明 |  是否必须 |可选值 |
|---------|------|---|----|
|OPENAI_API_KEY| OpenAI API Key，当有多个时用`,`分隔 | 非必需 |([获取](https://beta.openai.com/account/api-keys)) |
|NEXT_PUBLIC_USE_USER_KEY|是否使用用户自己输入的 API 密钥| 必须，默认为 true |`true` or `false` |
|NEXT_PUBLIC_SECRET|项目的秘密字符串。用于生成 API 调用的签名| 非必需 | `123abc` |

## 一键部署

使用 [Vercel](https://vercel.com?utm_source=github&utm_medium=readme&utm_campaign=vercel-examples) 部署示例：

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https://github.com/zhengbangbo/chat-simplifier&env=OPENAI_API_KEY,NEXT_PUBLIC_USE_USER_KEY&envDescription=%E7%82%B9%E5%87%BB%E5%8F%B3%E4%BE%A7%E3%80%8CLearn%20More%E3%80%8D%E6%9F%A5%E7%9C%8B%E7%8E%AF%E5%A2%83%E5%8F%98%E9%87%8F%E8%AF%B4%E6%98%8E&envLink=https://github.com/zhengbangbo/chat-simplifier/wiki/Deploy&project-name=chat-simplifier&repository-name=chat-simplifier)

## 致谢

灵感来自 [TwtterBio](https://github.com/Nutlope/twitterbio) 和 [Jimmy Lv](https://www.bilibili.com/video/BV17M411i7B6)。
