<h1 align="center">Superstylin Theme 🎉😲</h1>

<p align="center">A <a href="https://github.com/gatsbyjs/gatsby" target="_blank">Gatsby</a> Theme with <a href="https://styled-components.com/" target="_blank">Style 💅</a></p>

## What is Superstylin?
Superstylin' is a [Gatsby Theme](https://www.gatsbyjs.org/docs/themes/) that uses [styled-components](https://styled-components.com/) as the main way to style your Gatsby site, it provides an easy to start structure to get you up and running with your first Gatsby-powered site.

## About styled-components
Simply put, styled-components is a way to add your css in your js, it works by creating a component and style it, then you'll get a styled-component, it's really simple and very powerful.

## Benefits of using styled-components
By using your css in your js you get the power of javascript to add more functionality to the way you declare your styles, but wait, that's not all!

Below are some interesting readings to further discover the benefits of styled-components.

* [Styled-Components: Enforcing Best Practices In Component-Based Systems](https://www.smashingmagazine.com/2017/01/styled-components-enforcing-best-practices-component-based-systems/)
* [The magic behind 💅 styled-components](http://mxstbr.blog/2016/11/styled-components-magic-explained/)

A big thanks to [Glen Maddern](https://twitter.com/glenmaddern) and [Max Stoiber](https://twitter.com/mxstbr) for making [styled-components](https://github.com/styled-components/styled-components) 👏🎉.

Also big thanks to [Kyle Mathews](https://github.com/KyleAMathews) for starting and maintaining [Gatsby](https://github.com/gatsbyjs/gatsby) 👏🎊.

## Inline-styles vs CSS in JS
Read this excellent post on [why inline-styles !== css-in-js](http://mxstbr.blog/2016/11/inline-styles-vs-css-in-js/) by [Max Stoiber](https://github.com/mxstbr).

## Features of Superstylin 💖
* Use css-in-js with the magic of [styled-components](https://github.com/styled-components/styled-components) 💅
* Uses [Gatsby](https://www.gatsbyjs.org) built-in [GraphQL](http://graphql.org) to fetch and sort blog posts
* Easy to customize and to get started with your own Gatsby site
* Perfect for sites, blogs or both
* Super simple project structure to get you up and running fast

## Installing

Inside your starter:

```sh
$ yarn add gatsby-theme-superstylin
```

And finally, add the theme in your `gatsby-config.js`:

```js
module.exports = {
  plugins: ['gatsby-theme-superstylin']
}
```

[See the demo](https://github.com/bntzio/gatsby-theme-superstylin/tree/master/demo) for an example.

## License
Licensed under the MIT License, Copyright © 2018 Enrique Benitez

See [license](https://github.com/bntzio/gatsby-theme-superstylin/blob/master/license) for more information.
