<p align="center">
<img width="266" alt="VerifyWise Logo" src="https://github.com/user-attachments/assets/0bfc50fb-71cc-47e4-97bd-37faa14700fe">
</p>

<h3 align="center">Democratizing AI Governance</a></h3>

[VerifyWise](https://verifywise.ai) is an open-source AI governance platform designed to help businesses harness the power of artificial intelligence safely and responsibly. Our platform ensures compliance and robust AI management without compromising on security.

We are democratizing AI best practices with an open-source solution that can be hosted on-premises, giving you complete control over your AI governance.

<img width="1433" alt="VerifyWise" src="https://github.com/user-attachments/assets/268a2c44-01de-4f7b-8e10-1dd4f76e86a8">

## Running the application

The application has two components: a frontend in Reactjs and backend in Nodejs. Do the following to run 

1. Fork and clone the repository. Go to the Clients directory.
2. Run `npm i; npm run dev`
3. Go to ../Servers directory.
4. Run `npm i; npm run watch`
5. Now the application is up and running on `https://localhost:5173` 

Currently the application is in its infancy state, so check back here often.

## Quick links

- This application is currently in the design stage. The designs and workflows are [available for everyone](https://www.figma.com/design/o4xu4PeC5bo1Ii4dyom6vQ/VerifyWise?node-id=0-1&t=Ty2Jh4S8QgHGrqon-1). This link includes 2 pages: dashboard designs and the style guide.
- The [VerifyWise presentation](https://pitch.com/v/verifywise-democratizing-ai-governance-zhxvh6), including terminology, why we started this project, technology, and roadmap

## Who is it for?

The platform makes AI governance easier for organizations. It helps them manage risks, ensure they follow rules, and promote responsible AI practices throughout their operations.

VerifyWise is designed for:

- **Businesses**: From those considering AI adoption to organizations developing proprietary AI at scale.
- **Compliance officers**: Professionals ensuring compliance to EU AI Act regulations and internal policies.
- **Risk management teams**: Groups tasked with identifying and mitigating AI-related risks.
- **Legal and privacy teams**: Professionals addressing the legal and ethical implications of AI use.
- **AI developers**: Teams working on AI projects who need to ensure compliance and responsible development.

## Why now? 

- **There is an urgent need for regulatory compliance:** Regulations set clear rules for AI applications and create a need for organizations to comply with legal requirements.
- **Complexity of compliance:** Companies will need governance tools that can help them manage a changing regulatory landscape. 
- **Growing concerns for Ethical AI:** There’s a strong push from governments, businesses, and consumers for more ethical and transparent AI systems.
- **Good timing with global AI expansion:** Starting an open source AI governance app now aligns with the AI adoption trend across industries (healthcare, finance etc), leading the need for a quickly deployable governance solution.

## Features

![VerifyWise platform](https://github.com/user-attachments/assets/2d05cd1f-f67b-45d2-aca4-1fdcde287a44)

- Option to host the application on-premises or in a private cloud
- Open source with a permissive license (AGPLv3)
- End-to-end encryption for data in transit and at rest to ensure data security
- Full access to the source code for transparency, security audits, and customization
- Docker deployment
- User registration, authentication and role-based access control (RBAC) support.
- Key metrics, visualizations, and real-time reporting capabilities.
- Major features:
  - Multiple projects
  - Compliance tracker
  - Assessment tracker
  - Vendors
  - Risks
  - AI Trust Center
  - File manager

## Roadmap

![VerifyWise roadmap](https://github.com/user-attachments/assets/b4e0d024-4a8d-4ef8-a5c6-b47b19fc3d37)
