import Checked from "../../assets/icons/check-circle-green.svg";
import Exclamation from "../../assets/icons/alert-circle-orange.svg";

export const FundamentalRightsImpactAssessments = {
  id: 7,
  controls: [
    {
      id: 1,
      icon: Exclamation,
      title: "Fundamental Rights Impact Assessment Process Development",
      description:
        "Conduct assessments to evaluate AI systems' impact on fundamental rights and notify authorities of findings.",
      subControls: [
        {
          id: 1,
          title:
            "We develop a comprehensive process for fundamental rights impact assessments.",
          description:
            "A structured assessment process identifies and mitigates risks to fundamental rights posed by AI systems.",
        },
      ],
      owner: "John Doe",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 2,
      icon: Checked,
      title: "AI System Usage Process Description",
      description:
        "Describe deployer processes for using high-risk AI systems, outlining intended purposes.",
      subControls: [
        {
          id: 1,
          title:
            "We describe deployer processes for using high-risk AI systems, outlining intended purposes.",
          description:
            "Detailed process descriptions ensure transparency in how high-risk systems are deployed and their intended use cases.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 3,
      icon: Checked,
      title: "Impacted Groups Identification",
      description:
        "Identify all categories of natural persons and groups potentially affected by AI system usage.",
      subControls: [
        {
          id: 1,
          title:
            "Identify all natural persons and groups potentially affected by AI system usage.",
          description:
            "Identifying impacted individuals and groups helps address potential risks and design systems responsibly.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 4,
      icon: Checked,
      title: "Data Assessment",
      description:
        "Assess data provided to or acquired by AI systems based on legal definitions (e.g., GDPR Article 3 (32)).",
      subControls: [
        {
          id: 1,
          title:
            "We assess data used by AI systems based on legal definitions (e.g., GDPR Article 3 (32)).",
          description:
            "Data assessments ensure compliance with legal frameworks and support ethical use of personal data in AI systems.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 5,
      icon: Checked,
      title: "Impact Measurement Strategy",
      description:
        "Develop and periodically re-evaluate strategies for measuring AI system impacts, including monitoring unexpected impacts.",
      subControls: [
        {
          id: 1,
          title:
            "We create and periodically re-evaluate strategies for measuring AI system impacts.",
          description:
            "Re-evaluating strategies ensures continued relevance and effectiveness in managing AI system impacts.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 6,
      icon: Checked,
      title: "Bias and Fairness Evaluation",
      description:
        "Develop and periodically re-evaluate strategies for measuring AI system impacts, including monitoring unexpected impacts.",
      subControls: [
        {
          id: 1,
          title:
            "We regularly evaluate bias, fairness, privacy, and environmental issues related to AI systems.",
          description:
            "Regular evaluations help ensure AI systems are ethical, equitable, and environmentally sustainable.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 7,
      icon: Checked,
      title: "Assessment Process Documentation",
      description:
        "Document identified risks and their potential impacts on affected individuals and groups.",
      subControls: [
        {
          id: 1,
          title:
            "We document known or foreseeable risks to health, safety, or fundamental rights.",
          description:
            "Documenting risks provides transparency and helps stakeholders make informed decisions regarding system deployment.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 8,
      icon: Checked,
      title: "Assessment Process Documentation",
      description:
        "Maintain documentation of the fundamental rights impact assessment process.",
      subControls: [
        {
          id: 1,
          title:
            "We maintain assessment documentation, including dates, results, and actions taken.",
          description:
            "Detailed assessment records ensure accountability and facilitate compliance reviews or audits.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 9,
      icon: Checked,
      title: "Assessment Process Documentation",
      description:
        "Integrate fundamental rights impact assessments with existing data protection impact assessments.",
      subControls: [
        {
          id: 1,
          title:
            "We integrate fundamental rights impact assessments with existing data protection assessments.",
          description:
            "Combining assessments provides a holistic view of risks and ensures consistency across regulatory compliance efforts.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 10,
      icon: Checked,
      title: "Assessment Process Documentation",
      description:
        "Regularly evaluate bias and fairness issues related to AI systems.",
      subControls: [
        {
          id: 1,
          title:
            "We specify input data and details about training, validation, and testing datasets.",
          description:
            "Clear documentation of datasets ensures transparency and supports validation of AI system performance.",
        },
        {
          id: 2,
          title:
            "We ensure representative evaluations when using human subjects.",
          description:
            "Representative evaluations protect fairness and ensure that findings are applicable across relevant user groups.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
  ],
};
