import Checked from "../../assets/icons/check-circle-green.svg";
import Exclamation from "../../assets/icons/alert-circle-orange.svg";

export const ObligationsOfDeployersAIsystems = {
  id: 6,
  controls: [
    {
      id: 1,
      icon: Exclamation,
      title: "AI Act Compliance Policies and Guidelines",
      description:
        "Assign technical and organizational measures, along with human oversight, to ensure compliance with AI regulations and manage associated risks.",
      subControls: [
        {
          id: 1,
          title:
            "We document roles, responsibilities, and communication lines for AI risk management.",
          description:
            "Clear documentation streamlines accountability and coordination in managing AI-related risks.",
        },
        {
          id: 2,
          title: "We develop policies and guidelines for AI Act compliance.",
          description:
            "Policies and guidelines provide a structured framework for meeting AI Act requirements across the organization.",
        },
      ],
      owner: "John Doe",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 2,
      icon: Checked,
      title: "AI Risk Response Planning",
      description:
        "Plan responses to AI system risks, including defining risk tolerance and mitigation strategies.",
      subControls: [
        {
          id: 1,
          title:
            "We plan responses to AI system risks, including defining risk tolerance and mitigation strategies.",
          description:
            "Risk response plans prepare organizations to manage and mitigate AI-related risks effectively and within acceptable limits.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 3,
      icon: Checked,
      title: "Compliance with AI System Instructions",
      description:
        "Regularly evaluate transparency and accountability issues related to AI systems.",
      subControls: [
        {
          id: 1,
          title:
            "We implement technical and organizational measures to adhere to AI system instructions for use.",
          description:
            "These measures ensure systems operate within their intended scope and comply with provided instructions.",
        },
        {
          id: 2,
          title:
            "We regularly evaluate safety, transparency, accountability, security, and resilience of AI systems.",
          description:
            "Regular evaluations help maintain system integrity and alignment with evolving regulatory and operational standards.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 4,
      icon: Checked,
      title: "System Risk Controls Documentation",
      description:
        "Document system risk controls, including those for third-party components.",
      subControls: [
        {
          id: 1,
          title:
            "We conduct thorough legal reviews relevant to AI system deployment.",
          description:
            "Legal reviews ensure AI systems comply with all applicable laws, minimizing regulatory and legal risks.",
        },
        {
          id: 2,
          title:
            "We prioritize risk responses based on impact, likelihood, and resources.",
          description:
            "Prioritizing risks helps allocate resources effectively and address the most critical threats first.",
        },
        {
          id: 3,
          title: "We identify residual risks to users and stakeholders.",
          description:
            "Identifying residual risks ensures informed decisions about mitigation and system deployment.",
        },
        {
          id: 4,
          title:
            "We evaluate if AI systems meet objectives and decide on deployment continuation.",
          description:
            "Regular evaluations verify that systems are achieving their goals and remain suitable for continued use.",
        },
        {
          id: 5,
          title: "We implement cybersecurity controls to protect AI models.",
          description:
            "Robust cybersecurity measures safeguard AI systems from breaches, tampering, and malicious exploitation.",
        },
        {
          id: 6,
          title:
            "We document system risk controls, including third-party components.",
          description:
            "Comprehensive documentation of risk controls ensures accountability and supports audits or compliance checks.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 5,
      icon: Checked,
      title: "Transparency and Explainability Evaluation",
      description:
        "Regularly update compliance measures based on system or regulatory changes.",
      subControls: [
        {
          id: 1,
          title:
            "We regularly update compliance measures based on system or regulatory changes.",
          description:
            "Ongoing updates ensure compliance measures remain aligned with evolving technologies and legal requirements.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 6,
      icon: Checked,
      title: "Transparency and Explainability Evaluation",
      description:
        "Explain AI models to ensure responsible use and maintain an AI systems repository.",
      subControls: [
        {
          id: 1,
          title:
            "We explain AI models to ensure responsible use and maintain an AI systems repository.",
          description:
            "Clear explanations of AI models support transparency and facilitate responsible usage across stakeholders.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 7,
      icon: Checked,
      title: "Transparency and Explainability Evaluation",
      description:
        "Maintain and update technical documentation reflecting AI system changes.",
      subControls: [
        {
          id: 1,
          title:
            "We maintain and update technical documentation reflecting system changes.",
          description:
            "Up-to-date documentation ensures accurate representation of system functionalities and compliance status.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 8,
      icon: Checked,
      title: "Transparency and Explainability Evaluation",
      description:
        "Assess the relevance and representativeness of input data used for AI system training and operation.",
      subControls: [
        {
          id: 1,
          title: "We assess input data relevance and representativeness.",
          description:
            "Data assessments ensure that AI inputs are appropriate, unbiased, and aligned with the intended purpose.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
    {
      id: 9,
      icon: Checked,
      title: "AI System Logging Implementation",
      description:
        "Implement automatic logging of AI system operations and retain logs appropriately.",
      subControls: [
        {
          id: 1,
          title:
            "We implement automatic logging of AI system operations and retain logs appropriately.",
          description:
            "Automatic logging ensures traceability of system activities, aiding in audits, troubleshooting, and compliance.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "6 (3 left)",
      completion: "50%",
    },
  ],
};
