import Checked from "../../assets/icons/check-circle-green.svg";
import Exclamation from "../../assets/icons/alert-circle-orange.svg";

export const ResponsibilitiesAlongAI = {
  id: 5,
  controls: [
    {
      id: 1,
      icon: Exclamation,
      title:
        "Conduct thorough due diligence before associating with high-risk AI systems.",
      description:
        "Define and allocate responsibilities among distributors, importers, deployers, and third parties to ensure compliance with AI regulations.",
      subControls: [
        {
          id: 1,
          title:
            "We conduct thorough due diligence before associating with high-risk AI systems.",
          description:
            "Comprehensive due diligence ensures third-party AI systems meet legal and ethical standards before adoption.",
        },
      ],
      owner: "John Doe",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 2,
      icon: Exclamation,
      title:
        "Conduct thorough due diligence before associating with high-risk AI systems.",
      description:
        "Establish clear contractual agreements with AI system providers.",
      subControls: [
        {
          id: 1,
          title:
            "We establish clear contractual agreements with AI system providers.",
          description:
            "Contracts define obligations and responsibilities, ensuring all parties comply with AI-related requirements.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 3,
      icon: Exclamation,
      title:
        "Conduct thorough due diligence before associating with high-risk AI systems.",
      description:
        "Define responsibilities in agreements with third-party suppliers of AI components.",
      subControls: [
        {
          id: 1,
          title:
            "We define responsibilities in agreements with third-party suppliers of AI components.",
          description:
            "Specifying roles and responsibilities prevents gaps in accountability and ensures compliance along the AI supply chain.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 4,
      icon: Exclamation,
      title:
        "Conduct thorough due diligence before associating with high-risk AI systems.",
      description:
        "Specify information, technical access, and support required for regulatory compliance.",
      subControls: [
        {
          id: 1,
          title:
            "We specify information, technical access, and support required for regulatory compliance.",
          description:
            "Clear specifications for information and support ensure smooth regulatory processes and timely compliance responses.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 5,
      icon: Exclamation,
      title:
        "Conduct thorough due diligence before associating with high-risk AI systems.",
      description:
        "We ensure third-party impacts, such as IP infringement, meet organizational standards.",
      subControls: [
        {
          id: 1,
          title:
            "We ensure third-party impacts, such as IP infringement, meet organizational standards.",
          description:
            "Third-party compliance with organizational standards prevents risks like intellectual property violations.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 6,
      icon: Checked,
      title: "AI System Deactivation Mechanisms",
      description:
        "Maintain mechanisms to deactivate AI systems if performance deviates from intended use.",
      subControls: [
        {
          id: 1,
          title:
            "We maintain mechanisms to deactivate AI systems if performance deviates from intended use.",
          description:
            "Deactivation mechanisms ensure systems can be stopped to mitigate risks if they perform outside intended parameters.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 7,
      icon: Checked,
      title: "Incident Monitoring for Third-Party Components",
      description:
        "Monitor and respond to incidents involving third-party components.",
      subControls: [
        {
          id: 1,
          title:
            "We monitor and respond to incidents involving third-party components.",
          description:
            "Monitoring ensures timely detection and resolution of issues with third-party AI components to maintain compliance.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 8,
      icon: Checked,
      title: "Incident Monitoring for Third-Party Components",
      description:
        "Implement measures to enhance AI system resilience against errors and faults.",
      subControls: [
        {
          id: 1,
          title:
            "We implement measures to enhance AI system resilience against errors and faults.",
          description:
            "Validation and documentation demonstrate that systems operate reliably and meet required compliance standards.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
    {
      id: 9,
      icon: Checked,
      title: "Incident Monitoring for Third-Party Components",
      description:
        "Identify and assess potential non-conformities with regulations.",
      subControls: [
        {
          id: 1,
          title:
            "We identify and assess potential non-conformities with regulations.",
          description:
            "Identifying non-conformities proactively reduces regulatory risks and ensures continued compliance.",
        },
      ],
      owner: "Jane Smith",
      noOfSubControls: "4 (all completed)",
      completion: "100%",
    },
  ],
};
