export const HumanOversight = [
  {
    id: 1,
    title: "Oversight documentation",
    questions: [
      {
        id: 1,
        question:
          "How is the supervision of the AI system designed to ensure human oversight wherever the AI solution could take or influence key decisions?",
        hint: "Describe the human oversight mechanisms in place to ensure key decisions made by the AI system are appropriately monitored.",
        priorityLevel: "high priority",
        answerType: "Long text",
        inputType: "Tiptap area",
        evidenceFileRequired: false,
        isRequired: true,
        evidenceFiles: [],
      },
      {
        id: 2,
        question:
          "How is the effectiveness of human oversight ensured, including having sufficient knowledge to interpret the system’s outputs, understand automation bias, and mitigate fundamental risks?",
        hint: "Explain strategies to ensure human oversight is effective, including sufficient knowledge of system outputs, understanding automation bias, and mitigating risks.",
        priorityLevel: "high priority",
        answerType: "Long text",
        inputType: "Tiptap area",
        evidenceFileRequired: false,
        isRequired: true,
        evidenceFiles: [],
      },
      {
        id: 3,
        question:
          "What is your organization's strategy for conducting periodic reviews of the AI application with regard to ethical values? Who will be involved in these reviews?",
        hint: "Detail your strategy for conducting periodic conformity reviews of the AI system and identify the roles involved in these reviews.",
        priorityLevel: "medium priority",
        answerType: "Long text",
        inputType: "Tiptap area",
        evidenceFileRequired: false,
        isRequired: true,
        evidenceFiles: [],
      },
    ],
  },
  {
    id: 2,
    title: "Human intervention mechanisms",
    questions: [
      {
        id: 1,
        question:
          "How is human oversight empowered to stop or alter the AI system's operations, ensuring the ability to intervene throughout its lifecycle and mitigate fundamental rights risks?",
        hint: "Describe how human oversight is empowered to intervene, stop, or alter AI system operations, ensuring control throughout the lifecycle.",
        priorityLevel: "high priority",
        answerType: "Long text",
        inputType: "Tiptap area",
        evidenceFileRequired: false,
        isRequired: true,
        evidenceFiles: [],
      },
      {
        id: 2,
        question:
          "To what extent is human deliberation replaced by automated systems in this AI application?",
        hint: "Explain the extent to which human decision-making is replaced by automated systems and the safeguards in place.",
        priorityLevel: "medium priority",
        answerType: "Long text",
        inputType: "Tiptap area",
        evidenceFileRequired: false,
        isRequired: true,
        evidenceFiles: [],
      },
    ],
  },
];
