################################################################################
# CXXCTP_tool
################################################################################

# cached path to this file, forces refresh on each use
unset(FindCXXCTP_tool_LIST_DIR CACHE)
set(FindCXXCTP_tool_LIST_DIR
    "${CMAKE_CURRENT_LIST_DIR}"
    CACHE STRING "(autogenerated) path to FindCXXCTP_tool.cmake")

# CXXCTP_tool is enabled by default.
option(CXXCTP_tool "Enable CXXCTP_tool." ON)

if(CXXCTP_tool)

  # Check if CXXCTP_tool is installed with find_program.
  find_program(CXXCTP_tool_PROGRAM CXXCTP_tool
               HINTS ${CXXCTP_tool_HINTS}
                     ${CXXCTP_tool_DIR}/build/bin/
                     ${CXXCTP_tool_PREFIX}/bin
                     ${CMAKE_CURRENT_SOURCE_DIR}/build/tool
                     /usr/bin
                     /usr/local/bin
                     $PATH
                     CMAKE_SYSTEM_PROGRAM_PATH)

  if(NOT CXXCTP_tool_PROGRAM)
    message(WARNING "Program 'CXXCTP_tool'
          not found, unable to run 'CXXCTP_tool'.")
  endif(NOT CXXCTP_tool_PROGRAM)

  # Define a function for enabling clang-tidy per target. The option above
  # makes this redundant, as it enables it for all targets already. This
  # could be used in combination with custom target commands or by
  # overriding the add_* commands with custom implementation.
  function(target_add_CXXCTP_tool
           TARGET
           GUID
           INPUTS
           OUTDIR
           EXTRA_ARGS
           CLEAN_GEN)
    if(NOT CXXCTP_tool_PROGRAM)
      message(FATAL_ERROR "Program 'CXXCTP_tool' not found, unable to run 'CXXCTP_tool'.")
    endif(NOT CXXCTP_tool_PROGRAM)

    string(REPLACE ";" " " EXTRA_ARGS_as_string "${EXTRA_ARGS}")
    string(REPLACE ";" " " INPUTS_as_string "${INPUTS}")
    # NOTE: regen files at configure step
    execute_process(
      COMMAND
        ${CMAKE_COMMAND}
        -DCXXCTP_tool_PROGRAM=${CXXCTP_tool_PROGRAM}
        -DCXXCTP_tool_CLEAN=${CLEAN_GEN}
        -DSRCDIR=${CMAKE_CURRENT_SOURCE_DIR}
        -DINPUTS=${INPUTS_as_string}
        -DOUTDIR=${OUTDIR}
        -DEXTRA_ARGS=${EXTRA_ARGS_as_string}
        -DCXXCTP_tool_LOG_CONFIG=.:=DBG9:default:console\;default=file:path=CXXCTP_tool_for_${TARGET}.log,async=true,sync_level=DBG9\;console=stream:stream=stderr
        -P
        ${FindCXXCTP_tool_LIST_DIR}/run_CXXCTP_tool.cmake)

    # NOTE: regen files at build step
    add_custom_target(
      CXXCTP_tool_target_for_${TARGET}_${GUID} ALL
      VERBATIM # If VERBATIM is given then all arguments to the commands will be escaped properly
      COMMAND
        ${CMAKE_COMMAND}
        -DCXXCTP_tool_PROGRAM=${CXXCTP_tool_PROGRAM}
        -DCXXCTP_tool_CLEAN=${CLEAN_GEN}
        -DSRCDIR=${CMAKE_CURRENT_SOURCE_DIR}
        -DINPUTS=${INPUTS_as_string}
        -DOUTDIR=${OUTDIR}
        -DEXTRA_ARGS=${EXTRA_ARGS_as_string}
        -DCXXCTP_tool_LOG_CONFIG=.:=DBG9:default:console\;default=file:path=CXXCTP_tool_for_${TARGET}.log,async=true,sync_level=DBG9\;console=stream:stream=stderr
        -P
        ${FindCXXCTP_tool_LIST_DIR}/run_CXXCTP_tool.cmake)

    add_dependencies(${TARGET} CXXCTP_tool_target_for_${TARGET}_${GUID})
  endfunction(target_add_CXXCTP_tool)

endif(CXXCTP_tool)
