# Contributing

## How to Contribute

This repository is built for the purpose of encouraging your contributions, big or small. **All** changes are considered, as long as they do not complicate the process for others.

That said, suggested ways to contribute include:

* Fork the project in GitHub
* Clone your forked repo locally
* Add your name to README.md or a code sample (or both)
* Commit and push to your forked repository
* Create a PR from your fork to the main repo in GitHub
* Add a title, edit the PR template, and submit for review
* Watch for changes requested

### Your name on the README.md

* Add your name and description to the README.md using this example:

```
### My Name
- Description about me
- [![twitter-alt][twitter-img]](https://twitter.com/example)
  [![github-alt][github-img]](https://github.com/example)
```

* Make sure you add your name to the correct letter section (alphabetically by first name)
* Avoid making any whitespace changes or alterations to someone else's profile

### A code sample

* Fork the project.
* Create a code sample under `/code` named <yourname>.<language-file-extension>. I.e. `lukeoliff.js`, `lukeoliff.php` (please create your own rather than editing an existing one)
* Create a working hello world example inside your file.

## Code of Conduct

Please note that this project is released with a [Contributor Code of Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to abide by its terms.
