# t30015 - C++20 modules package diagram test with partition dependencies
## Config
```yaml
diagrams:
  t30015_package:
    type: package
    glob:
      - t30015.cc
    package_type: module
    include:
      modules:
        - t30015
    using_module: t30015
```
## Source code
File `tests/t30015/t30015.cc`
```cpp
import t30015.app;

namespace clanguml {
namespace t30015 {
}
}
```
File `tests/t30015/src/mod7.cppm`
```cpp
export module t30015.lib1:mod7;

export namespace clanguml::t30015 {
struct CG { };
}
```
File `tests/t30015/src/mod11.cppm`
```cpp
export module t30015.lib1:mod11;

export namespace clanguml::t30015 {
struct CK { };
}
```
File `tests/t30015/src/mod17.cppm`
```cpp
export module t30015.lib1:mod17;

export namespace clanguml::t30015 {
struct CR { };
}
```
File `tests/t30015/src/mod16.cppm`
```cpp
export module t30015.lib1:mod16;

export namespace clanguml::t30015 {
struct CP { };
}
```
File `tests/t30015/src/mod10.cppm`
```cpp
export module t30015.lib1:mod10;

export namespace clanguml::t30015 {
struct CJ { };
}
```
File `tests/t30015/src/mod4.cppm`
```cpp
export module t30015.lib1:mod4;

export namespace clanguml::t30015 {
struct CD { };
}
```
File `tests/t30015/src/mod1.cppm`
```cpp
export module t30015.lib1:mod1;

export namespace clanguml::t30015 {
struct CA { };
}
```
File `tests/t30015/src/app.cppm`
```cpp
module;

#include <array>
#include <map>
#include <memory>
#include <string>
#include <vector>

export module t30015.app;
import t30015.lib1;

export namespace clanguml::t30015 {

class CBA : public CF {
public:
    CA *ca_;
    CB<int> cb_;
    std::shared_ptr<CC> cc_;
    std::map<std::string, std::unique_ptr<CD>> *cd_;
    std::array<CO, 5> co_;
    static CP *cp_;

    CBA() = default;

    CBA(CN *cn) { }

    friend CR;

    template <typename... Item> CBA(std::tuple<Item...> &items) { }

    void ce(const std::vector<CE> /*ce_*/) { }

    std::shared_ptr<CG> cg() { return {}; }

    template <typename T> void ch(std::map<T, std::shared_ptr<CH>> &ch_) { }

    template <typename T> std::map<T, std::shared_ptr<CI>> ci(T * /*t*/)
    {
        return {};
    }

    S s;
};

void cj(std::unique_ptr<CJ> /*cj_*/) { }

std::unique_ptr<CK> ck() { return {}; }

template <typename T> void cl(std::map<T, std::shared_ptr<CL>> & /*ch_*/) { }

template <typename T> std::map<T, std::shared_ptr<CM>> cm() { return {}; }

} // namespace clanguml::t30013
```
File `tests/t30015/src/mod13.cppm`
```cpp
export module t30015.lib1:mod13;

export namespace clanguml::t30015 {
struct CM { };
}
```
File `tests/t30015/src/mod9.cppm`
```cpp
export module t30015.lib1:mod9;

export namespace clanguml::t30015 {
struct CI { };
}
```
File `tests/t30015/src/mod5.cppm`
```cpp
export module t30015.lib1:mod5;

export namespace clanguml::t30015 {
struct CE { };
}
```
File `tests/t30015/src/mod18.cppm`
```cpp
export module t30015.lib1:mod18;

export namespace clanguml::t30015 {
enum class S { s1, s2, s3 };
}
```
File `tests/t30015/src/mod2.cppm`
```cpp
export module t30015.lib1:mod2;

export namespace clanguml::t30015 {
template <typename T> struct CB {
    T cb;
};
}
```
File `tests/t30015/src/mod14.cppm`
```cpp
export module t30015.lib1:mod14;

export namespace clanguml::t30015 {
struct CN { };
}
```
File `tests/t30015/src/mod12.cppm`
```cpp
export module t30015.lib1:mod12;

export namespace clanguml::t30015 {
struct CL { };
}
```
File `tests/t30015/src/mod6.cppm`
```cpp
export module t30015.lib1:mod6;

export namespace clanguml::t30015 {
struct CF { };
}
```
File `tests/t30015/src/mod8.cppm`
```cpp
export module t30015.lib1:mod8;

export namespace clanguml::t30015 {
struct CH { };
}
```
File `tests/t30015/src/mod3.cppm`
```cpp
export module t30015.lib1:mod3;

export namespace clanguml::t30015 {
struct CC { };
}
```
File `tests/t30015/src/lib1.cppm`
```cpp
export module t30015.lib1;

export import :mod1;
export import :mod2;
export import :mod3;
export import :mod4;
export import :mod5;
export import :mod6;
export import :mod7;
export import :mod8;
export import :mod9;
export import :mod10;
export import :mod11;
export import :mod12;
export import :mod13;
export import :mod14;
export import :mod15;
export import :mod16;
export import :mod17;
export import :mod18;

export namespace clanguml::t30015 {

}
```
File `tests/t30015/src/mod15.cppm`
```cpp
export module t30015.lib1:mod15;

export namespace clanguml::t30015 {
struct CO { };
}
```
## Generated PlantUML diagrams
![t30015_package](./t30015_package.svg "C++20 modules package diagram test with partition dependencies")
## Generated Mermaid diagrams
![t30015_package](./t30015_package_mermaid.svg "C++20 modules package diagram test with partition dependencies")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "lib1",
      "elements": [
        {
          "display_name": ":mod1",
          "id": "16630317849681865450",
          "is_deprecated": false,
          "name": ":mod1",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod1.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod2",
          "id": "865258280883371475",
          "is_deprecated": false,
          "name": ":mod2",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 30,
            "file": "src/mod2.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod3",
          "id": "11730698668009933772",
          "is_deprecated": false,
          "name": ":mod3",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod3.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod4",
          "id": "17448623059234951491",
          "is_deprecated": false,
          "name": ":mod4",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod4.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod5",
          "id": "8360032341024605982",
          "is_deprecated": false,
          "name": ":mod5",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod5.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod6",
          "id": "4288542241715553111",
          "is_deprecated": false,
          "name": ":mod6",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod6.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod7",
          "id": "13428933865774864166",
          "is_deprecated": false,
          "name": ":mod7",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod7.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod8",
          "id": "1920105844558427246",
          "is_deprecated": false,
          "name": ":mod8",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod8.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod9",
          "id": "1433404619576142142",
          "is_deprecated": false,
          "name": ":mod9",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod9.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod10",
          "id": "3885025055448503075",
          "is_deprecated": false,
          "name": ":mod10",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod10.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod11",
          "id": "6328720906984054121",
          "is_deprecated": false,
          "name": ":mod11",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod11.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod12",
          "id": "4000863472481157416",
          "is_deprecated": false,
          "name": ":mod12",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod12.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod13",
          "id": "9566736978393331950",
          "is_deprecated": false,
          "name": ":mod13",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod13.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod14",
          "id": "4649039366782804209",
          "is_deprecated": false,
          "name": ":mod14",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod14.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod15",
          "id": "13726850061905457280",
          "is_deprecated": false,
          "name": ":mod15",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod15.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod16",
          "id": "11482429324184312915",
          "is_deprecated": false,
          "name": ":mod16",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod16.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod17",
          "id": "10623080015263856565",
          "is_deprecated": false,
          "name": ":mod17",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 8,
            "file": "src/mod17.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":mod18",
          "id": "17549534097220431785",
          "is_deprecated": false,
          "name": ":mod18",
          "namespace": "t30015.lib1",
          "source_location": {
            "column": 12,
            "file": "src/mod18.cppm",
            "line": 4,
            "translation_unit": "t30015.cc"
          },
          "type": "module"
        }
      ],
      "id": "9671800249174802825",
      "is_deprecated": false,
      "name": "lib1",
      "namespace": "t30015",
      "type": "module"
    },
    {
      "display_name": "app",
      "id": "9602144340933602046",
      "is_deprecated": false,
      "name": "app",
      "namespace": "t30015",
      "source_location": {
        "column": 7,
        "file": "src/app.cppm",
        "line": 14,
        "translation_unit": "t30015.cc"
      },
      "type": "module"
    }
  ],
  "name": "t30015_package",
  "package_type": "module",
  "relationships": [
    {
      "destination": "1920105844558427246",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "1433404619576142142",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "16630317849681865450",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "865258280883371475",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "11730698668009933772",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "17448623059234951491",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "13726850061905457280",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "17549534097220431785",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "11482429324184312915",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "4649039366782804209",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "8360032341024605982",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "13428933865774864166",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "10623080015263856565",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "4288542241715553111",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "3885025055448503075",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "6328720906984054121",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "4000863472481157416",
      "source": "9602144340933602046",
      "type": "dependency"
    },
    {
      "destination": "9566736978393331950",
      "source": "9602144340933602046",
      "type": "dependency"
    }
  ],
  "using_module": "t30015"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd2">lib1</data>
   <data key="nd1">module</data>
   <data key="nd5">lib1</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">:mod1</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod1.cppm#L4</data>
     <data key="nd5">:mod1</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n2">
     <data key="nd2">:mod2</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod2.cppm#L4</data>
     <data key="nd5">:mod2</data>
     <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n3">
     <data key="nd2">:mod3</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod3.cppm#L4</data>
     <data key="nd5">:mod3</data>
     <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n4">
     <data key="nd2">:mod4</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod4.cppm#L4</data>
     <data key="nd5">:mod4</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n5">
     <data key="nd2">:mod5</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod5.cppm#L4</data>
     <data key="nd5">:mod5</data>
     <graph id="g6" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n6">
     <data key="nd2">:mod6</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod6.cppm#L4</data>
     <data key="nd5">:mod6</data>
     <graph id="g7" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n7">
     <data key="nd2">:mod7</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod7.cppm#L4</data>
     <data key="nd5">:mod7</data>
     <graph id="g8" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n8">
     <data key="nd2">:mod8</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod8.cppm#L4</data>
     <data key="nd5">:mod8</data>
     <graph id="g9" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n9">
     <data key="nd2">:mod9</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod9.cppm#L4</data>
     <data key="nd5">:mod9</data>
     <graph id="g10" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n10">
     <data key="nd2">:mod10</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod10.cppm#L4</data>
     <data key="nd5">:mod10</data>
     <graph id="g11" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n11">
     <data key="nd2">:mod11</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod11.cppm#L4</data>
     <data key="nd5">:mod11</data>
     <graph id="g12" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n12">
     <data key="nd2">:mod12</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod12.cppm#L4</data>
     <data key="nd5">:mod12</data>
     <graph id="g13" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n13">
     <data key="nd2">:mod13</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod13.cppm#L4</data>
     <data key="nd5">:mod13</data>
     <graph id="g14" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n14">
     <data key="nd2">:mod14</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod14.cppm#L4</data>
     <data key="nd5">:mod14</data>
     <graph id="g15" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n15">
     <data key="nd2">:mod15</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod15.cppm#L4</data>
     <data key="nd5">:mod15</data>
     <graph id="g16" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n16">
     <data key="nd2">:mod16</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod16.cppm#L4</data>
     <data key="nd5">:mod16</data>
     <graph id="g17" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n17">
     <data key="nd2">:mod17</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod17.cppm#L4</data>
     <data key="nd5">:mod17</data>
     <graph id="g18" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n18">
     <data key="nd2">:mod18</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/mod18.cppm#L4</data>
     <data key="nd5">:mod18</data>
     <graph id="g19" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
   </graph>
  </node>
  <node id="n19">
   <data key="nd2">app</data>
   <data key="nd1">module</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30015/src/app.cppm#L14</data>
   <data key="nd5">app</data>
   <graph id="g20" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
  </node>
  <edge id="e0" source="n19" target="n8">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e1" source="n19" target="n9">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e2" source="n19" target="n1">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e3" source="n19" target="n2">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e4" source="n19" target="n3">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e5" source="n19" target="n4">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e6" source="n19" target="n15">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e7" source="n19" target="n18">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e8" source="n19" target="n16">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e9" source="n19" target="n14">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e10" source="n19" target="n5">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e11" source="n19" target="n7">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e12" source="n19" target="n17">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e13" source="n19" target="n6">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e14" source="n19" target="n10">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e15" source="n19" target="n11">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e16" source="n19" target="n12">
   <data key="ed0">dependency</data>
  </edge>
  <edge id="e17" source="n19" target="n13">
   <data key="ed0">dependency</data>
  </edge>
 </graph>
</graphml>

```
