# t30014 - C++20 modules package diagram test with partitions
## Config
```yaml
diagrams:
  t30014_package:
    type: package
    glob:
      - t30014.cc
    package_type: module
    include:
      modules:
        - t30014
    exclude:
      modules:
        - t30014.app:lib1.mod2
    using_module: t30014
```
## Source code
File `tests/t30014/t30014.cc`
```cpp
import t30014.app;

namespace clanguml {
namespace t30014 {
}
}
```
File `tests/t30014/src/lib1mod2.cppm`
```cpp
export module t30014.app:lib1.mod2;

export namespace clanguml::t30014 {
class E { };
} // namespace clanguml::t30014
```
File `tests/t30014/src/t30014_mod.cppm`
```cpp
export module t30014.app;
import :lib1;
import :lib1.mod1;
import :lib1.mod2;
import :lib2;

export namespace clanguml::t30014 {
class A {
    int get() { return a; }

    int a;
};
} // namespace clanguml::t30014
```
File `tests/t30014/src/lib2.cppm`
```cpp
export module t30014.app:lib2;

export namespace clanguml::t30014 {
class C { };

template <typename T> class CC {
    T t;
};

namespace detail {
enum class CCC { ccc1, ccc2 };
} // namespace detail
} // namespace clanguml::t30014
```
File `tests/t30014/src/lib1.cppm`
```cpp
export module t30014.app:lib1;

export namespace clanguml::t30014 {
class B { };

template <typename T> class BB {
    T t;
};

namespace detail {
enum class BBB { bbb1, bbb2 };
} // namespace detail
} // namespace clanguml::t30014
```
File `tests/t30014/src/lib1mod1.cppm`
```cpp
export module t30014.app:lib1.mod1;

export namespace clanguml::t30014 {
class D { };
} // namespace clanguml::t30014
```
## Generated PlantUML diagrams
![t30014_package](./t30014_package.svg "C++20 modules package diagram test with partitions")
## Generated Mermaid diagrams
![t30014_package](./t30014_package_mermaid.svg "C++20 modules package diagram test with partitions")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "app",
      "elements": [
        {
          "display_name": ":lib1",
          "elements": [
            {
              "display_name": "mod1",
              "id": "16272914886425350409",
              "is_deprecated": false,
              "name": "mod1",
              "namespace": "t30014.app:lib1",
              "source_location": {
                "column": 7,
                "file": "src/lib1mod1.cppm",
                "line": 4,
                "translation_unit": "t30014.cc"
              },
              "type": "module"
            }
          ],
          "id": "12951885779932657355",
          "is_deprecated": false,
          "name": ":lib1",
          "namespace": "t30014.app",
          "source_location": {
            "column": 7,
            "file": "src/lib1.cppm",
            "line": 4,
            "translation_unit": "t30014.cc"
          },
          "type": "module"
        },
        {
          "display_name": ":lib2",
          "id": "12559215005634166087",
          "is_deprecated": false,
          "name": ":lib2",
          "namespace": "t30014.app",
          "source_location": {
            "column": 7,
            "file": "src/lib2.cppm",
            "line": 4,
            "translation_unit": "t30014.cc"
          },
          "type": "module"
        }
      ],
      "id": "15460027636886309813",
      "is_deprecated": false,
      "name": "app",
      "namespace": "t30014",
      "type": "module"
    }
  ],
  "name": "t30014_package",
  "package_type": "module",
  "relationships": [],
  "using_module": "t30014"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd2">app</data>
   <data key="nd1">module</data>
   <data key="nd5">app</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">:lib1</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30014/src/lib1.cppm#L4</data>
     <data key="nd5">:lib1</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd2">mod1</data>
       <data key="nd1">module</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30014/src/lib1mod1.cppm#L4</data>
       <data key="nd5">mod1</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
    <node id="n3">
     <data key="nd2">:lib2</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30014/src/lib2.cppm#L4</data>
     <data key="nd5">:lib2</data>
     <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
   </graph>
  </node>
 </graph>
</graphml>

```
