# t30012 - C++20 modules package diagram test
## Config
```yaml
diagrams:
  t30012_package:
    type: package
    glob:
      - t30012.cc
    package_type: module
    include:
      modules:
        - t30012
    using_module: t30012
```
## Source code
File `tests/t30012/t30012.cc`
```cpp
import t30012.app;
import t30012.app.lib1;
import t30012.app.lib1.mod1;
import t30012.app.lib1.mod2;
import t30012.app.lib2;

namespace clanguml {
namespace t30012 {
class R {
    A *a;
    B *b;
    C *c;
};
}
}
```
File `tests/t30012/src/lib1mod2.cppm`
```cpp
export module t30012.app.lib1.mod2;

export namespace clanguml::t30012 {
class E { };
}
```
File `tests/t30012/src/lib2.cppm`
```cpp
export module t30012.app.lib2;

export namespace clanguml::t30012 {
class C { };

template <typename T> class CC {
    T t;
};

namespace detail {
enum class CCC { ccc1, ccc2 };
}
}
```
File `tests/t30012/src/lib1.cppm`
```cpp
export module t30012.app.lib1;

export namespace clanguml::t30012 {
class B { };

template <typename T> class BB {
    T t;
};

namespace detail {
enum class BBB { bbb1, bbb2 };
} // namespace detail
}
```
File `tests/t30012/src/t30012_mod.cppm`
```cpp
export module t30012.app;
export import t30012.app.lib1;
export import t30012.app.lib2;

export namespace clanguml::t30012 {
class A {
    int get() { return a; }

    int a;
};
}
```
File `tests/t30012/src/lib1mod1.cppm`
```cpp
export module t30012.app.lib1.mod1;

export namespace clanguml::t30012 {
class D { };
}
```
## Generated PlantUML diagrams
![t30012_package](./t30012_package.svg "C++20 modules package diagram test")
## Generated Mermaid diagrams
![t30012_package](./t30012_package_mermaid.svg "C++20 modules package diagram test")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "display_name": "app",
      "elements": [
        {
          "display_name": "lib1",
          "elements": [
            {
              "display_name": "mod1",
              "id": "15124937273703393654",
              "is_deprecated": false,
              "name": "mod1",
              "namespace": "t30012.app.lib1",
              "source_location": {
                "column": 7,
                "file": "src/lib1mod1.cppm",
                "line": 4,
                "translation_unit": "t30012.cc"
              },
              "type": "module"
            },
            {
              "display_name": "mod2",
              "id": "1651613418601825427",
              "is_deprecated": false,
              "name": "mod2",
              "namespace": "t30012.app.lib1",
              "source_location": {
                "column": 7,
                "file": "src/lib1mod2.cppm",
                "line": 4,
                "translation_unit": "t30012.cc"
              },
              "type": "module"
            }
          ],
          "id": "16627110919681625923",
          "is_deprecated": false,
          "name": "lib1",
          "namespace": "t30012.app",
          "source_location": {
            "column": 7,
            "file": "src/lib1.cppm",
            "line": 4,
            "translation_unit": "t30012.cc"
          },
          "type": "module"
        },
        {
          "display_name": "lib2",
          "id": "6125476652975421063",
          "is_deprecated": false,
          "name": "lib2",
          "namespace": "t30012.app",
          "source_location": {
            "column": 7,
            "file": "src/lib2.cppm",
            "line": 4,
            "translation_unit": "t30012.cc"
          },
          "type": "module"
        }
      ],
      "id": "3054933854037582522",
      "is_deprecated": false,
      "name": "app",
      "namespace": "t30012",
      "type": "module"
    }
  ],
  "name": "t30012_package",
  "package_type": "module",
  "relationships": [],
  "using_module": "t30012"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <node id="n0">
   <data key="nd2">app</data>
   <data key="nd1">module</data>
   <data key="nd5">app</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">lib1</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30012/src/lib1.cppm#L4</data>
     <data key="nd5">lib1</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
      <node id="n2">
       <data key="nd2">mod1</data>
       <data key="nd1">module</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30012/src/lib1mod1.cppm#L4</data>
       <data key="nd5">mod1</data>
       <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
      <node id="n3">
       <data key="nd2">mod2</data>
       <data key="nd1">module</data>
       <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30012/src/lib1mod2.cppm#L4</data>
       <data key="nd5">mod2</data>
       <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
      </node>
     </graph>
    </node>
    <node id="n4">
     <data key="nd2">lib2</data>
     <data key="nd1">module</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30012/src/lib2.cppm#L4</data>
     <data key="nd5">lib2</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
   </graph>
  </node>
 </graph>
</graphml>

```
