# t30004 - PlantUML package decorators test case
## Config
```yaml
diagrams:
  t30004_package:
    type: package
    glob:
      - t30004.cc
    include:
      namespaces:
        - clanguml::t30004
    using_namespace: clanguml::t30004
    plantuml:
      before:
        - "' t30004 test package diagram"
```
## Source code
File `tests/t30004/t30004.cc`
```cpp
namespace clanguml {
namespace t30004 {

/// @uml{style[#green]}
namespace A {

/// @uml{note[ bottom ] Package AAA.}
namespace AAA {
}

/// \uml{note[right] Package BBB.}
namespace BBB {
}

///
/// @uml{note:t30004_package[bottom] CCCC package note.}
/// This is package CCC.
namespace CCC {
}

/// \uml{skip}
namespace DDD {
}

/// @uml{style[#pink;line:red;line.bold;text:red]}
/// \uml{note[top] We skipped DDD.}
namespace EEE {
}

/// \uml{note[top] Another CCC note.}
namespace CCC {
}
}
}
}
```
## Generated PlantUML diagrams
![t30004_package](./t30004_package.svg "PlantUML package decorators test case")
## Generated Mermaid diagrams
![t30004_package](./t30004_package_mermaid.svg "PlantUML package decorators test case")
## Generated JSON models
```json
{
  "diagram_type": "package",
  "elements": [
    {
      "comment": {
        "formatted": "@uml{style[#green]}",
        "raw": "/// @uml{style[#green]}"
      },
      "display_name": "A",
      "elements": [
        {
          "comment": {
            "formatted": "@uml{note[ bottom ] Package AAA.}",
            "raw": "/// @uml{note[ bottom ] Package AAA.}"
          },
          "display_name": "AAA",
          "id": "12137482406900633279",
          "is_deprecated": false,
          "name": "AAA",
          "namespace": "clanguml::t30004::A",
          "source_location": {
            "column": 11,
            "file": "t30004.cc",
            "line": 8,
            "translation_unit": "t30004.cc"
          },
          "type": "namespace"
        },
        {
          "comment": {
            "formatted": "\\uml{note[right] Package BBB.}",
            "raw": "/// \\uml{note[right] Package BBB.}"
          },
          "display_name": "BBB",
          "id": "15859032696498839429",
          "is_deprecated": false,
          "name": "BBB",
          "namespace": "clanguml::t30004::A",
          "source_location": {
            "column": 11,
            "file": "t30004.cc",
            "line": 12,
            "translation_unit": "t30004.cc"
          },
          "type": "namespace"
        },
        {
          "comment": {
            "formatted": "\n @uml{note:t30004_package[bottom] CCCC package note.}\n This is package CCC.",
            "raw": "///\n/// @uml{note:t30004_package[bottom] CCCC package note.}\n/// This is package CCC."
          },
          "display_name": "CCC",
          "id": "18437809564453612539",
          "is_deprecated": false,
          "name": "CCC",
          "namespace": "clanguml::t30004::A",
          "source_location": {
            "column": 11,
            "file": "t30004.cc",
            "line": 18,
            "translation_unit": "t30004.cc"
          },
          "type": "namespace"
        },
        {
          "comment": {
            "formatted": "@uml{style[#pink;line:red;line.bold;text:red]}\n\\uml{note[top] We skipped DDD.}",
            "raw": "/// @uml{style[#pink;line:red;line.bold;text:red]}\n/// \\uml{note[top] We skipped DDD.}"
          },
          "display_name": "EEE",
          "id": "8679397857730326233",
          "is_deprecated": false,
          "name": "EEE",
          "namespace": "clanguml::t30004::A",
          "source_location": {
            "column": 11,
            "file": "t30004.cc",
            "line": 27,
            "translation_unit": "t30004.cc"
          },
          "type": "namespace"
        }
      ],
      "id": "267285326992318765",
      "is_deprecated": false,
      "name": "A",
      "namespace": "clanguml::t30004",
      "source_location": {
        "column": 11,
        "file": "t30004.cc",
        "line": 5,
        "translation_unit": "t30004.cc"
      },
      "type": "namespace"
    }
  ],
  "name": "t30004_package",
  "package_type": "namespace",
  "relationships": [],
  "using_namespace": "clanguml::t30004"
}
```
## Generated GraphML models
```xml
<?xml version="1.0"?>
<graphml xmlns="http://graphml.graphdrawing.org/xmlns" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd">
 <key attr.name="id" attr.type="string" for="graph" id="gd0" />
 <key attr.name="diagram_type" attr.type="string" for="graph" id="gd1" />
 <key attr.name="name" attr.type="string" for="graph" id="gd2" />
 <key attr.name="using_namespace" attr.type="string" for="graph" id="gd3" />
 <key attr.name="id" attr.type="string" for="node" id="nd0" />
 <key attr.name="type" attr.type="string" for="node" id="nd1" />
 <key attr.name="name" attr.type="string" for="node" id="nd2" />
 <key attr.name="stereotype" attr.type="string" for="node" id="nd3" />
 <key attr.name="url" attr.type="string" for="node" id="nd4" />
 <key attr.name="tooltip" attr.type="string" for="node" id="nd5" />
 <key attr.name="type" attr.type="string" for="edge" id="ed0" />
 <key attr.name="access" attr.type="string" for="edge" id="ed1" />
 <key attr.name="label" attr.type="string" for="edge" id="ed2" />
 <key attr.name="url" attr.type="string" for="edge" id="ed3" />
 <graph id="g0" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
  <data key="gd3">clanguml::t30004</data>
  <node id="n0">
   <data key="nd2">A</data>
   <data key="nd1">namespace</data>
   <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30004/t30004.cc#L5</data>
   <data key="nd5">A</data>
   <graph id="g1" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst">
    <node id="n1">
     <data key="nd2">AAA</data>
     <data key="nd1">namespace</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30004/t30004.cc#L8</data>
     <data key="nd5">AAA</data>
     <graph id="g2" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n2">
     <data key="nd2">BBB</data>
     <data key="nd1">namespace</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30004/t30004.cc#L12</data>
     <data key="nd5">BBB</data>
     <graph id="g3" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n3">
     <data key="nd2">CCC</data>
     <data key="nd1">namespace</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30004/t30004.cc#L18</data>
     <data key="nd5">CCC</data>
     <graph id="g4" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n4">
     <data key="nd2">EEE</data>
     <data key="nd1">namespace</data>
     <data key="nd4">https://github.com/bkryza/clang-uml/blob/ca93ebc700c4d8ac5504d33adbb899f44e90a1a4/tests/t30004/t30004.cc#L27</data>
     <data key="nd5">EEE</data>
     <graph id="g5" edgedefault="directed" parse.nodeids="canonical" parse.edgeids="canonical" parse.order="nodesfirst" />
    </node>
    <node id="n5">
     <data key="nd1">note</data>
     <data key="nd2"><![CDATA[Package AAA.]]></data>
    </node>
    <node id="n6">
     <data key="nd1">note</data>
     <data key="nd2"><![CDATA[Package BBB.]]></data>
    </node>
    <node id="n7">
     <data key="nd1">note</data>
     <data key="nd2"><![CDATA[CCCC package note.]]></data>
    </node>
    <node id="n8">
     <data key="nd1">note</data>
     <data key="nd2"><![CDATA[We skipped DDD.]]></data>
    </node>
    <edge id="e0" source="n5" target="n1">
     <data key="ed0">none</data>
    </edge>
    <edge id="e1" source="n6" target="n2">
     <data key="ed0">none</data>
    </edge>
    <edge id="e2" source="n7" target="n3">
     <data key="ed0">none</data>
    </edge>
    <edge id="e3" source="n8" target="n4">
     <data key="ed0">none</data>
    </edge>
   </graph>
  </node>
 </graph>
</graphml>

```
