# t20052 - Test case for inlining lambda operator calls
## Config
```yaml
diagrams:
  t20052_sequence:
    type: sequence
    glob:
      - t20052.cc
    include:
      namespaces:
        - clanguml::t20052
    using_namespace: clanguml::t20052
    inline_lambda_messages: true
    from:
      - function: "clanguml::t20052::tmain()"
```
## Source code
File `tests/t20052/t20052.cc`
```cpp
#include <algorithm>
#include <functional>
#include <memory>
#include <optional>
#include <utility>
#include <vector>

namespace clanguml {
namespace t20052 {
struct A {
    void a() { aa(); }

    void aa() { aaa(); }

    void aaa() { }
};

struct B {
    void b() { bb(); }

    void bb() { bbb(); }

    void bbb() { }

    void eb() { }
};

struct C {
    void c() { cc(); }

    void cc() { ccc(); }

    void ccc() { }
};

struct D {
    int add5(int arg) const { return arg + 5; }
};

class E {
    std::optional<std::shared_ptr<B>> maybe_b;
    std::shared_ptr<A> a;

public:
    template <typename F> void setup(F &&f) { f(maybe_b); }
};

template <typename F> struct R {
    R(F &&f)
        : f_{std::move(f)}
    {
    }

    void r() { f_(); }

    F f_;
};

void tmain()
{
    A a;
    B b;
    C c;

    // The activity shouldn't be marked at the lambda definition, but
    // wherever it is actually called...
    auto alambda = [&a, &b]() {
        a.a();
        b.b();
    };

    // ...like here
    alambda();

    // There should be no call to B in the sequence diagram as the blambda
    // is never called
    [[maybe_unused]] auto blambda = [&b]() { b.b(); };

    // Nested lambdas should also work
    auto clambda = [alambda, &c]() {
        c.c();
        alambda();
    };
    clambda();

    R r{[&c]() { c.c(); }};

    r.r();

    D d;

    std::vector<int> ints{0, 1, 2, 3, 4};
    std::transform(ints.begin(), ints.end(), ints.begin(),
        [&d](auto i) { return d.add5(i); });

    // TODO: Fix naming function call arguments which are lambdas
    //    E e;
    //
    //    e.setup([](auto &&arg) mutable {
    //        // We cannot know here what 'arg' might be
    //        arg.value()->eb();
    //    });
}
}
}
```
## Generated PlantUML diagrams
![t20052_sequence](./t20052_sequence.svg "Test case for inlining lambda operator calls")
## Generated Mermaid diagrams
![t20052_sequence](./t20052_sequence_mermaid.svg "Test case for inlining lambda operator calls")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20052_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20052::tmain()",
      "id": "14906999416879500308",
      "name": "tmain",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 6,
        "file": "t20052.cc",
        "line": 59,
        "translation_unit": "t20052.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20052::A::a()",
          "id": "9812288086881147823",
          "name": "a",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 11,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aa()",
          "full_name": "clanguml::t20052::A::aa()",
          "id": "1219182608592065706",
          "name": "aa",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 13,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aaa()",
          "full_name": "clanguml::t20052::A::aaa()",
          "id": "10702433226446089600",
          "name": "aaa",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 15,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20052::A",
      "id": "13624834310293289324",
      "name": "A",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 8,
        "file": "t20052.cc",
        "line": 10,
        "translation_unit": "t20052.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b()",
          "full_name": "clanguml::t20052::B::b()",
          "id": "2556125950244593078",
          "name": "b",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 19,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb()",
          "full_name": "clanguml::t20052::B::bb()",
          "id": "5176546195294219959",
          "name": "bb",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 21,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbb()",
          "full_name": "clanguml::t20052::B::bbb()",
          "id": "6794990482409299371",
          "name": "bbb",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 23,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20052::B",
      "id": "14866947899451415150",
      "name": "B",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 8,
        "file": "t20052.cc",
        "line": 18,
        "translation_unit": "t20052.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "c()",
          "full_name": "clanguml::t20052::C::c()",
          "id": "2293882177893545884",
          "name": "c",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 29,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "cc()",
          "full_name": "clanguml::t20052::C::cc()",
          "id": "7418624241505725736",
          "name": "cc",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 31,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "ccc()",
          "full_name": "clanguml::t20052::C::ccc()",
          "id": "5866393105513762844",
          "name": "ccc",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 33,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20052::C",
      "id": "5567336912778028391",
      "name": "C",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 8,
        "file": "t20052.cc",
        "line": 28,
        "translation_unit": "t20052.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "R((lambda at t20052.cc:86:9) &&)",
          "full_name": "clanguml::t20052::R<(lambda at t20052.cc:86:9)>::R((lambda at t20052.cc:86:9) &&)",
          "id": "14175291084158731020",
          "name": "R",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 5,
            "file": "t20052.cc",
            "line": 49,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        },
        {
          "display_name": "r()",
          "full_name": "clanguml::t20052::R<(lambda at t20052.cc:86:9)>::r()",
          "id": "13147751979125455669",
          "name": "r",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 10,
            "file": "t20052.cc",
            "line": 54,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "R<(lambda at t20052.cc:86:9)>",
      "full_name": "clanguml::t20052::R<(lambda at t20052.cc:86:9)>",
      "id": "4386688193900058862",
      "name": "R",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 30,
        "file": "t20052.cc",
        "line": 48,
        "translation_unit": "t20052.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "add5(int) const",
          "full_name": "clanguml::t20052::D::add5(int) const",
          "id": "16796556393892277847",
          "name": "add5",
          "namespace": "clanguml::t20052",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 37,
            "translation_unit": "t20052.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D",
      "full_name": "clanguml::t20052::D",
      "id": "8730131803247830968",
      "name": "D",
      "namespace": "clanguml::t20052",
      "source_location": {
        "column": 8,
        "file": "t20052.cc",
        "line": 36,
        "translation_unit": "t20052.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 68,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "9812288086881147823",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9812288086881147823",
            "participant_id": "13624834310293289324"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 11,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "1219182608592065706",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1219182608592065706",
            "participant_id": "13624834310293289324"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 13,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "10702433226446089600",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 69,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "2556125950244593078",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2556125950244593078",
            "participant_id": "14866947899451415150"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 19,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "5176546195294219959",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5176546195294219959",
            "participant_id": "14866947899451415150"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 21,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "6794990482409299371",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 81,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "2293882177893545884",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2293882177893545884",
            "participant_id": "5567336912778028391"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 29,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "7418624241505725736",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7418624241505725736",
            "participant_id": "5567336912778028391"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 31,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "5866393105513762844",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 68,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "9812288086881147823",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9812288086881147823",
            "participant_id": "13624834310293289324"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 11,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "1219182608592065706",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1219182608592065706",
            "participant_id": "13624834310293289324"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 13,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "10702433226446089600",
            "participant_id": "13624834310293289324"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20052.cc",
            "line": 69,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "2556125950244593078",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2556125950244593078",
            "participant_id": "14866947899451415150"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 19,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "5176546195294219959",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5176546195294219959",
            "participant_id": "14866947899451415150"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 21,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "6794990482409299371",
            "participant_id": "14866947899451415150"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "R((lambda at t20052.cc:86:9) &&)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 7,
            "file": "t20052.cc",
            "line": 86,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "14175291084158731020",
            "participant_id": "4386688193900058862"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "r()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20052.cc",
            "line": 88,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "13147751979125455669",
            "participant_id": "4386688193900058862"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13147751979125455669",
            "participant_id": "4386688193900058862"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20052.cc",
            "line": 86,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "2293882177893545884",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2293882177893545884",
            "participant_id": "5567336912778028391"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20052.cc",
            "line": 29,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "7418624241505725736",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7418624241505725736",
            "participant_id": "5567336912778028391"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20052.cc",
            "line": 31,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "5866393105513762844",
            "participant_id": "5567336912778028391"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14906999416879500308",
            "participant_id": "14906999416879500308"
          },
          "name": "add5(int) const",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 31,
            "file": "t20052.cc",
            "line": 94,
            "translation_unit": "t20052.cc"
          },
          "to": {
            "activity_id": "16796556393892277847",
            "participant_id": "8730131803247830968"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "14906999416879500308",
        "location": "clanguml::t20052::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20052"
}
```
## Generated GraphML models
