# t20046 - Test case for call expressions in nested lambdas
## Config
```yaml
add_compile_flags:
  - -fparse-all-comments
diagrams:
  t20046_sequence:
    type: sequence
    glob:
      - t20046.cc
    include:
      namespaces:
        - clanguml::t20046
    using_namespace: clanguml::t20046
    from:
      - function: "clanguml::t20046::tmain()"
```
## Source code
File `tests/t20046/t20046.cc`
```cpp
namespace clanguml {
namespace t20046 {

template <typename F> int a1(F &&f) { return f(42); }

int a2(int x) { return 2; }

int a3(int x) { return 3; }

int tmain()
{
    // Call expression in a nested lambda
    auto v1 = [](auto &&arg1) {
        return [](auto &&arg2) { return a2(arg2); }(arg1);
    }(0);

    // Call expression in a nested lambda in call expression
    auto v4 = a1(
        [](auto &&arg1) { return [](auto &&arg2) { return a3(arg2); }(arg1); });

    return 0;
}
}
}
```
## Generated PlantUML diagrams
![t20046_sequence](./t20046_sequence.svg "Test case for call expressions in nested lambdas")
## Generated Mermaid diagrams
![t20046_sequence](./t20046_sequence_mermaid.svg "Test case for call expressions in nested lambdas")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20046_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20046::tmain()",
      "id": "8740778777530916121",
      "name": "tmain",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 5,
        "file": "t20046.cc",
        "line": 10,
        "translation_unit": "t20046.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto &&) const",
          "full_name": "clanguml::t20046::tmain()::(lambda t20046.cc:13:15)::operator()(auto &&) const",
          "id": "1399981358254574182",
          "name": "operator()",
          "namespace": "clanguml::t20046::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20046.cc:13:15)",
      "full_name": "clanguml::t20046::tmain()::(lambda t20046.cc:13:15)",
      "id": "14945611928916456551",
      "name": "tmain()::(lambda t20046.cc:13:15)",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 15,
        "file": "t20046.cc",
        "line": 13,
        "translation_unit": "t20046.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto &&) const",
          "full_name": "clanguml::t20046::clanguml::t20046::tmain()::(lambda t20046.cc:13:15)::(lambda t20046.cc:14:16)::operator()(auto &&) const",
          "id": "6170983257636432660",
          "name": "operator()",
          "namespace": "clanguml::t20046::tmain()::(anonymous class)::operator()(auto &&)",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20046.cc:13:15)::(lambda t20046.cc:14:16)",
      "full_name": "clanguml::t20046::clanguml::t20046::tmain()::(lambda t20046.cc:13:15)::(lambda t20046.cc:14:16)",
      "id": "1307842516029171611",
      "name": "clanguml::t20046::tmain()::(lambda t20046.cc:13:15)::(lambda t20046.cc:14:16)",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 16,
        "file": "t20046.cc",
        "line": 14,
        "translation_unit": "t20046.cc"
      },
      "type": "lambda"
    },
    {
      "display_name": "a2(int)",
      "full_name": "clanguml::t20046::a2(int)",
      "id": "2137782590639739804",
      "name": "a2",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 5,
        "file": "t20046.cc",
        "line": 6,
        "translation_unit": "t20046.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a1<(lambda at t20046.cc:19:9)>((lambda at t20046.cc:19:9) &&)",
      "full_name": "clanguml::t20046::a1<(lambda at t20046.cc:19:9)>((lambda at /home/bartek/devel/clang-uml/tests/t20046/t20046.cc:19:9) &&)",
      "id": "3238820647954703898",
      "name": "a1",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 27,
        "file": "t20046.cc",
        "line": 4,
        "translation_unit": "t20046.cc"
      },
      "type": "function_template"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto &&) const",
          "full_name": "clanguml::t20046::tmain()::(lambda t20046.cc:19:9)::operator()(auto &&) const",
          "id": "2611972639173990319",
          "name": "operator()",
          "namespace": "clanguml::t20046::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20046.cc:19:9)",
      "full_name": "clanguml::t20046::tmain()::(lambda t20046.cc:19:9)",
      "id": "14668215983962849304",
      "name": "tmain()::(lambda t20046.cc:19:9)",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 9,
        "file": "t20046.cc",
        "line": 19,
        "translation_unit": "t20046.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto &&) const",
          "full_name": "clanguml::t20046::clanguml::t20046::tmain()::(lambda t20046.cc:19:9)::(lambda t20046.cc:19:34)::operator()(auto &&) const",
          "id": "8748747764292125090",
          "name": "operator()",
          "namespace": "clanguml::t20046::tmain()::(anonymous class)::operator()(auto &&)",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20046.cc:19:9)::(lambda t20046.cc:19:34)",
      "full_name": "clanguml::t20046::clanguml::t20046::tmain()::(lambda t20046.cc:19:9)::(lambda t20046.cc:19:34)",
      "id": "17423609226710801275",
      "name": "clanguml::t20046::tmain()::(lambda t20046.cc:19:9)::(lambda t20046.cc:19:34)",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 34,
        "file": "t20046.cc",
        "line": 19,
        "translation_unit": "t20046.cc"
      },
      "type": "lambda"
    },
    {
      "display_name": "a3(int)",
      "full_name": "clanguml::t20046::a3(int)",
      "id": "8350199800528268175",
      "name": "a3",
      "namespace": "clanguml::t20046",
      "source_location": {
        "column": 5,
        "file": "t20046.cc",
        "line": 8,
        "translation_unit": "t20046.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "comment": "Call expression in a nested lambda",
          "from": {
            "activity_id": "8740778777530916121",
            "participant_id": "8740778777530916121"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20046.cc",
            "line": 13,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "1399981358254574182",
            "participant_id": "14945611928916456551"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1399981358254574182",
            "participant_id": "14945611928916456551"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20046.cc",
            "line": 14,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "6170983257636432660",
            "participant_id": "1307842516029171611"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6170983257636432660",
            "participant_id": "1307842516029171611"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 41,
            "file": "t20046.cc",
            "line": 14,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "2137782590639739804",
            "participant_id": "2137782590639739804"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8740778777530916121",
            "participant_id": "8740778777530916121"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20046.cc",
            "line": 13,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "1399981358254574182",
            "participant_id": "14945611928916456551"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1399981358254574182",
            "participant_id": "14945611928916456551"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20046.cc",
            "line": 14,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "6170983257636432660",
            "participant_id": "1307842516029171611"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6170983257636432660",
            "participant_id": "1307842516029171611"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 41,
            "file": "t20046.cc",
            "line": 14,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "2137782590639739804",
            "participant_id": "2137782590639739804"
          },
          "type": "message"
        },
        {
          "comment": "Call expression in a nested lambda in call expression",
          "from": {
            "activity_id": "8740778777530916121",
            "participant_id": "8740778777530916121"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20046.cc",
            "line": 18,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "3238820647954703898",
            "participant_id": "3238820647954703898"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "3238820647954703898",
            "participant_id": "3238820647954703898"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 46,
            "file": "t20046.cc",
            "line": 4,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "2611972639173990319",
            "participant_id": "14668215983962849304"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2611972639173990319",
            "participant_id": "14668215983962849304"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 34,
            "file": "t20046.cc",
            "line": 19,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "8748747764292125090",
            "participant_id": "17423609226710801275"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8748747764292125090",
            "participant_id": "17423609226710801275"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 59,
            "file": "t20046.cc",
            "line": 19,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "8350199800528268175",
            "participant_id": "8350199800528268175"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8740778777530916121",
            "participant_id": "8740778777530916121"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20046.cc",
            "line": 19,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "2611972639173990319",
            "participant_id": "14668215983962849304"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2611972639173990319",
            "participant_id": "14668215983962849304"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 34,
            "file": "t20046.cc",
            "line": 19,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "8748747764292125090",
            "participant_id": "17423609226710801275"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8748747764292125090",
            "participant_id": "17423609226710801275"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 59,
            "file": "t20046.cc",
            "line": 19,
            "translation_unit": "t20046.cc"
          },
          "to": {
            "activity_id": "8350199800528268175",
            "participant_id": "8350199800528268175"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "8740778777530916121",
        "location": "clanguml::t20046::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20046"
}
```
## Generated GraphML models
