# t20044 - Test case for template method call expressions with callables
## Config
```yaml
add_compile_flags:
  - -fparse-all-comments
diagrams:
  t20044_sequence:
    type: sequence
    glob:
      - t20044.cc
    type_aliases:
      "clanguml::t20044::detail::expected<int,clanguml::t20044::error>": result_t
    generate_message_comments: true
    include:
      namespaces:
        - clanguml::t20044
    exclude:
      namespaces:
        - clanguml::t20044::detail2
    using_namespace: clanguml::t20044
    from:
      - function: "clanguml::t20044::tmain()"
```
## Source code
File `tests/t20044/t20044.cc`
```cpp
// #include "include/expected.hpp"

#include <functional>
#include <optional>
#include <thread>

namespace clanguml {
namespace t20044 {

enum class error { OK, FAIL };

namespace detail {
// Trivial std::expected mock-up just for testing calls through lambda
// expressions passed as arguments to methods
template <typename V, typename E> class expected {
private:
    std::optional<V> value_;
    std::optional<E> error_;

public:
    explicit expected(V v)
        : value_{std::move(v)}
    {
    }
    explicit expected(E e)
        : error_{std::move(e)}
    {
    }

    const auto &value() const { return *value_; }

    const auto &error() const { return *error_; }

    template <class F> auto and_then(F &&f) &&
    {
        if (value_)
            return f(*value_);

        return *this;
    }
};
} // namespace detail

namespace detail2 {
template <typename F> void run(F &&f) { f(); }
} // namespace detail2

using result_t = detail::expected<int, error>;

struct A {
    auto a() const { }

    auto a1() const { return result_t{10}; }

    auto a2(int arg) const { return result_t{arg + 1}; }

    auto a4(int arg) const { return result_t{arg + 1}; }

    void a5() { }
};

auto a3(int arg) { return result_t{arg + 1}; }

struct R {
    template <typename F> R(F &&f) { f(); }
};

int tmain()
{
    A a;

    // Call to template constructor with callable parameter and lambda
    // expression as argument
    R r([&a]() { a.a(); });

    std::function<result_t(const A &, int)> a4_wrapper = &A::a4;

    std::function<result_t(int)> a4_wrapper_to_a =
        std::bind(a4_wrapper, a, std::placeholders::_1);

    // The message to detail2::run() is skipped due to exclude filter, however
    // the call to lambda and A::a5() is rendered
    // TODO: Add some marker to highlight that this is not a direct call
    detail2::run([&]() { a.a5(); });

    return a
        .a1()
        // Call to a template method accepting a callable with lambda expression
        // as argument, fully tracked showing method's activity and
        .and_then([&](auto &&arg) { return a.a2(arg); })
        // TODO: Call to a method accepting a callable with function pointer
        //       as argument
        .and_then(a3)
        // TODO: Call to a method accepting a callable with std::function as
        //       argument
        .and_then(a4_wrapper_to_a)
        .value();
}
}
}
```
## Generated PlantUML diagrams
![t20044_sequence](./t20044_sequence.svg "Test case for template method call expressions with callables")
## Generated Mermaid diagrams
![t20044_sequence](./t20044_sequence_mermaid.svg "Test case for template method call expressions with callables")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20044_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20044::tmain()",
      "id": "2023105985551477155",
      "name": "tmain",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 5,
        "file": "t20044.cc",
        "line": 68,
        "translation_unit": "t20044.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "R((lambda at t20044.cc:74:9) &&)",
          "full_name": "clanguml::t20044::R::R((lambda at t20044.cc:74:9) &&)",
          "id": "16975594751449851498",
          "name": "R",
          "namespace": "clanguml::t20044",
          "source_location": {
            "column": 27,
            "file": "t20044.cc",
            "line": 65,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "R",
      "full_name": "clanguml::t20044::R",
      "id": "12448889180791486772",
      "name": "R",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 8,
        "file": "t20044.cc",
        "line": 64,
        "translation_unit": "t20044.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:74:9)::operator()() const",
          "id": "6546857217762918655",
          "name": "operator()",
          "namespace": "clanguml::t20044::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20044.cc:74:9)",
      "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:74:9)",
      "id": "5849344068183933696",
      "name": "tmain()::(lambda t20044.cc:74:9)",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 9,
        "file": "t20044.cc",
        "line": 74,
        "translation_unit": "t20044.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "a() const",
          "full_name": "clanguml::t20044::A::a() const",
          "id": "6831600594577796197",
          "name": "a",
          "namespace": "clanguml::t20044",
          "source_location": {
            "column": 10,
            "file": "t20044.cc",
            "line": 51,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a5()",
          "full_name": "clanguml::t20044::A::a5()",
          "id": "13949529316163085262",
          "name": "a5",
          "namespace": "clanguml::t20044",
          "source_location": {
            "column": 10,
            "file": "t20044.cc",
            "line": 59,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a1() const",
          "full_name": "clanguml::t20044::A::a1() const",
          "id": "5611193800300214809",
          "name": "a1",
          "namespace": "clanguml::t20044",
          "source_location": {
            "column": 10,
            "file": "t20044.cc",
            "line": 53,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "a2(int) const",
          "full_name": "clanguml::t20044::A::a2(int) const",
          "id": "681156560065952195",
          "name": "a2",
          "namespace": "clanguml::t20044",
          "source_location": {
            "column": 10,
            "file": "t20044.cc",
            "line": 55,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20044::A",
      "id": "8212924942624665062",
      "name": "A",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 8,
        "file": "t20044.cc",
        "line": 50,
        "translation_unit": "t20044.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:84:18)::operator()() const",
          "id": "3488770978421009441",
          "name": "operator()",
          "namespace": "clanguml::t20044::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20044.cc:84:18)",
      "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:84:18)",
      "id": "11701116504605393532",
      "name": "tmain()::(lambda t20044.cc:84:18)",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 18,
        "file": "t20044.cc",
        "line": 84,
        "translation_unit": "t20044.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "expected(int)",
          "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>::expected(int)",
          "id": "12315729204979881038",
          "name": "expected",
          "namespace": "clanguml::t20044::detail::expected<int, clanguml::t20044",
          "source_location": {
            "column": 14,
            "file": "t20044.cc",
            "line": 21,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "and_then((lambda at t20044.cc:90:19) &&)",
          "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>::and_then((lambda at t20044.cc:90:19) &&)",
          "id": "3016587988242138783",
          "name": "and_then",
          "namespace": "clanguml::t20044::detail::expected<int, clanguml::t20044",
          "source_location": {
            "column": 29,
            "file": "t20044.cc",
            "line": 34,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "and_then(result_t (&)(int))",
          "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>::and_then(result_t (&)(int))",
          "id": "15799134065214219790",
          "name": "and_then",
          "namespace": "clanguml::t20044::detail::expected<int, clanguml::t20044",
          "source_location": {
            "column": 29,
            "file": "t20044.cc",
            "line": 34,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "and_then(std::function<result_t (int)> &)",
          "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>::and_then(std::function<result_t (int)> &)",
          "id": "9828960440669252853",
          "name": "and_then",
          "namespace": "clanguml::t20044::detail::expected<int, clanguml::t20044",
          "source_location": {
            "column": 29,
            "file": "t20044.cc",
            "line": 34,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        },
        {
          "display_name": "value() const",
          "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>::value() const",
          "id": "7638437815753644849",
          "name": "value",
          "namespace": "clanguml::t20044::detail::expected<int, clanguml::t20044",
          "source_location": {
            "column": 17,
            "file": "t20044.cc",
            "line": 30,
            "translation_unit": "t20044.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "result_t",
      "full_name": "clanguml::t20044::detail::expected<int,clanguml::t20044::error>",
      "id": "878411414184481802",
      "name": "expected",
      "namespace": "clanguml::t20044::detail",
      "source_location": {
        "column": 41,
        "file": "t20044.cc",
        "line": 15,
        "translation_unit": "t20044.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto &&) const",
          "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:90:19)::operator()(auto &&) const",
          "id": "14144849039208834774",
          "name": "operator()",
          "namespace": "clanguml::t20044::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20044.cc:90:19)",
      "full_name": "clanguml::t20044::tmain()::(lambda t20044.cc:90:19)",
      "id": "7434526094294639429",
      "name": "tmain()::(lambda t20044.cc:90:19)",
      "namespace": "clanguml::t20044",
      "source_location": {
        "column": 19,
        "file": "t20044.cc",
        "line": 90,
        "translation_unit": "t20044.cc"
      },
      "type": "lambda"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "R((lambda at t20044.cc:74:9) &&)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 7,
            "file": "t20044.cc",
            "line": 74,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "16975594751449851498",
            "participant_id": "12448889180791486772"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16975594751449851498",
            "participant_id": "12448889180791486772"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 38,
            "file": "t20044.cc",
            "line": 65,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "6546857217762918655",
            "participant_id": "5849344068183933696"
          },
          "type": "message"
        },
        {
          "comment": "Call to template constructor with callable parameter and lambda\nexpression as argument",
          "from": {
            "activity_id": "6546857217762918655",
            "participant_id": "5849344068183933696"
          },
          "name": "a() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20044.cc",
            "line": 74,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "6831600594577796197",
            "participant_id": "8212924942624665062"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20044.cc",
            "line": 84,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "3488770978421009441",
            "participant_id": "11701116504605393532"
          },
          "type": "message"
        },
        {
          "comment": "The message to detail2::run() is skipped due to exclude filter, however\nthe call to lambda and A::a5() is rendered\nTODO: Add some marker to highlight that this is not a direct call",
          "from": {
            "activity_id": "3488770978421009441",
            "participant_id": "11701116504605393532"
          },
          "name": "a5()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20044.cc",
            "line": 84,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "13949529316163085262",
            "participant_id": "8212924942624665062"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "a1() const",
          "return_type": "result_t",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20044.cc",
            "line": 86,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "5611193800300214809",
            "participant_id": "8212924942624665062"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5611193800300214809",
            "participant_id": "8212924942624665062"
          },
          "name": "expected(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 30,
            "file": "t20044.cc",
            "line": 53,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "12315729204979881038",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "and_then((lambda at t20044.cc:90:19) &&)",
          "return_type": "result_t",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20044.cc",
            "line": 86,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "3016587988242138783",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        },
        {
          "activity_id": "3016587988242138783",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "3016587988242138783",
                    "participant_id": "878411414184481802"
                  },
                  "name": "operator()(auto &&) const",
                  "return_type": "auto",
                  "scope": "normal",
                  "source_location": {
                    "column": 20,
                    "file": "t20044.cc",
                    "line": 37,
                    "translation_unit": "t20044.cc"
                  },
                  "to": {
                    "activity_id": "14144849039208834774",
                    "participant_id": "7434526094294639429"
                  },
                  "type": "message"
                },
                {
                  "comment": "Call to a template method accepting a callable with lambda expression\nas argument, fully tracked showing method's activity and",
                  "from": {
                    "activity_id": "14144849039208834774",
                    "participant_id": "7434526094294639429"
                  },
                  "name": "a2(int) const",
                  "return_type": "result_t",
                  "scope": "normal",
                  "source_location": {
                    "column": 44,
                    "file": "t20044.cc",
                    "line": 90,
                    "translation_unit": "t20044.cc"
                  },
                  "to": {
                    "activity_id": "681156560065952195",
                    "participant_id": "8212924942624665062"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "681156560065952195",
                    "participant_id": "8212924942624665062"
                  },
                  "name": "expected(int)",
                  "return_type": "void",
                  "scope": "normal",
                  "source_location": {
                    "column": 37,
                    "file": "t20044.cc",
                    "line": 55,
                    "translation_unit": "t20044.cc"
                  },
                  "to": {
                    "activity_id": "12315729204979881038",
                    "participant_id": "878411414184481802"
                  },
                  "type": "message"
                }
              ],
              "type": "consequent"
            }
          ],
          "name": "if",
          "type": "alt"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "operator()(auto &&) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 19,
            "file": "t20044.cc",
            "line": 90,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "14144849039208834774",
            "participant_id": "7434526094294639429"
          },
          "type": "message"
        },
        {
          "comment": "Call to a template method accepting a callable with lambda expression\nas argument, fully tracked showing method's activity and",
          "from": {
            "activity_id": "14144849039208834774",
            "participant_id": "7434526094294639429"
          },
          "name": "a2(int) const",
          "return_type": "result_t",
          "scope": "normal",
          "source_location": {
            "column": 44,
            "file": "t20044.cc",
            "line": 90,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "681156560065952195",
            "participant_id": "8212924942624665062"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "681156560065952195",
            "participant_id": "8212924942624665062"
          },
          "name": "expected(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 37,
            "file": "t20044.cc",
            "line": 55,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "12315729204979881038",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "and_then(result_t (&)(int))",
          "return_type": "result_t",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20044.cc",
            "line": 86,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "15799134065214219790",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "and_then(std::function<result_t (int)> &)",
          "return_type": "result_t",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20044.cc",
            "line": 86,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "9828960440669252853",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2023105985551477155",
            "participant_id": "2023105985551477155"
          },
          "name": "value() const",
          "return_type": "int const &",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20044.cc",
            "line": 86,
            "translation_unit": "t20044.cc"
          },
          "to": {
            "activity_id": "7638437815753644849",
            "participant_id": "878411414184481802"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "2023105985551477155",
        "location": "clanguml::t20044::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20044"
}
```
## Generated GraphML models
