# t20043 - Test case for elements diagram filter in sequence diagrams
## Config
```yaml
diagrams:
  t20043_sequence:
    type: sequence
    glob:
      - t20043.cc
    include:
      namespaces:
        - clanguml::t20043
    exclude:
      elements:
        - clanguml::t20043::B
        - clanguml::t20043::F
        - type: method
          name: clanguml::t20043::C::log_c
      namespaces:
        - clanguml::t20043::detail
    using_namespace: clanguml::t20043
    from:
      - function: "clanguml::t20043::tmain()"

```
## Source code
File `tests/t20043/t20043.cc`
```cpp
namespace clanguml {
namespace t20043 {
struct A {
    int a() { return a_impl(); }

    int a_impl() { return 1; }
};

struct B {
    A a;
    int b() { return a.a(); }
};

struct C {
    B b;
    int c()
    {
        log_c();
        return b.b();
    }

    void log_c() { }
};

namespace detail {
struct E {
    void e() { }
};
} // namespace detail

struct D {
    C c;
    detail::E e;
    int d()
    {
        e.e();
        return c.c();
    }
};

struct F {
    void f() { }
};

int tmain()
{
    D d;
    F f;

    f.f();

    return d.d();
}
}
}
```
## Generated PlantUML diagrams
![t20043_sequence](./t20043_sequence.svg "Test case for elements diagram filter in sequence diagrams")
## Generated Mermaid diagrams
![t20043_sequence](./t20043_sequence_mermaid.svg "Test case for elements diagram filter in sequence diagrams")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20043_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20043::tmain()",
      "id": "11169474700813432371",
      "name": "tmain",
      "namespace": "clanguml::t20043",
      "source_location": {
        "column": 5,
        "file": "t20043.cc",
        "line": 45,
        "translation_unit": "t20043.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "d()",
          "full_name": "clanguml::t20043::D::d()",
          "id": "483035147691830839",
          "name": "d",
          "namespace": "clanguml::t20043",
          "source_location": {
            "column": 9,
            "file": "t20043.cc",
            "line": 34,
            "translation_unit": "t20043.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D",
      "full_name": "clanguml::t20043::D",
      "id": "13056394004409510818",
      "name": "D",
      "namespace": "clanguml::t20043",
      "source_location": {
        "column": 8,
        "file": "t20043.cc",
        "line": 31,
        "translation_unit": "t20043.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "c()",
          "full_name": "clanguml::t20043::C::c()",
          "id": "7990950214723894643",
          "name": "c",
          "namespace": "clanguml::t20043",
          "source_location": {
            "column": 9,
            "file": "t20043.cc",
            "line": 16,
            "translation_unit": "t20043.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20043::C",
      "id": "4843108968407770439",
      "name": "C",
      "namespace": "clanguml::t20043",
      "source_location": {
        "column": 8,
        "file": "t20043.cc",
        "line": 14,
        "translation_unit": "t20043.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "11169474700813432371",
            "participant_id": "11169474700813432371"
          },
          "name": "d()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20043.cc",
            "line": 52,
            "translation_unit": "t20043.cc"
          },
          "to": {
            "activity_id": "483035147691830839",
            "participant_id": "13056394004409510818"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "483035147691830839",
            "participant_id": "13056394004409510818"
          },
          "name": "c()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20043.cc",
            "line": 37,
            "translation_unit": "t20043.cc"
          },
          "to": {
            "activity_id": "7990950214723894643",
            "participant_id": "4843108968407770439"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "11169474700813432371",
        "location": "clanguml::t20043::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20043"
}
```
## Generated GraphML models
