# t20040 - Test case for recursive variadic template function call
## Config
```yaml
diagrams:
  t20040_sequence:
    type: sequence
    glob:
      - t20040.cc
    include:
      namespaces:
        - clanguml::t20040
    using_namespace: clanguml::t20040
    from:
      - function: "clanguml::t20040::tmain()"
```
## Source code
File `tests/t20040/t20040.cc`
```cpp
#include <iostream>
#include <string>

namespace clanguml {
namespace t20040 {
void print() { }

template <typename T, typename... Ts> void print(T head, Ts... tail)
{
    std::cout << head << std::endl;
    print(tail...);
}

template <typename... Ts> void doublePrint(Ts... args)
{
    print(args + args...);
}

void tmain()
{
    using namespace std::literals::string_literals;

    print(1, 3.14, "test"s);

    doublePrint("test"s, 2024 / 2);
}
}
}
```
## Generated PlantUML diagrams
![t20040_sequence](./t20040_sequence.svg "Test case for recursive variadic template function call")
## Generated Mermaid diagrams
![t20040_sequence](./t20040_sequence_mermaid.svg "Test case for recursive variadic template function call")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20040_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20040::tmain()",
      "id": "7988980481179677306",
      "name": "tmain",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 6,
        "file": "t20040.cc",
        "line": 19,
        "translation_unit": "t20040.cc"
      },
      "type": "function"
    },
    {
      "display_name": "print<int,double,std::string>(int,double,std::string)",
      "full_name": "clanguml::t20040::print<int,double,std::string>(int,double,std::basic_string<char>)",
      "id": "3734770894352194386",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<double,std::string>(double,std::string)",
      "full_name": "clanguml::t20040::print<double,std::string>(double,std::basic_string<char>)",
      "id": "11101453699051872291",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<std::string>(std::string)",
      "full_name": "clanguml::t20040::print<std::string>(std::basic_string<char>)",
      "id": "10831414938278574793",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print()",
      "full_name": "clanguml::t20040::print()",
      "id": "1963347511152581998",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 6,
        "file": "t20040.cc",
        "line": 6,
        "translation_unit": "t20040.cc"
      },
      "type": "function"
    },
    {
      "display_name": "doublePrint<std::string,int>(std::string,int)",
      "full_name": "clanguml::t20040::doublePrint<std::string,int>(std::basic_string<char>,int)",
      "id": "16193011244418762811",
      "name": "doublePrint",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 32,
        "file": "t20040.cc",
        "line": 14,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<std::string,int>(std::string,int)",
      "full_name": "clanguml::t20040::print<std::string,int>(std::basic_string<char>,int)",
      "id": "10799969470314580850",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    },
    {
      "display_name": "print<int>(int)",
      "full_name": "clanguml::t20040::print<int>(int)",
      "id": "9515419718316191441",
      "name": "print",
      "namespace": "clanguml::t20040",
      "source_location": {
        "column": 44,
        "file": "t20040.cc",
        "line": 8,
        "translation_unit": "t20040.cc"
      },
      "type": "function_template"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "7988980481179677306",
            "participant_id": "7988980481179677306"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 23,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "3734770894352194386",
            "participant_id": "3734770894352194386"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "3734770894352194386",
            "participant_id": "3734770894352194386"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "11101453699051872291",
            "participant_id": "11101453699051872291"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "11101453699051872291",
            "participant_id": "11101453699051872291"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "10831414938278574793",
            "participant_id": "10831414938278574793"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10831414938278574793",
            "participant_id": "10831414938278574793"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "1963347511152581998",
            "participant_id": "1963347511152581998"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7988980481179677306",
            "participant_id": "7988980481179677306"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 25,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "16193011244418762811",
            "participant_id": "16193011244418762811"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16193011244418762811",
            "participant_id": "16193011244418762811"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 16,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "10799969470314580850",
            "participant_id": "10799969470314580850"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "10799969470314580850",
            "participant_id": "10799969470314580850"
          },
          "name": "",
          "return_type": "",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "9515419718316191441",
            "participant_id": "9515419718316191441"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "9515419718316191441",
            "participant_id": "9515419718316191441"
          },
          "name": "",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20040.cc",
            "line": 11,
            "translation_unit": "t20040.cc"
          },
          "to": {
            "activity_id": "1963347511152581998",
            "participant_id": "1963347511152581998"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "7988980481179677306",
        "location": "clanguml::t20040::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20040"
}
```
## Generated GraphML models
