# t20039 - Test case for type aliases config option in sequence diagrams
## Config
```yaml
diagrams:
  t20039_sequence:
    type: sequence
    glob:
      - t20039.cc
    include:
      namespaces:
        - clanguml::t20039
    using_namespace: clanguml::t20039
    type_aliases:
      "std::vector<int>": int_vec_t
      "std::vector<std::string>": string_vec_t
      "std::map<int,int>": int_map_t
      "std::map<std::string,std::string>": string_map_t
    from:
      - function: "clanguml::t20039::tmain()"
```
## Source code
File `tests/t20039/t20039.cc`
```cpp
#include <map>
#include <string>
#include <vector>

namespace clanguml {
namespace t20039 {

template <typename T> struct A {
    std::vector<std::vector<T>> a(T p) { return {}; }
};

struct R {
    A<int> a_int;
    A<std::vector<int>> a_intvec;
    A<std::vector<std::string>> a_stringvec;
    A<std::map<int, int>> a_intmap;
    A<std::map<std::string, std::string>> a_stringmap;

    void run()
    {
        a_int.a({});
        a_intvec.a({});
        a_stringvec.a({});
        a_intmap.a({});
        a_stringmap.a({});
    }
};

int tmain()
{
    R r;

    r.run();

    return 0;
}
}
}
```
## Generated PlantUML diagrams
![t20039_sequence](./t20039_sequence.svg "Test case for type aliases config option in sequence diagrams")
## Generated Mermaid diagrams
![t20039_sequence](./t20039_sequence_mermaid.svg "Test case for type aliases config option in sequence diagrams")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20039_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20039::tmain()",
      "id": "17187612874208084846",
      "name": "tmain",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 5,
        "file": "t20039.cc",
        "line": 29,
        "translation_unit": "t20039.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "run()",
          "full_name": "clanguml::t20039::R::run()",
          "id": "5944767038086841495",
          "name": "run",
          "namespace": "clanguml::t20039",
          "source_location": {
            "column": 10,
            "file": "t20039.cc",
            "line": 19,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "R",
      "full_name": "clanguml::t20039::R",
      "id": "7292081895286883155",
      "name": "R",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 8,
        "file": "t20039.cc",
        "line": 12,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(int)",
          "full_name": "clanguml::t20039::A<int>::a(int)",
          "id": "13354267049642024843",
          "name": "a",
          "namespace": "clanguml::t20039",
          "source_location": {
            "column": 33,
            "file": "t20039.cc",
            "line": 9,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<int>",
      "full_name": "clanguml::t20039::A<int>",
      "id": "15273923056068952633",
      "name": "A",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 30,
        "file": "t20039.cc",
        "line": 8,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(int_vec_t)",
          "full_name": "clanguml::t20039::A<int_vec_t>::a(int_vec_t)",
          "id": "816347095678971446",
          "name": "a",
          "namespace": "clanguml::t20039::A<std",
          "source_location": {
            "column": 33,
            "file": "t20039.cc",
            "line": 9,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<int_vec_t>",
      "full_name": "clanguml::t20039::A<int_vec_t>",
      "id": "16357712652138424637",
      "name": "A",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 30,
        "file": "t20039.cc",
        "line": 8,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(string_vec_t)",
          "full_name": "clanguml::t20039::A<string_vec_t>::a(string_vec_t)",
          "id": "7019007324169913734",
          "name": "a",
          "namespace": "clanguml::t20039::A<std::vector<std",
          "source_location": {
            "column": 33,
            "file": "t20039.cc",
            "line": 9,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<string_vec_t>",
      "full_name": "clanguml::t20039::A<string_vec_t>",
      "id": "7883373394105116761",
      "name": "A",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 30,
        "file": "t20039.cc",
        "line": 8,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(int_map_t)",
          "full_name": "clanguml::t20039::A<int_map_t>::a(int_map_t)",
          "id": "5763144071885908438",
          "name": "a",
          "namespace": "clanguml::t20039::A<std",
          "source_location": {
            "column": 33,
            "file": "t20039.cc",
            "line": 9,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<int_map_t>",
      "full_name": "clanguml::t20039::A<int_map_t>",
      "id": "12619487753100347345",
      "name": "A",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 30,
        "file": "t20039.cc",
        "line": 8,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a(string_map_t)",
          "full_name": "clanguml::t20039::A<string_map_t>::a(string_map_t)",
          "id": "9829494101227432821",
          "name": "a",
          "namespace": "clanguml::t20039::A<std::map<std::basic_string<char>, std",
          "source_location": {
            "column": 33,
            "file": "t20039.cc",
            "line": 9,
            "translation_unit": "t20039.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A<string_map_t>",
      "full_name": "clanguml::t20039::A<string_map_t>",
      "id": "11285344904684039703",
      "name": "A",
      "namespace": "clanguml::t20039",
      "source_location": {
        "column": 30,
        "file": "t20039.cc",
        "line": 8,
        "translation_unit": "t20039.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "17187612874208084846",
            "participant_id": "17187612874208084846"
          },
          "name": "run()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20039.cc",
            "line": 33,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "name": "a(int)",
          "return_type": "std::vector<int_vec_t>",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20039.cc",
            "line": 21,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "13354267049642024843",
            "participant_id": "15273923056068952633"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "name": "a(int_vec_t)",
          "return_type": "std::vector<std::vector<vector<int,allocator<int>>>>",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20039.cc",
            "line": 22,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "816347095678971446",
            "participant_id": "16357712652138424637"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "name": "a(string_vec_t)",
          "return_type": "std::vector<std::vector<vector<basic_string<char,char_traits<char>,allocator<char>>,allocator<basic_string<char,char_traits<char>,allocator<char>>>>>>",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20039.cc",
            "line": 23,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "7019007324169913734",
            "participant_id": "7883373394105116761"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "name": "a(int_map_t)",
          "return_type": "std::vector<std::vector<map<int,int,less<int>,allocator<pair<const int,int>>>>>",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20039.cc",
            "line": 24,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "5763144071885908438",
            "participant_id": "12619487753100347345"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5944767038086841495",
            "participant_id": "7292081895286883155"
          },
          "name": "a(string_map_t)",
          "return_type": "std::vector<std::vector<map<basic_string<char,char_traits<char>,allocator<char>>,basic_string<char,char_traits<char>,allocator<char>>,less<basic_string<char,char_traits<char>,allocator<char>>>,allocator<pair<const basic_string<char,char_traits<char>,allocator<char>>,basic_string<char,char_traits<char>,allocator<char>>>>>>>",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20039.cc",
            "line": 25,
            "translation_unit": "t20039.cc"
          },
          "to": {
            "activity_id": "9829494101227432821",
            "participant_id": "11285344904684039703"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "17187612874208084846",
        "location": "clanguml::t20039::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20039"
}
```
## Generated GraphML models
