# t20037 - Test case checking if activities in static variable declarations appear only once
## Config
```yaml
diagrams:
  t20037_sequence:
    type: sequence
    glob:
      - t20037.cc
    include:
      namespaces:
        - clanguml::t20037
    using_namespace: clanguml::t20037
    from:
      - function: "clanguml::t20037::tmain(int,char **)"
```
## Source code
File `tests/t20037/t20037.cc`
```cpp
namespace clanguml {
namespace t20037 {

struct A {
    A()
        : a{100}
    {
    }

    int a;
};

struct B {
    int get() { return b; }

    int b{100};
};

B initb() { return B{}; }

int c() { return 1; }

int a()
{
    static A a;
    static B b = initb();

    return a.a + b.get() + c();
}

void tmain(int argc, char **argv)
{
    auto a1 = a();
    auto a2 = a();
    auto a3 = a();
}
}
}
```
## Generated PlantUML diagrams
![t20037_sequence](./t20037_sequence.svg "Test case checking if activities in static variable declarations appear only once")
## Generated Mermaid diagrams
![t20037_sequence](./t20037_sequence_mermaid.svg "Test case checking if activities in static variable declarations appear only once")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20037_sequence",
  "participants": [
    {
      "display_name": "tmain(int,char **)",
      "full_name": "clanguml::t20037::tmain(int,char **)",
      "id": "13413211722192705187",
      "name": "tmain",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 6,
        "file": "t20037.cc",
        "line": 31,
        "translation_unit": "t20037.cc"
      },
      "type": "function"
    },
    {
      "display_name": "a()",
      "full_name": "clanguml::t20037::a()",
      "id": "1203687334801318447",
      "name": "a",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 5,
        "file": "t20037.cc",
        "line": 23,
        "translation_unit": "t20037.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "A()",
          "full_name": "clanguml::t20037::A::A()",
          "id": "9083609533415107973",
          "name": "A",
          "namespace": "clanguml::t20037",
          "source_location": {
            "column": 5,
            "file": "t20037.cc",
            "line": 5,
            "translation_unit": "t20037.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20037::A",
      "id": "10639366593244240647",
      "name": "A",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 8,
        "file": "t20037.cc",
        "line": 4,
        "translation_unit": "t20037.cc"
      },
      "type": "class"
    },
    {
      "display_name": "initb()",
      "full_name": "clanguml::t20037::initb()",
      "id": "10426119575314042616",
      "name": "initb",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 3,
        "file": "t20037.cc",
        "line": 19,
        "translation_unit": "t20037.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "get()",
          "full_name": "clanguml::t20037::B::get()",
          "id": "863023265740305101",
          "name": "get",
          "namespace": "clanguml::t20037",
          "source_location": {
            "column": 9,
            "file": "t20037.cc",
            "line": 14,
            "translation_unit": "t20037.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20037::B",
      "id": "13975206764227304997",
      "name": "B",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 8,
        "file": "t20037.cc",
        "line": 13,
        "translation_unit": "t20037.cc"
      },
      "type": "class"
    },
    {
      "display_name": "c()",
      "full_name": "clanguml::t20037::c()",
      "id": "10799938895430276666",
      "name": "c",
      "namespace": "clanguml::t20037",
      "source_location": {
        "column": 5,
        "file": "t20037.cc",
        "line": 21,
        "translation_unit": "t20037.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "13413211722192705187",
            "participant_id": "13413211722192705187"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20037.cc",
            "line": 33,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "A()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 14,
            "file": "t20037.cc",
            "line": 25,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "9083609533415107973",
            "participant_id": "10639366593244240647"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "",
          "return_type": "B",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20037.cc",
            "line": 26,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "10426119575314042616",
            "participant_id": "10426119575314042616"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "get()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "863023265740305101",
            "participant_id": "13975206764227304997"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 28,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "10799938895430276666",
            "participant_id": "10799938895430276666"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13413211722192705187",
            "participant_id": "13413211722192705187"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20037.cc",
            "line": 34,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "get()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "863023265740305101",
            "participant_id": "13975206764227304997"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 28,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "10799938895430276666",
            "participant_id": "10799938895430276666"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13413211722192705187",
            "participant_id": "13413211722192705187"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 15,
            "file": "t20037.cc",
            "line": 35,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "get()",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "863023265740305101",
            "participant_id": "13975206764227304997"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "1203687334801318447",
            "participant_id": "1203687334801318447"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 28,
            "file": "t20037.cc",
            "line": 28,
            "translation_unit": "t20037.cc"
          },
          "to": {
            "activity_id": "10799938895430276666",
            "participant_id": "10799938895430276666"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "13413211722192705187",
        "location": "clanguml::t20037::tmain(int,char **)"
      }
    }
  ],
  "using_namespace": "clanguml::t20037"
}
```
## Generated GraphML models
