# t20036 - Test case for rendering all call chains leading to an activity (to)
## Config
```yaml
diagrams:
  t20036_sequence:
    type: sequence
    glob:
      - t20036.cc
    include:
      namespaces:
        - clanguml::t20036
    using_namespace: clanguml::t20036
    to:
      - function: "clanguml::t20036::A::a2()"
```
## Source code
File `tests/t20036/t20036.cc`
```cpp
#include <cstdint>

namespace clanguml {
namespace t20036 {
struct A {
    void a1() { }
    void a2() { }
    void a3() { }
};

struct B {
    void b1() { a.a2(); }
    void b2() { a.a2(); }
    void b3() { a.a3(); }

    A a;
};

struct C {
    void c1() { b.b1(); }
    void c2() { b.b2(); }
    void c3()
    {
        if (reinterpret_cast<uint64_t>(&b) == 0xbadc0de)
            c3();
        else
            c2();
    }

    void c4() { b.b2(); }

    B b;
};

struct D {
    void d1() { c.c2(); }
    void d2() { c.c2(); }
    void d3() { a.a2(); }

    A a;
    C c;
};
}
}
```
## Generated PlantUML diagrams
![t20036_sequence](./t20036_sequence.svg "Test case for rendering all call chains leading to an activity (to)")
## Generated Mermaid diagrams
![t20036_sequence](./t20036_sequence_mermaid.svg "Test case for rendering all call chains leading to an activity (to)")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20036_sequence",
  "participants": [
    {
      "activities": [
        {
          "display_name": "c1()",
          "full_name": "clanguml::t20036::C::c1()",
          "id": "13940061887190426992",
          "name": "c1",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 20,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c2()",
          "full_name": "clanguml::t20036::C::c2()",
          "id": "1029961534491024303",
          "name": "c2",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 21,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c4()",
          "full_name": "clanguml::t20036::C::c4()",
          "id": "13886718133743786177",
          "name": "c4",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 30,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c3()",
          "full_name": "clanguml::t20036::C::c3()",
          "id": "12188250976098359876",
          "name": "c3",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 22,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20036::C",
      "id": "4715669600005893642",
      "name": "C",
      "namespace": "clanguml::t20036",
      "source_location": {
        "column": 8,
        "file": "t20036.cc",
        "line": 19,
        "translation_unit": "t20036.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b1()",
          "full_name": "clanguml::t20036::B::b1()",
          "id": "1629287607216422771",
          "name": "b1",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 12,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b2()",
          "full_name": "clanguml::t20036::B::b2()",
          "id": "13808756643647507988",
          "name": "b2",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 13,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20036::B",
      "id": "4857180858311218405",
      "name": "B",
      "namespace": "clanguml::t20036",
      "source_location": {
        "column": 8,
        "file": "t20036.cc",
        "line": 11,
        "translation_unit": "t20036.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a2()",
          "full_name": "clanguml::t20036::A::a2()",
          "id": "16992593828115510908",
          "name": "a2",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 7,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20036::A",
      "id": "3197777734785714296",
      "name": "A",
      "namespace": "clanguml::t20036",
      "source_location": {
        "column": 8,
        "file": "t20036.cc",
        "line": 5,
        "translation_unit": "t20036.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "d1()",
          "full_name": "clanguml::t20036::D::d1()",
          "id": "5611911004904119444",
          "name": "d1",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 36,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "d3()",
          "full_name": "clanguml::t20036::D::d3()",
          "id": "15181188317793464520",
          "name": "d3",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 38,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        },
        {
          "display_name": "d2()",
          "full_name": "clanguml::t20036::D::d2()",
          "id": "12275494239752697631",
          "name": "d2",
          "namespace": "clanguml::t20036",
          "source_location": {
            "column": 10,
            "file": "t20036.cc",
            "line": 37,
            "translation_unit": "t20036.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D",
      "full_name": "clanguml::t20036::D",
      "id": "6779475736916517133",
      "name": "D",
      "namespace": "clanguml::t20036",
      "source_location": {
        "column": 8,
        "file": "t20036.cc",
        "line": 35,
        "translation_unit": "t20036.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "message_chains": [
        {
          "messages": [
            {
              "from": {
                "activity_id": "13940061887190426992",
                "participant_id": "4715669600005893642"
              },
              "name": "b1()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 20,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "1629287607216422771",
                "participant_id": "4857180858311218405"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "1629287607216422771",
                "participant_id": "4857180858311218405"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 12,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "5611911004904119444",
                "participant_id": "6779475736916517133"
              },
              "name": "c2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 36,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 21,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 13,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "15181188317793464520",
                "participant_id": "6779475736916517133"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 38,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13886718133743786177",
                "participant_id": "4715669600005893642"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 30,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 13,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "12188250976098359876",
                "participant_id": "4715669600005893642"
              },
              "name": "c2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 13,
                "file": "t20036.cc",
                "line": 27,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 21,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 13,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "12275494239752697631",
                "participant_id": "6779475736916517133"
              },
              "name": "c2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 37,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "1029961534491024303",
                "participant_id": "4715669600005893642"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 21,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "13808756643647507988",
                "participant_id": "4857180858311218405"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20036.cc",
                "line": 13,
                "translation_unit": "t20036.cc"
              },
              "to": {
                "activity_id": "16992593828115510908",
                "participant_id": "3197777734785714296"
              },
              "type": "message"
            }
          ]
        }
      ],
      "to": {
        "id": "16992593828115510908",
        "location": "clanguml::t20036::A::a2()"
      }
    }
  ],
  "using_namespace": "clanguml::t20036"
}
```
## Generated GraphML models
