# t20034 - Test case for rendering all call chains from one activity to another (from_to)
## Config
```yaml
diagrams:
  t20034_sequence:
    type: sequence
    glob:
      - t20034.cc
    include:
      namespaces:
        - clanguml::t20034
    using_namespace: clanguml::t20034
    from_to:
      - [function: "clanguml::t20034::D::d2()",
         function: "clanguml::t20034::A::a2()"]
```
## Source code
File `tests/t20034/t20034.cc`
```cpp
#include <cstdint>

namespace clanguml {
namespace t20034 {
struct A {
    void a1() { }
    void a2() { }
    void a3() { }
};

struct C;

struct B {
    void b1()
    {
        a.a1();
        a.a2();
    }
    void b2() { a.a2(); }
    void b3() { a.a3(); }
    void b4();

    A a;

    C *c;
};

struct C {
    void c1() { b.b1(); }
    void c2() { b.b2(); }
    void c3()
    {
        if (reinterpret_cast<uint64_t>(&b) == 0xbadc0de)
            c3();
        else
            c2();
    }

    void c4() { b.b4(); }

    B b;
};

struct D {
    void d1() { c.c1(); }
    void d2()
    {
        c.c1();
        a.a2();
        c.c2();
        c.c3();
        a.a2();

        c.c4();

        auto l = [this]() { a.a2(); };
        l();
    }
    void d3() { c.c3(); }

    A a;
    C c;
};

void B::b4()
{
    c->c4();
    b2();
}
}
}
```
## Generated PlantUML diagrams
![t20034_sequence](./t20034_sequence.svg "Test case for rendering all call chains from one activity to another (from_to)")
## Generated Mermaid diagrams
![t20034_sequence](./t20034_sequence_mermaid.svg "Test case for rendering all call chains from one activity to another (from_to)")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20034_sequence",
  "participants": [
    {
      "activities": [
        {
          "display_name": "d2()",
          "full_name": "clanguml::t20034::D::d2()",
          "id": "13660113429811813907",
          "name": "d2",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 46,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D",
      "full_name": "clanguml::t20034::D",
      "id": "2182220202977762083",
      "name": "D",
      "namespace": "clanguml::t20034",
      "source_location": {
        "column": 8,
        "file": "t20034.cc",
        "line": 44,
        "translation_unit": "t20034.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "c2()",
          "full_name": "clanguml::t20034::C::c2()",
          "id": "3783239199856176312",
          "name": "c2",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 30,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c4()",
          "full_name": "clanguml::t20034::C::c4()",
          "id": "3165764275552501026",
          "name": "c4",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 39,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c1()",
          "full_name": "clanguml::t20034::C::c1()",
          "id": "1188244067079669689",
          "name": "c1",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 29,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c3()",
          "full_name": "clanguml::t20034::C::c3()",
          "id": "16935918216300866700",
          "name": "c3",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 31,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20034::C",
      "id": "17230349223078027821",
      "name": "C",
      "namespace": "clanguml::t20034",
      "source_location": {
        "column": 8,
        "file": "t20034.cc",
        "line": 28,
        "translation_unit": "t20034.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b2()",
          "full_name": "clanguml::t20034::B::b2()",
          "id": "8275281504961527352",
          "name": "b2",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 19,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b4()",
          "full_name": "clanguml::t20034::B::b4()",
          "id": "14193242232576810025",
          "name": "b4",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 9,
            "file": "t20034.cc",
            "line": 65,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b1()",
          "full_name": "clanguml::t20034::B::b1()",
          "id": "2319196135872470285",
          "name": "b1",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 14,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20034::B",
      "id": "9719166187115200065",
      "name": "B",
      "namespace": "clanguml::t20034",
      "source_location": {
        "column": 8,
        "file": "t20034.cc",
        "line": 13,
        "translation_unit": "t20034.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "a2()",
          "full_name": "clanguml::t20034::A::a2()",
          "id": "10457510825242923440",
          "name": "a2",
          "namespace": "clanguml::t20034",
          "source_location": {
            "column": 10,
            "file": "t20034.cc",
            "line": 7,
            "translation_unit": "t20034.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20034::A",
      "id": "8235317980508392101",
      "name": "A",
      "namespace": "clanguml::t20034",
      "source_location": {
        "column": 8,
        "file": "t20034.cc",
        "line": 5,
        "translation_unit": "t20034.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20034::D::d2()::(lambda t20034.cc:56:18)::operator()() const",
          "id": "12275451594579367626",
          "name": "operator()",
          "namespace": "clanguml::t20034::D::d2()",
          "type": "method"
        }
      ],
      "display_name": "D::d2()::(lambda t20034.cc:56:18)",
      "full_name": "clanguml::t20034::D::d2()::(lambda t20034.cc:56:18)",
      "id": "8212708396119206013",
      "name": "D::d2()::(lambda t20034.cc:56:18)",
      "namespace": "clanguml::t20034",
      "source_location": {
        "column": 18,
        "file": "t20034.cc",
        "line": 56,
        "translation_unit": "t20034.cc"
      },
      "type": "lambda"
    }
  ],
  "sequences": [
    {
      "from_to": {
        "from": {
          "id": "13660113429811813907",
          "location": "clanguml::t20034::D::d2()"
        },
        "to": {
          "id": "10457510825242923440",
          "location": "clanguml::t20034::A::a2()"
        }
      },
      "message_chains": [
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "c2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 50,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "3783239199856176312",
                "participant_id": "17230349223078027821"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "3783239199856176312",
                "participant_id": "17230349223078027821"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 30,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 19,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "operator()() const",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 57,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "12275451594579367626",
                "participant_id": "8212708396119206013"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "12275451594579367626",
                "participant_id": "8212708396119206013"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 29,
                "file": "t20034.cc",
                "line": 56,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 49,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "c4()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 54,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "3165764275552501026",
                "participant_id": "17230349223078027821"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "3165764275552501026",
                "participant_id": "17230349223078027821"
              },
              "name": "b4()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 39,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "14193242232576810025",
                "participant_id": "9719166187115200065"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "14193242232576810025",
                "participant_id": "9719166187115200065"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 5,
                "file": "t20034.cc",
                "line": 68,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 19,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "c1()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 48,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "1188244067079669689",
                "participant_id": "17230349223078027821"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "1188244067079669689",
                "participant_id": "17230349223078027821"
              },
              "name": "b1()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 29,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "2319196135872470285",
                "participant_id": "9719166187115200065"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "2319196135872470285",
                "participant_id": "9719166187115200065"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 17,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        },
        {
          "messages": [
            {
              "from": {
                "activity_id": "13660113429811813907",
                "participant_id": "2182220202977762083"
              },
              "name": "c3()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 9,
                "file": "t20034.cc",
                "line": 51,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "16935918216300866700",
                "participant_id": "17230349223078027821"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "16935918216300866700",
                "participant_id": "17230349223078027821"
              },
              "name": "c2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 13,
                "file": "t20034.cc",
                "line": 36,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "3783239199856176312",
                "participant_id": "17230349223078027821"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "3783239199856176312",
                "participant_id": "17230349223078027821"
              },
              "name": "b2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 30,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "type": "message"
            },
            {
              "from": {
                "activity_id": "8275281504961527352",
                "participant_id": "9719166187115200065"
              },
              "name": "a2()",
              "return_type": "void",
              "scope": "normal",
              "source_location": {
                "column": 17,
                "file": "t20034.cc",
                "line": 19,
                "translation_unit": "t20034.cc"
              },
              "to": {
                "activity_id": "10457510825242923440",
                "participant_id": "8235317980508392101"
              },
              "type": "message"
            }
          ]
        }
      ]
    }
  ],
  "using_namespace": "clanguml::t20034"
}
```
## Generated GraphML models
