# t20031 - Callee type sequence diagram filter test case
## Config
```yaml
diagrams:
  t20031_sequence:
    type: sequence
    glob:
      - t20031.cc
    include:
      namespaces:
        - clanguml::t20031
    exclude:
      callee_types:
        - constructor
        - operator
        - lambda
    using_namespace: clanguml::t20031
    from:
      - function: "clanguml::t20031::tmain(int)"
      - function: "clanguml::t20031::tmain(bool,int)"
```
## Source code
File `tests/t20031/t20031.cc`
```cpp
#include <functional>

namespace clanguml {
namespace t20031 {
int magic() { return 42; }
int zero() { return 0; }
int one() { return 1; }
int execute(std::function<int()> f) { return f(); }

class A {
public:
    A() { create(); }

    A(int v) { a_ = v; }

    A &operator=(const A &a)
    {
        set(a.a_);
        return *this;
    }

    A &operator+=(int a)
    {
        add(a);
        return *this;
    }

    int value() const { return a_; }

private:
    void create() { a_ = 0; }

    void add(int a) { a_ += a; }
    void set(int a) { a_ = a; }

    int a_;
};

void tmain(int a)
{
    A an_a{magic()};
    an_a += 1;
}

int tmain(bool f, int a)
{
    auto generate_zero = []() { return zero(); };
    auto an_a = A();
    auto an_b = A();

    an_a += generate_zero();

    // @todo #168
    an_a += execute([]() { return one(); });

    an_b = an_a;

    return an_b.value();
};

}
}
```
## Generated PlantUML diagrams
![t20031_sequence](./t20031_sequence.svg "Callee type sequence diagram filter test case")
## Generated Mermaid diagrams
![t20031_sequence](./t20031_sequence_mermaid.svg "Callee type sequence diagram filter test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20031_sequence",
  "participants": [
    {
      "display_name": "tmain(int)",
      "full_name": "clanguml::t20031::tmain(int)",
      "id": "8367788728267433427",
      "name": "tmain",
      "namespace": "clanguml::t20031",
      "source_location": {
        "column": 6,
        "file": "t20031.cc",
        "line": 39,
        "translation_unit": "t20031.cc"
      },
      "type": "function"
    },
    {
      "display_name": "magic()",
      "full_name": "clanguml::t20031::magic()",
      "id": "18126320386407676956",
      "name": "magic",
      "namespace": "clanguml::t20031",
      "source_location": {
        "column": 5,
        "file": "t20031.cc",
        "line": 5,
        "translation_unit": "t20031.cc"
      },
      "type": "function"
    },
    {
      "display_name": "tmain(bool,int)",
      "full_name": "clanguml::t20031::tmain(bool,int)",
      "id": "17518035964114807420",
      "name": "tmain",
      "namespace": "clanguml::t20031",
      "source_location": {
        "column": 5,
        "file": "t20031.cc",
        "line": 45,
        "translation_unit": "t20031.cc"
      },
      "type": "function"
    },
    {
      "display_name": "execute(std::function<int ()>)",
      "full_name": "clanguml::t20031::execute(std::function<int ()>)",
      "id": "17841283367270660784",
      "name": "execute",
      "namespace": "clanguml::t20031",
      "source_location": {
        "column": 5,
        "file": "t20031.cc",
        "line": 8,
        "translation_unit": "t20031.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "value() const",
          "full_name": "clanguml::t20031::A::value() const",
          "id": "8714227449246538789",
          "name": "value",
          "namespace": "clanguml::t20031",
          "source_location": {
            "column": 9,
            "file": "t20031.cc",
            "line": 28,
            "translation_unit": "t20031.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20031::A",
      "id": "8652640421006203232",
      "name": "A",
      "namespace": "clanguml::t20031",
      "source_location": {
        "column": 7,
        "file": "t20031.cc",
        "line": 10,
        "translation_unit": "t20031.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "8367788728267433427",
            "participant_id": "8367788728267433427"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20031.cc",
            "line": 41,
            "translation_unit": "t20031.cc"
          },
          "to": {
            "activity_id": "18126320386407676956",
            "participant_id": "18126320386407676956"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "8367788728267433427",
        "location": "clanguml::t20031::tmain(int)"
      }
    },
    {
      "messages": [
        {
          "from": {
            "activity_id": "17518035964114807420",
            "participant_id": "17518035964114807420"
          },
          "name": "",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 13,
            "file": "t20031.cc",
            "line": 54,
            "translation_unit": "t20031.cc"
          },
          "to": {
            "activity_id": "17841283367270660784",
            "participant_id": "17841283367270660784"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17518035964114807420",
            "participant_id": "17518035964114807420"
          },
          "name": "value() const",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 12,
            "file": "t20031.cc",
            "line": 58,
            "translation_unit": "t20031.cc"
          },
          "to": {
            "activity_id": "8714227449246538789",
            "participant_id": "8652640421006203232"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "17518035964114807420",
        "location": "clanguml::t20031::tmain(bool,int)"
      }
    }
  ],
  "using_namespace": "clanguml::t20031"
}
```
## Generated GraphML models
