# t20029 - Combined feature sequence diagram test case
## Config
```yaml
add_compile_flags:
  - -fparse-all-comments
diagrams:
  t20029_sequence:
    type: sequence
    glob:
      - t20029.cc
    include:
      namespaces:
        - clanguml::t20029
    exclude:
      access:
        - private
    using_namespace: clanguml::t20029
    from:
      - function: clanguml::t20029::tmain()
    generate_message_comments: true
    participants_order:
      - clanguml::t20029::tmain()
      - clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>>
      - clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>
      - clanguml::t20029::ConnectionPool
      - clanguml::t20029::encode_b64(std::string &&)
```
## Source code
File `tests/t20029/t20029.cc`
```cpp
#include <atomic>
#include <functional>
#include <iostream>
#include <memory>
#include <string>

namespace clanguml {
namespace t20029 {
std::string encode_b64(std::string &&content) { return std::move(content); }

template <typename T> class Encoder : public T {
public:
    bool send(std::string &&msg)
    {
        return T::send(std::move(
            // Encode the message using Base64 encoding and pass it to the next
            // layer
            encode(std::move(msg))));
    }

protected:
    std::string encode(std::string &&msg) { return encode_b64(std::move(msg)); }
};

template <typename T> class Retrier : public T {
public:
    bool send(std::string &&msg)
    {
        std::string buffer{std::move(msg)};

        int retryCount = 5;

        // Repeat until send() succeeds or retry count is exceeded
        while (retryCount--) {
            if (T::send(buffer))
                return true;
        }

        return false;
    }
};

class ConnectionPool {
public:
    void connect()
    {
        if (!is_connected_.load())
            connect_impl();
    }

    bool send(const std::string &msg) { return true; }

private:
    void connect_impl() { is_connected_ = true; }

    std::atomic<bool> is_connected_;
};

int tmain()
{
    auto pool = std::make_shared<Encoder<Retrier<ConnectionPool>>>();

    // Establish connection to the remote server synchronously
    pool->connect();

    // Repeat for each line in the input stream
    for (std::string line; std::getline(std::cin, line);) {
        if (!pool->send(std::move(line)))
            break;
    }

    return 0;
}
}
}
```
## Generated PlantUML diagrams
![t20029_sequence](./t20029_sequence.svg "Combined feature sequence diagram test case")
## Generated Mermaid diagrams
![t20029_sequence](./t20029_sequence_mermaid.svg "Combined feature sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20029_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20029::tmain()",
      "id": "16730997910466557141",
      "name": "tmain",
      "namespace": "clanguml::t20029",
      "source_location": {
        "column": 5,
        "file": "t20029.cc",
        "line": 59,
        "translation_unit": "t20029.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "send(std::string &&)",
          "full_name": "clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>>::send(std::string &&)",
          "id": "16214110912047834185",
          "name": "send",
          "namespace": "clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029",
          "source_location": {
            "column": 10,
            "file": "t20029.cc",
            "line": 13,
            "translation_unit": "t20029.cc"
          },
          "type": "method"
        },
        {
          "display_name": "encode(std::string &&)",
          "full_name": "clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>>::encode(std::string &&)",
          "id": "11746066155731846187",
          "name": "encode",
          "namespace": "clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029",
          "source_location": {
            "column": 17,
            "file": "t20029.cc",
            "line": 22,
            "translation_unit": "t20029.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Encoder<Retrier<ConnectionPool>>",
      "full_name": "clanguml::t20029::Encoder<clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>>",
      "id": "13386089566985539066",
      "name": "Encoder",
      "namespace": "clanguml::t20029",
      "source_location": {
        "column": 29,
        "file": "t20029.cc",
        "line": 11,
        "translation_unit": "t20029.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "send(std::string &&)",
          "full_name": "clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>::send(std::string &&)",
          "id": "244127771882890417",
          "name": "send",
          "namespace": "clanguml::t20029::Retrier<clanguml::t20029",
          "source_location": {
            "column": 10,
            "file": "t20029.cc",
            "line": 27,
            "translation_unit": "t20029.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "Retrier<ConnectionPool>",
      "full_name": "clanguml::t20029::Retrier<clanguml::t20029::ConnectionPool>",
      "id": "5264470844727584752",
      "name": "Retrier",
      "namespace": "clanguml::t20029",
      "source_location": {
        "column": 29,
        "file": "t20029.cc",
        "line": 25,
        "translation_unit": "t20029.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "connect()",
          "full_name": "clanguml::t20029::ConnectionPool::connect()",
          "id": "7523428545456836242",
          "name": "connect",
          "namespace": "clanguml::t20029",
          "source_location": {
            "column": 10,
            "file": "t20029.cc",
            "line": 45,
            "translation_unit": "t20029.cc"
          },
          "type": "method"
        },
        {
          "display_name": "send(const std::string &)",
          "full_name": "clanguml::t20029::ConnectionPool::send(const std::string &)",
          "id": "7781007520913353262",
          "name": "send",
          "namespace": "clanguml::t20029",
          "source_location": {
            "column": 10,
            "file": "t20029.cc",
            "line": 51,
            "translation_unit": "t20029.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "ConnectionPool",
      "full_name": "clanguml::t20029::ConnectionPool",
      "id": "15171249640780951499",
      "name": "ConnectionPool",
      "namespace": "clanguml::t20029",
      "source_location": {
        "column": 7,
        "file": "t20029.cc",
        "line": 43,
        "translation_unit": "t20029.cc"
      },
      "type": "class"
    },
    {
      "display_name": "encode_b64(std::string &&)",
      "full_name": "clanguml::t20029::encode_b64(std::string &&)",
      "id": "10901171450087035525",
      "name": "encode_b64",
      "namespace": "clanguml::t20029",
      "source_location": {
        "column": 13,
        "file": "t20029.cc",
        "line": 9,
        "translation_unit": "t20029.cc"
      },
      "type": "function"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "comment": "Establish connection to the remote server synchronously",
          "from": {
            "activity_id": "16730997910466557141",
            "participant_id": "16730997910466557141"
          },
          "name": "connect()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20029.cc",
            "line": 64,
            "translation_unit": "t20029.cc"
          },
          "to": {
            "activity_id": "7523428545456836242",
            "participant_id": "15171249640780951499"
          },
          "type": "message"
        },
        {
          "activity_id": "16730997910466557141",
          "messages": [
            {
              "activity_id": "16730997910466557141",
              "branches": [
                {
                  "messages": [
                    {
                      "from": {
                        "activity_id": "16730997910466557141",
                        "participant_id": "16730997910466557141"
                      },
                      "name": "send(std::string &&)",
                      "return_type": "bool",
                      "scope": "condition",
                      "source_location": {
                        "column": 14,
                        "file": "t20029.cc",
                        "line": 68,
                        "translation_unit": "t20029.cc"
                      },
                      "to": {
                        "activity_id": "16214110912047834185",
                        "participant_id": "13386089566985539066"
                      },
                      "type": "message"
                    },
                    {
                      "comment": "Encode the message using Base64 encoding and pass it to the next\nlayer",
                      "from": {
                        "activity_id": "16214110912047834185",
                        "participant_id": "13386089566985539066"
                      },
                      "name": "encode(std::string &&)",
                      "return_type": "std::string",
                      "scope": "normal",
                      "source_location": {
                        "column": 13,
                        "file": "t20029.cc",
                        "line": 18,
                        "translation_unit": "t20029.cc"
                      },
                      "to": {
                        "activity_id": "11746066155731846187",
                        "participant_id": "13386089566985539066"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "11746066155731846187",
                        "participant_id": "13386089566985539066"
                      },
                      "name": "",
                      "return_type": "std::string",
                      "scope": "normal",
                      "source_location": {
                        "column": 52,
                        "file": "t20029.cc",
                        "line": 22,
                        "translation_unit": "t20029.cc"
                      },
                      "to": {
                        "activity_id": "10901171450087035525",
                        "participant_id": "10901171450087035525"
                      },
                      "type": "message"
                    },
                    {
                      "from": {
                        "activity_id": "16214110912047834185",
                        "participant_id": "13386089566985539066"
                      },
                      "name": "send(std::string &&)",
                      "return_type": "bool",
                      "scope": "normal",
                      "source_location": {
                        "column": 16,
                        "file": "t20029.cc",
                        "line": 15,
                        "translation_unit": "t20029.cc"
                      },
                      "to": {
                        "activity_id": "244127771882890417",
                        "participant_id": "5264470844727584752"
                      },
                      "type": "message"
                    },
                    {
                      "activity_id": "244127771882890417",
                      "messages": [
                        {
                          "activity_id": "244127771882890417",
                          "branches": [
                            {
                              "messages": [
                                {
                                  "from": {
                                    "activity_id": "244127771882890417",
                                    "participant_id": "5264470844727584752"
                                  },
                                  "name": "send(const std::string &)",
                                  "return_type": "bool",
                                  "scope": "condition",
                                  "source_location": {
                                    "column": 17,
                                    "file": "t20029.cc",
                                    "line": 35,
                                    "translation_unit": "t20029.cc"
                                  },
                                  "to": {
                                    "activity_id": "7781007520913353262",
                                    "participant_id": "15171249640780951499"
                                  },
                                  "type": "message"
                                }
                              ],
                              "type": "consequent"
                            }
                          ],
                          "name": "if",
                          "type": "alt"
                        }
                      ],
                      "name": "while",
                      "type": "loop"
                    }
                  ],
                  "type": "consequent"
                }
              ],
              "name": "if",
              "type": "alt"
            }
          ],
          "name": "for",
          "type": "loop"
        }
      ],
      "start_from": {
        "id": "16730997910466557141",
        "location": "clanguml::t20029::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20029"
}
```
## Generated GraphML models
