# t20012 - Lambda expression call sequence diagram test case
## Config
```yaml
diagrams:
  t20012_sequence:
    type: sequence
    glob:
      - t20012.cc
    include:
      namespaces:
        - clanguml::t20012
    using_namespace: clanguml::t20012
    from:
      - function: "clanguml::t20012::tmain()"
```
## Source code
File `tests/t20012/t20012.cc`
```cpp
#include <algorithm>
#include <functional>
#include <memory>
#include <optional>
#include <utility>
#include <vector>

namespace clanguml {
namespace t20012 {
struct A {
    void a() { aa(); }

    void aa() { aaa(); }

    void aaa() { }
};

struct B {
    void b() { bb(); }

    void bb() { bbb(); }

    void bbb() { }

    void eb() { }
};

struct C {
    void c() { cc(); }

    void cc() { ccc(); }

    void ccc() { }
};

struct D {
    int add5(int arg) const { return arg + 5; }
};

class E {
    std::optional<std::shared_ptr<B>> maybe_b;
    std::shared_ptr<A> a;

public:
    template <typename F> void setup(F &&f) { f(maybe_b); }
};

template <typename F> struct R {
    R(F &&f)
        : f_{std::move(f)}
    {
    }

    void r() { f_(); }

    F f_;
};

void tmain()
{
    A a;
    B b;
    C c;

    // The activity shouldn't be marked at the lambda definition, but
    // wherever it is actually called...
    auto alambda = [&a, &b]() {
        a.a();
        b.b();
    };

    // ...like here
    alambda();

    // There should be no call to B in the sequence diagram as the blambda
    // is never called
    [[maybe_unused]] auto blambda = [&b]() { b.b(); };

    // Nested lambdas should also work
    auto clambda = [alambda, &c]() {
        c.c();
        alambda();
    };
    clambda();

    R r{[&c]() { c.c(); }};

    r.r();

    D d;

    std::vector<int> ints{0, 1, 2, 3, 4};
    std::transform(ints.begin(), ints.end(), ints.begin(),
        [&d](auto i) { return d.add5(i); });

    // TODO: Fix naming function call arguments which are lambdas
    //    E e;
    //
    //    e.setup([](auto &&arg) mutable {
    //        // We cannot know here what 'arg' might be
    //        arg.value()->eb();
    //    });
}
}
}

```
## Generated PlantUML diagrams
![t20012_sequence](./t20012_sequence.svg "Lambda expression call sequence diagram test case")
## Generated Mermaid diagrams
![t20012_sequence](./t20012_sequence_mermaid.svg "Lambda expression call sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20012_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20012::tmain()",
      "id": "7149594226225006621",
      "name": "tmain",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 6,
        "file": "t20012.cc",
        "line": 59,
        "translation_unit": "t20012.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:67:20)::operator()() const",
          "id": "6759540437739180205",
          "name": "operator()",
          "namespace": "clanguml::t20012::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20012.cc:67:20)",
      "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:67:20)",
      "id": "14585017180007157378",
      "name": "tmain()::(lambda t20012.cc:67:20)",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 20,
        "file": "t20012.cc",
        "line": 67,
        "translation_unit": "t20012.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "a()",
          "full_name": "clanguml::t20012::A::a()",
          "id": "14971463461955991809",
          "name": "a",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 11,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aa()",
          "full_name": "clanguml::t20012::A::aa()",
          "id": "8807464314831012313",
          "name": "aa",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 13,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "aaa()",
          "full_name": "clanguml::t20012::A::aaa()",
          "id": "7533089486589535184",
          "name": "aaa",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 15,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20012::A",
      "id": "14385473809029856958",
      "name": "A",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 8,
        "file": "t20012.cc",
        "line": 10,
        "translation_unit": "t20012.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "b()",
          "full_name": "clanguml::t20012::B::b()",
          "id": "17141579283082165068",
          "name": "b",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 19,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bb()",
          "full_name": "clanguml::t20012::B::bb()",
          "id": "7789746726279450510",
          "name": "bb",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 21,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "bbb()",
          "full_name": "clanguml::t20012::B::bbb()",
          "id": "1566308232035027228",
          "name": "bbb",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 23,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "B",
      "full_name": "clanguml::t20012::B",
      "id": "15147759194081621226",
      "name": "B",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 8,
        "file": "t20012.cc",
        "line": 18,
        "translation_unit": "t20012.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:80:20)::operator()() const",
          "id": "16646942837642819925",
          "name": "operator()",
          "namespace": "clanguml::t20012::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20012.cc:80:20)",
      "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:80:20)",
      "id": "16826656833296169492",
      "name": "tmain()::(lambda t20012.cc:80:20)",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 20,
        "file": "t20012.cc",
        "line": 80,
        "translation_unit": "t20012.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "c()",
          "full_name": "clanguml::t20012::C::c()",
          "id": "5402955322545804857",
          "name": "c",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 29,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "cc()",
          "full_name": "clanguml::t20012::C::cc()",
          "id": "11614573634522688457",
          "name": "cc",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 31,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "ccc()",
          "full_name": "clanguml::t20012::C::ccc()",
          "id": "15649131270396803681",
          "name": "ccc",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 33,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "C",
      "full_name": "clanguml::t20012::C",
      "id": "16575664974290882098",
      "name": "C",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 8,
        "file": "t20012.cc",
        "line": 28,
        "translation_unit": "t20012.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "R((lambda at t20012.cc:86:9) &&)",
          "full_name": "clanguml::t20012::R<(lambda at t20012.cc:86:9)>::R((lambda at t20012.cc:86:9) &&)",
          "id": "15809459607902663419",
          "name": "R",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 5,
            "file": "t20012.cc",
            "line": 49,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        },
        {
          "display_name": "r()",
          "full_name": "clanguml::t20012::R<(lambda at t20012.cc:86:9)>::r()",
          "id": "13023711539577727870",
          "name": "r",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 10,
            "file": "t20012.cc",
            "line": 54,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "R<(lambda at t20012.cc:86:9)>",
      "full_name": "clanguml::t20012::R<(lambda at t20012.cc:86:9)>",
      "id": "11351025277027321892",
      "name": "R",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 30,
        "file": "t20012.cc",
        "line": 48,
        "translation_unit": "t20012.cc"
      },
      "type": "class"
    },
    {
      "activities": [
        {
          "display_name": "operator()() const",
          "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:86:9)::operator()() const",
          "id": "7980939503032938975",
          "name": "operator()",
          "namespace": "clanguml::t20012::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20012.cc:86:9)",
      "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:86:9)",
      "id": "12185837463070188914",
      "name": "tmain()::(lambda t20012.cc:86:9)",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 9,
        "file": "t20012.cc",
        "line": 86,
        "translation_unit": "t20012.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "operator()(auto) const",
          "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:94:9)::operator()(auto) const",
          "id": "13006452698713945708",
          "name": "operator()",
          "namespace": "clanguml::t20012::tmain()",
          "type": "method"
        }
      ],
      "display_name": "tmain()::(lambda t20012.cc:94:9)",
      "full_name": "clanguml::t20012::tmain()::(lambda t20012.cc:94:9)",
      "id": "12685488174106388182",
      "name": "tmain()::(lambda t20012.cc:94:9)",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 9,
        "file": "t20012.cc",
        "line": 94,
        "translation_unit": "t20012.cc"
      },
      "type": "lambda"
    },
    {
      "activities": [
        {
          "display_name": "add5(int) const",
          "full_name": "clanguml::t20012::D::add5(int) const",
          "id": "3032548472559015070",
          "name": "add5",
          "namespace": "clanguml::t20012",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 37,
            "translation_unit": "t20012.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "D",
      "full_name": "clanguml::t20012::D",
      "id": "13017810609178989903",
      "name": "D",
      "namespace": "clanguml::t20012",
      "source_location": {
        "column": 8,
        "file": "t20012.cc",
        "line": 36,
        "translation_unit": "t20012.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "7149594226225006621",
            "participant_id": "7149594226225006621"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20012.cc",
            "line": 73,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 68,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "14971463461955991809",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14971463461955991809",
            "participant_id": "14385473809029856958"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 11,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "8807464314831012313",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8807464314831012313",
            "participant_id": "14385473809029856958"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 13,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "7533089486589535184",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 69,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "17141579283082165068",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17141579283082165068",
            "participant_id": "15147759194081621226"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 19,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "7789746726279450510",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7789746726279450510",
            "participant_id": "15147759194081621226"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 21,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "1566308232035027228",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7149594226225006621",
            "participant_id": "7149594226225006621"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20012.cc",
            "line": 84,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "16646942837642819925",
            "participant_id": "16826656833296169492"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16646942837642819925",
            "participant_id": "16826656833296169492"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 81,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "5402955322545804857",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5402955322545804857",
            "participant_id": "16575664974290882098"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 29,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "11614573634522688457",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "11614573634522688457",
            "participant_id": "16575664974290882098"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 31,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "15649131270396803681",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "16646942837642819925",
            "participant_id": "16826656833296169492"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 82,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "name": "a()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 68,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "14971463461955991809",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "14971463461955991809",
            "participant_id": "14385473809029856958"
          },
          "name": "aa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 11,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "8807464314831012313",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "8807464314831012313",
            "participant_id": "14385473809029856958"
          },
          "name": "aaa()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 13,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "7533089486589535184",
            "participant_id": "14385473809029856958"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "6759540437739180205",
            "participant_id": "14585017180007157378"
          },
          "name": "b()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 69,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "17141579283082165068",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "17141579283082165068",
            "participant_id": "15147759194081621226"
          },
          "name": "bb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 19,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "7789746726279450510",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7789746726279450510",
            "participant_id": "15147759194081621226"
          },
          "name": "bbb()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 21,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "1566308232035027228",
            "participant_id": "15147759194081621226"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7149594226225006621",
            "participant_id": "7149594226225006621"
          },
          "name": "R((lambda at t20012.cc:86:9) &&)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 7,
            "file": "t20012.cc",
            "line": 86,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "15809459607902663419",
            "participant_id": "11351025277027321892"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7149594226225006621",
            "participant_id": "7149594226225006621"
          },
          "name": "r()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20012.cc",
            "line": 88,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "13023711539577727870",
            "participant_id": "11351025277027321892"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13023711539577727870",
            "participant_id": "11351025277027321892"
          },
          "name": "operator()() const",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 54,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "7980939503032938975",
            "participant_id": "12185837463070188914"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7980939503032938975",
            "participant_id": "12185837463070188914"
          },
          "name": "c()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 18,
            "file": "t20012.cc",
            "line": 86,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "5402955322545804857",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "5402955322545804857",
            "participant_id": "16575664974290882098"
          },
          "name": "cc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 16,
            "file": "t20012.cc",
            "line": 29,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "11614573634522688457",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "11614573634522688457",
            "participant_id": "16575664974290882098"
          },
          "name": "ccc()",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 17,
            "file": "t20012.cc",
            "line": 31,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "15649131270396803681",
            "participant_id": "16575664974290882098"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7149594226225006621",
            "participant_id": "7149594226225006621"
          },
          "name": "operator()(auto) const",
          "return_type": "auto",
          "scope": "normal",
          "source_location": {
            "column": 9,
            "file": "t20012.cc",
            "line": 94,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "13006452698713945708",
            "participant_id": "12685488174106388182"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "13006452698713945708",
            "participant_id": "12685488174106388182"
          },
          "name": "add5(int) const",
          "return_type": "int",
          "scope": "normal",
          "source_location": {
            "column": 31,
            "file": "t20012.cc",
            "line": 94,
            "translation_unit": "t20012.cc"
          },
          "to": {
            "activity_id": "3032548472559015070",
            "participant_id": "13017810609178989903"
          },
          "type": "message"
        }
      ],
      "start_from": {
        "id": "7149594226225006621",
        "location": "clanguml::t20012::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20012"
}
```
## Generated GraphML models
