# t20011 - Recursive calls sequence diagram test case
## Config
```yaml
diagrams:
  t20011_sequence:
    type: sequence
    glob:
      - t20011.cc
    include:
      namespaces:
        - clanguml::t20011
    using_namespace: clanguml::t20011
    from:
      - function: "clanguml::t20011::tmain()"
```
## Source code
File `tests/t20011/t20011.cc`
```cpp
namespace clanguml {
namespace t20011 {

struct A {
    void a(int i = 10)
    {
        if (i > 0)
            a(i - 1);
    }

    void b(int i = 10) { c(i); }
    void c(int i) { d(i); }
    void d(int i)
    {
        if (i > 0)
            b(i - 1);
        else
            a();
    }
};

void tmain()
{
    A a;

    a.a();

    a.b();
}
}
}
```
## Generated PlantUML diagrams
![t20011_sequence](./t20011_sequence.svg "Recursive calls sequence diagram test case")
## Generated Mermaid diagrams
![t20011_sequence](./t20011_sequence_mermaid.svg "Recursive calls sequence diagram test case")
## Generated JSON models
```json
{
  "diagram_type": "sequence",
  "name": "t20011_sequence",
  "participants": [
    {
      "display_name": "tmain()",
      "full_name": "clanguml::t20011::tmain()",
      "id": "14929684217331129010",
      "name": "tmain",
      "namespace": "clanguml::t20011",
      "source_location": {
        "column": 6,
        "file": "t20011.cc",
        "line": 22,
        "translation_unit": "t20011.cc"
      },
      "type": "function"
    },
    {
      "activities": [
        {
          "display_name": "a(int)",
          "full_name": "clanguml::t20011::A::a(int)",
          "id": "13180626094721633652",
          "name": "a",
          "namespace": "clanguml::t20011",
          "source_location": {
            "column": 10,
            "file": "t20011.cc",
            "line": 5,
            "translation_unit": "t20011.cc"
          },
          "type": "method"
        },
        {
          "display_name": "b(int)",
          "full_name": "clanguml::t20011::A::b(int)",
          "id": "2443649406551003360",
          "name": "b",
          "namespace": "clanguml::t20011",
          "source_location": {
            "column": 10,
            "file": "t20011.cc",
            "line": 11,
            "translation_unit": "t20011.cc"
          },
          "type": "method"
        },
        {
          "display_name": "c(int)",
          "full_name": "clanguml::t20011::A::c(int)",
          "id": "7706149376639209694",
          "name": "c",
          "namespace": "clanguml::t20011",
          "source_location": {
            "column": 10,
            "file": "t20011.cc",
            "line": 12,
            "translation_unit": "t20011.cc"
          },
          "type": "method"
        },
        {
          "display_name": "d(int)",
          "full_name": "clanguml::t20011::A::d(int)",
          "id": "14994494098144009100",
          "name": "d",
          "namespace": "clanguml::t20011",
          "source_location": {
            "column": 10,
            "file": "t20011.cc",
            "line": 13,
            "translation_unit": "t20011.cc"
          },
          "type": "method"
        }
      ],
      "display_name": "A",
      "full_name": "clanguml::t20011::A",
      "id": "6528492016497026282",
      "name": "A",
      "namespace": "clanguml::t20011",
      "source_location": {
        "column": 8,
        "file": "t20011.cc",
        "line": 4,
        "translation_unit": "t20011.cc"
      },
      "type": "class"
    }
  ],
  "sequences": [
    {
      "messages": [
        {
          "from": {
            "activity_id": "14929684217331129010",
            "participant_id": "14929684217331129010"
          },
          "name": "a(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20011.cc",
            "line": 26,
            "translation_unit": "t20011.cc"
          },
          "to": {
            "activity_id": "13180626094721633652",
            "participant_id": "6528492016497026282"
          },
          "type": "message"
        },
        {
          "activity_id": "13180626094721633652",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "13180626094721633652",
                    "participant_id": "6528492016497026282"
                  },
                  "name": "a(int)",
                  "return_type": "void",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20011.cc",
                    "line": 8,
                    "translation_unit": "t20011.cc"
                  },
                  "to": {
                    "activity_id": "13180626094721633652",
                    "participant_id": "6528492016497026282"
                  },
                  "type": "message"
                }
              ],
              "type": "consequent"
            }
          ],
          "name": "if",
          "type": "alt"
        },
        {
          "from": {
            "activity_id": "14929684217331129010",
            "participant_id": "14929684217331129010"
          },
          "name": "b(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 5,
            "file": "t20011.cc",
            "line": 28,
            "translation_unit": "t20011.cc"
          },
          "to": {
            "activity_id": "2443649406551003360",
            "participant_id": "6528492016497026282"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "2443649406551003360",
            "participant_id": "6528492016497026282"
          },
          "name": "c(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 26,
            "file": "t20011.cc",
            "line": 11,
            "translation_unit": "t20011.cc"
          },
          "to": {
            "activity_id": "7706149376639209694",
            "participant_id": "6528492016497026282"
          },
          "type": "message"
        },
        {
          "from": {
            "activity_id": "7706149376639209694",
            "participant_id": "6528492016497026282"
          },
          "name": "d(int)",
          "return_type": "void",
          "scope": "normal",
          "source_location": {
            "column": 21,
            "file": "t20011.cc",
            "line": 12,
            "translation_unit": "t20011.cc"
          },
          "to": {
            "activity_id": "14994494098144009100",
            "participant_id": "6528492016497026282"
          },
          "type": "message"
        },
        {
          "activity_id": "14994494098144009100",
          "branches": [
            {
              "messages": [
                {
                  "from": {
                    "activity_id": "14994494098144009100",
                    "participant_id": "6528492016497026282"
                  },
                  "name": "b(int)",
                  "return_type": "void",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20011.cc",
                    "line": 16,
                    "translation_unit": "t20011.cc"
                  },
                  "to": {
                    "activity_id": "2443649406551003360",
                    "participant_id": "6528492016497026282"
                  },
                  "type": "message"
                },
                {
                  "from": {
                    "activity_id": "14994494098144009100",
                    "participant_id": "6528492016497026282"
                  },
                  "name": "a(int)",
                  "return_type": "void",
                  "scope": "normal",
                  "source_location": {
                    "column": 13,
                    "file": "t20011.cc",
                    "line": 18,
                    "translation_unit": "t20011.cc"
                  },
                  "to": {
                    "activity_id": "13180626094721633652",
                    "participant_id": "6528492016497026282"
                  },
                  "type": "message"
                },
                {
                  "activity_id": "13180626094721633652",
                  "branches": [
                    {
                      "messages": [
                        {
                          "from": {
                            "activity_id": "13180626094721633652",
                            "participant_id": "6528492016497026282"
                          },
                          "name": "a(int)",
                          "return_type": "void",
                          "scope": "normal",
                          "source_location": {
                            "column": 13,
                            "file": "t20011.cc",
                            "line": 8,
                            "translation_unit": "t20011.cc"
                          },
                          "to": {
                            "activity_id": "13180626094721633652",
                            "participant_id": "6528492016497026282"
                          },
                          "type": "message"
                        }
                      ],
                      "type": "consequent"
                    }
                  ],
                  "name": "if",
                  "type": "alt"
                }
              ],
              "type": "consequent"
            }
          ],
          "name": "if",
          "type": "alt"
        }
      ],
      "start_from": {
        "id": "14929684217331129010",
        "location": "clanguml::t20011::tmain()"
      }
    }
  ],
  "using_namespace": "clanguml::t20011"
}
```
## Generated GraphML models
